/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.Normalizer;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingDefaultsImpl;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingImpl;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.strats.MultiColumnVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.NoneDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.NoneVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.NumberVersionStrategy;
import org.apache.openjpa.jdbc.meta.strats.SubclassJoinDiscriminatorStrategy;
import org.apache.openjpa.jdbc.meta.strats.ValueMapDiscriminatorStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.meta.FieldMetaData;
import serp.util.Strings;

public class PersistenceMappingDefaults
extends MappingDefaultsImpl {
    private boolean _prependFieldNameToJoinTableInverseJoinColumns = true;

    public PersistenceMappingDefaults() {
        this.setDefaultMissingInfo(true);
        this.setStoreEnumOrdinal(true);
        this.setOrderLists(false);
        this.setAddNullIndicator(false);
        this.setDiscriminatorColumnName("DTYPE");
    }

    public boolean getPrependFieldNameToJoinTableInverseJoinColumns() {
        return this._prependFieldNameToJoinTableInverseJoinColumns;
    }

    public void setPrependFieldNameToJoinTableInverseJoinColumns(boolean val) {
        this._prependFieldNameToJoinTableInverseJoinColumns = val;
    }

    public Object getStrategy(Version vers, boolean adapt) {
        Object strat = super.getStrategy(vers, adapt);
        ClassMapping cls = vers.getClassMapping();
        if (strat != null || cls.getJoinablePCSuperclassMapping() != null || cls.getVersionField() != null) {
            return strat;
        }
        int nColumn = vers.getMappingInfo().getColumns().size();
        switch (nColumn) {
            case 0: {
                return NoneVersionStrategy.getInstance();
            }
            case 1: {
                return new NumberVersionStrategy();
            }
        }
        return new MultiColumnVersionStrategy();
    }

    public Object getStrategy(Discriminator disc, boolean adapt) {
        Object strat = super.getStrategy(disc, adapt);
        ClassMapping cls = disc.getClassMapping();
        if (strat != null || cls.getJoinablePCSuperclassMapping() != null || disc.getMappingInfo().getValue() != null) {
            return strat;
        }
        if (!disc.getMappingInfo().getColumns().isEmpty()) {
            return new ValueMapDiscriminatorStrategy();
        }
        ClassMapping base = cls;
        while (base.getMappingInfo().getHierarchyStrategy() == null && base.getPCSuperclassMapping() != null) {
            base = base.getPCSuperclassMapping();
        }
        strat = base.getMappingInfo().getHierarchyStrategy();
        if ("flat".equals(strat)) {
            return new ValueMapDiscriminatorStrategy();
        }
        if ("vertical".equals(strat) && this.dict.joinSyntax != 1) {
            return new SubclassJoinDiscriminatorStrategy();
        }
        return NoneDiscriminatorStrategy.getInstance();
    }

    public String getTableName(ClassMapping cls, Schema schema) {
        if (cls.getTypeAlias() != null) {
            return cls.getTypeAlias();
        }
        return Strings.getClassName(cls.getDescribedType()).replace('$', '_');
    }

    public String getTableName(FieldMapping fm, Schema schema) {
        return this.getTableIdentifier(fm, schema).getName();
    }

    public DBIdentifier getTableIdentifier(FieldMapping fm, Schema schema) {
        ClassMapping clm = fm.getDefiningMapping();
        Table table = this.getTable(clm);
        DBIdentifier sName = DBIdentifier.NULL;
        sName = fm.isElementCollection() ? DBIdentifier.newTable(clm.getTypeAlias()) : table.getIdentifier();
        ClassMapping rel = fm.getElementMapping().getTypeMapping();
        boolean assoc = rel != null && rel.getTable() != null && fm.getTypeCode() != 13;
        DBIdentifier sName2 = DBIdentifier.NULL;
        sName2 = assoc ? rel.getTable().getIdentifier() : DBIdentifier.newTable(fm.getName().replace('$', '_'));
        sName = DBIdentifier.combine(sName, sName2.getName());
        return sName;
    }

    private Table getTable(ClassMapping clm) {
        Table table = clm.getTable();
        if (table == null) {
            ValueMappingImpl value = (ValueMappingImpl)clm.getEmbeddingMetaData();
            if (value == null) {
                return table;
            }
            FieldMetaData field = value.getFieldMetaData();
            clm = (ClassMapping)field.getDefiningMetaData();
            return this.getTable(clm);
        }
        return table;
    }

    public void populateJoinColumn(FieldMapping fm, Table local, Table foreign, Column col, Object target, int pos, int cols) {
        if (!(target instanceof Column)) {
            return;
        }
        FieldMapping[] inverses = fm.getInverseMappings();
        DBIdentifier sName = DBIdentifier.NULL;
        sName = inverses.length > 0 ? DBIdentifier.newColumn(inverses[0].getName()) : DBIdentifier.newColumn(fm.getDefiningMapping().getTypeAlias());
        DBIdentifier targetName = ((Column)target).getIdentifier();
        DBIdentifier tempName = DBIdentifier.NULL;
        if (sName.length() + targetName.length() >= this.dict.maxColumnNameLength) {
            tempName = DBIdentifier.truncate(sName, this.dict.maxColumnNameLength - targetName.length() - 1);
        }
        if (DBIdentifier.isNull(tempName)) {
            tempName = sName;
        }
        sName = DBIdentifier.combine(tempName, targetName.getName());
        sName = this.dict.getValidColumnName(sName, foreign);
        col.setIdentifier(sName);
    }

    public void populateForeignKeyColumn(ValueMapping vm, String name, Table local, Table foreign, Column col, Object target, boolean inverse, int pos, int cols) {
        this.populateForeignKeyColumn(vm, DBIdentifier.newColumn(name), local, foreign, col, target, inverse, pos, cols);
    }

    public void populateForeignKeyColumn(ValueMapping vm, DBIdentifier sName, Table local, Table foreign, Column col, Object target, boolean inverse, int pos, int cols) {
        boolean elem;
        boolean bl = elem = vm == vm.getFieldMapping().getElement() && vm.getFieldMapping().getTypeCode() != 13;
        if (!this._prependFieldNameToJoinTableInverseJoinColumns && !inverse && elem) {
            return;
        }
        if (target instanceof Column) {
            if (DBIdentifier.isNull(sName)) {
                sName = col.getIdentifier();
            } else {
                if (elem) {
                    sName = DBIdentifier.newColumn(vm.getFieldMapping().getName());
                }
                if (this.isRemoveHungarianNotation()) {
                    sName = DBIdentifier.newColumn(Normalizer.removeHungarianNotation(sName.getName()));
                }
                sName = DBIdentifier.combine(sName, ((Column)target).getIdentifier().getName());
                sName = this.dict.getValidColumnName(sName, local, false);
            }
            col.setIdentifier(sName);
        }
    }

    public void populateColumns(Version vers, Table table, Column[] cols) {
        FieldMapping fm = vers.getClassMapping().getVersionFieldMapping();
        if (fm != null && cols.length == 1) {
            cols[0].setIdentifier(DBIdentifier.newColumn(fm.getName()));
        } else {
            super.populateColumns(vers, table, cols);
        }
    }
}

