/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.log4j;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.objectweb.util.monolog.wrapper.log4j.FileHandler;

public class DayFileHandler
extends FileHandler {
    private int lastDay;
    Calendar calendar = Calendar.getInstance();

    public DayFileHandler() {
    }

    public DayFileHandler(String name) {
        super(name);
    }

    protected void subAppend(LoggingEvent event) {
        super.subAppend(event);
        int currentDay = this.calendar.get(5);
        if (this.fileName != null && currentDay != this.lastDay) {
            this.closeWriter();
            Date d = this.calendar.getTime();
            StringBuffer sb = new StringBuffer();
            sb.append("_");
            sb.append(DateFormat.getDateInstance(1).format(d));
            sb.append("_");
            sb.append(DateFormat.getDateInstance(2).format(d));
            sb.append("_");
            sb.append(DateFormat.getDateInstance(11).format(d));
            sb.append("_");
            sb.append(this.fileName);
            File file = new File(sb.toString());
            try {
                this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
            }
            catch (IOException e) {
                LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
            }
            this.lastDay = currentDay;
        }
    }

    public void activateOptions() {
        this.lastDay = this.calendar.get(5);
        super.activateOptions();
    }
}

