/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.lib;

import java.util.Map;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.QueryNodeException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.query.api.NestQueryNode;
import org.objectweb.medor.query.api.NestedField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.lib.BasicNestedField;
import org.objectweb.medor.query.lib.BasicQueryNode;
import org.objectweb.util.monolog.api.BasicLevel;

public class Nest
extends BasicQueryNode
implements NestQueryNode {
    protected PropagatedField[] myGroupByFields = null;
    protected QueryTreeField[] theGroupByFields = null;
    protected NestedField nestedField = null;

    public Nest() {
    }

    public Nest(QueryTreeField[] groupedFields, String groupedFieldName, QueryTreeField[] groupByFields, String nodeName) throws MedorException {
        super(nodeName);
        boolean debug;
        boolean bl = debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)"Nest. Super() done. Entering core.");
        }
        this.myGroupByFields = new PropagatedField[groupByFields.length];
        this.theGroupByFields = new QueryTreeField[groupByFields.length];
        for (int i = 0; i < groupByFields.length; ++i) {
            this.theGroupByFields[i] = groupByFields[i];
        }
        this.replaceNestedField(groupedFieldName, groupedFields);
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Checking number of children for " + this));
        }
        QueryTree[] theChildren = this.getChildren();
        if (debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Found " + theChildren.length + " chid(ren) for Nest node"));
        }
        if (theChildren.length > 1) {
            throw new QueryNodeException("Too many children for this Nest node");
        }
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        Nest n = (Nest)clone;
        n.nestedField = (NestedField)Nest.getClone(this.nestedField, obj2clone);
        if (this.myGroupByFields != null) {
            n.myGroupByFields = new PropagatedField[this.myGroupByFields.length];
            for (int i = 0; i < this.myGroupByFields.length; ++i) {
                n.myGroupByFields[i] = (PropagatedField)Nest.getClone(this.myGroupByFields[i], obj2clone);
            }
        }
        return clone;
    }

    public NestedField replaceNestedField(String name, Field[] grouped) throws MedorException {
        if (this.nestedField != null) {
            this.removeField(this.nestedField.getName());
        }
        BasicNestedField newField = new BasicNestedField(name, this, grouped);
        this.addField(newField);
        this.nestedField = newField;
        this.updateChildren();
        return newField;
    }

    public void setQueryFilter(Expression e) {
        throw new UnsupportedOperationException("Nest query nodes cannot be assigned a filter.");
    }

    public QueryTreeField[] getNestingFields() {
        return this.theGroupByFields;
    }

    public QueryTreeField getNestingField(String fieldName) {
        for (int i = 0; i < this.theGroupByFields.length; ++i) {
            if (!this.theGroupByFields[i].getName().equals(fieldName)) continue;
            return this.theGroupByFields[i];
        }
        return null;
    }

    public NestedField getNestedField() {
        return this.nestedField;
    }

    public QueryTreeField replaceNestingField(QueryTreeField old, QueryTreeField neo) {
        boolean debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
        for (int i = 0; i < this.theGroupByFields.length; ++i) {
            if (!this.theGroupByFields[i].equals(old)) continue;
            this.theGroupByFields[i] = neo;
            return neo;
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("Field not found " + old));
        return null;
    }

    public short getType() {
        return 4;
    }
}

