/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.rdb.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.CalculatedParameterOperand;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.UnaryOperator;
import org.objectweb.medor.expression.converter.rdb.Expression2WhereClauseImpl;
import org.objectweb.medor.expression.lib.Equal;
import org.objectweb.medor.expression.lib.NotEqual;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.lib.InCollection;
import org.objectweb.medor.filter.lib.IsEmpty;
import org.objectweb.medor.filter.lib.IsNull;
import org.objectweb.medor.filter.lib.MemberOf;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.rdb.api.RdbExpField;
import org.objectweb.medor.query.rdb.lib.BasicRdbExpQueryLeaf;

public class MedorExpression2WhereClause
extends Expression2WhereClauseImpl {
    public static final Integer POS = new Integer(1);
    public static final Integer QUERY_LEAF = new Integer(2);

    public static String e2where(Expression exp, RdbAdapter rdbAdapter, BasicRdbExpQueryLeaf ql, ParameterOperand[] pos) throws ExpressionException {
        HashMap<Integer, Object> ctx = new HashMap<Integer, Object>();
        ctx.put(POS, pos);
        ctx.put(QUERY_LEAF, ql);
        return Expression2WhereClauseImpl.e2where(exp, rdbAdapter, ctx);
    }

    private static ParameterOperand[] getPos(Map ctx) {
        return (ParameterOperand[])ctx.get(POS);
    }

    private static ParameterOperand getPO(ParameterOperand[] pos, String paramName) {
        if (pos != null) {
            for (int i = 0; i < pos.length; ++i) {
                if (!paramName.equals(pos[i].getName())) continue;
                return pos[i];
            }
        }
        return null;
    }

    private BasicRdbExpQueryLeaf getQL(Map ctx) {
        return (BasicRdbExpQueryLeaf)ctx.get(QUERY_LEAF);
    }

    public void convertExp2WhereClause(Expression exp, RdbAdapter rdbAdapter, StringBuffer sb, Map ctx) throws ExpressionException {
        if (exp instanceof FieldOperand) {
            sb.append(BasicRdbExpQueryLeaf.getQualifiedFieldName((RdbExpField)((FieldOperand)exp).getField()));
        } else if (exp instanceof InCollection) {
            InCollection bo = (InCollection)exp;
            sb.append("(");
            this.convertExp2WhereClause(bo.getExpression(0), rdbAdapter, sb, ctx);
            sb.append(" ");
            sb.append(this.toSqlOperator(bo.getOperatorString()));
            sb.append(" ");
            this.getSQLEnumeration(bo.getExpression(1), bo.getElemType(), MedorExpression2WhereClause.getPos(ctx), sb);
            sb.append(")");
        } else if (exp instanceof MemberOf) {
            MemberOf mo = (MemberOf)exp;
            int size = mo.getOperandNumber() / 2;
            sb.append("(");
            for (int i = 0; i < size; ++i) {
                this.convertExp2WhereClause(mo.getExpression(i), rdbAdapter, sb, ctx);
                sb.append(i < size - 1 ? ", " : "");
            }
            sb.append(" IN (");
            FieldOperand fop = (FieldOperand)mo.getExpression(size);
            this.appendSubquery(fop, rdbAdapter, sb, ctx);
            sb.append("))");
        } else if (exp instanceof IsEmpty) {
            IsEmpty ie = (IsEmpty)exp;
            sb.append(" NOT EXISTS (");
            Expression e = ie.getExpression(0);
            if (!(e instanceof FieldOperand)) {
                throw new IllegalStateException("can't handle operand type: " + e);
            }
            this.appendSubquery((FieldOperand)e, rdbAdapter, sb, ctx);
            sb.append(")");
        } else if (exp instanceof IsNull) {
            this.convertExp2WhereClause(((UnaryOperator)exp).getExpression(0), rdbAdapter, sb, ctx);
            sb.append(" ");
            sb.append(this.toSqlOperator(((Operator)exp).getOperatorString()));
        } else if (exp instanceof Equal || exp instanceof NotEqual) {
            boolean nullValue_1;
            Operator op = (Operator)exp;
            boolean nullValue_0 = MedorExpression2WhereClause.isNullParameterOperand(op.getExpression(0), ctx);
            if (nullValue_0 ^ (nullValue_1 = MedorExpression2WhereClause.isNullParameterOperand(op.getExpression(1), ctx))) {
                Expression e = nullValue_0 ? op.getExpression(1) : op.getExpression(0);
                IsNull isnull = new IsNull(e);
                if (exp instanceof NotEqual) {
                    isnull.setNot(true);
                }
                this.convertExp2WhereClause(isnull, rdbAdapter, sb, ctx);
            } else {
                super.convertExp2WhereClause(exp, rdbAdapter, sb, ctx);
            }
        } else {
            super.convertExp2WhereClause(exp, rdbAdapter, sb, ctx);
        }
    }

    private void appendSubquery(FieldOperand fop, RdbAdapter rdbAdapter, StringBuffer sb, Map ctx) throws ExpressionException {
        QueryTreeField qtf = (QueryTreeField)fop.getField();
        BasicRdbExpQueryLeaf leaf = (BasicRdbExpQueryLeaf)qtf.getQueryTree();
        if (leaf == this.getQL(ctx)) {
            throw new ExpressionException("can't append self as a subquery " + qtf.getName());
        }
        leaf.setRdbAdapter(rdbAdapter);
        try {
            sb.append(leaf.getSqlRequest(null, false, false));
        }
        catch (MedorException e) {
            throw new ExpressionException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getSQLEnumeration(Expression e, PType elemType, ParameterOperand[] pos, StringBuffer sb) throws ExpressionException {
        Iterator it;
        Collection c = null;
        sb.append("(");
        if (e instanceof ParameterOperand) {
            int i;
            String pn = ((ParameterOperand)e).getName();
            if (pos == null || pos.length == 0) {
                throw new ExpressionException("No Parameter");
            }
            for (i = 0; i < pos.length && !pn.equals(pos[i].getName()); ++i) {
            }
            if (i >= pos.length) throw new ExpressionException("Parameter " + pn + " not found");
            c = (Collection)pos[i].getObject();
        } else {
            c = (Collection)((Operand)e).getObject();
        }
        if (!(it = c.iterator()).hasNext()) {
            throw new ExpressionException("Empty collection for InCollection operator");
        }
        while (it.hasNext()) {
            Object nextit = it.next();
            if (nextit instanceof ParameterOperand) {
                sb.append("?");
            } else if (elemType.equals(PTypeSpace.STRING)) {
                sb.append("'");
                sb.append(nextit);
                sb.append("'");
            } else {
                sb.append(nextit);
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
    }

    public void convertExp2WhereClauseBuilder(Expression exp, String rdbAdapterVarName, StringBuffer sb, Map ctx) throws ExpressionException {
        if (exp instanceof FieldOperand) {
            sb.append(BasicRdbExpQueryLeaf.getQualifiedFieldName((RdbExpField)((FieldOperand)exp).getField()));
        } else if (exp instanceof InCollection) {
            InCollection bo = (InCollection)exp;
            sb.append("(");
            this.convertExp2WhereClauseBuilder(bo.getExpression(0), rdbAdapterVarName, sb, ctx);
            sb.append(" ");
            sb.append(this.toSqlOperator(bo.getOperatorString()));
            sb.append(" ");
            this.getSQLEnumeration(bo.getExpression(1), bo.getElemType(), MedorExpression2WhereClause.getPos(ctx), sb);
            sb.append(")");
        } else {
            if (exp instanceof MemberOf) {
                throw new ExpressionException("MemberOf Operator not yet supported at generation time");
            }
            if (exp instanceof IsNull) {
                this.convertExp2WhereClauseBuilder(((Operator)exp).getExpression(0), rdbAdapterVarName, sb, ctx);
                sb.append(" ");
                sb.append(this.toSqlOperator(((Operator)exp).getOperatorString()));
            } else {
                super.convertExp2WhereClauseBuilder(exp, rdbAdapterVarName, sb, ctx);
            }
        }
    }

    public static boolean isNullParameterOperand(Expression e, Map ctx) throws ExpressionException {
        if (e instanceof ParameterOperand) {
            ParameterOperand[] pos = MedorExpression2WhereClause.getPos(ctx);
            if (pos == null) {
                return false;
            }
            ParameterOperand po = MedorExpression2WhereClause.getPO(pos, ((ParameterOperand)e).getName());
            if (po != null && MedorExpression2WhereClause.isJavaObject(e.getType())) {
                if (e instanceof CalculatedParameterOperand) {
                    ((CalculatedParameterOperand)e).evaluate(pos);
                    return ((CalculatedParameterOperand)e).getObject() == null;
                }
                return po.getObject() == null;
            }
        }
        return false;
    }

    public static boolean isJavaObject(PType t) {
        switch (t.getTypeCode()) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 204: {
                return true;
            }
        }
        return false;
    }
}

