/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ws.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.jar.JarFile;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.digester.JDigester;
import org.ow2.jonas.deployment.ws.JaxrpcMappingSchemas;
import org.ow2.jonas.deployment.ws.MappingFile;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;
import org.ow2.jonas.deployment.ws.rules.JavaWsdlMappingRuleSet;
import org.ow2.jonas.deployment.ws.xml.JavaWsdlMapping;
import org.ow2.jonas.lib.util.Log;

public class MappingFileManager {
    private static JDigester mfDigester = null;
    private static JavaWsdlMappingRuleSet mfRuleSet = new JavaWsdlMappingRuleSet();
    private static boolean parsingWithValidation = true;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.ws");

    private MappingFileManager() {
    }

    public static MappingFile getInstance(File module, String filename) throws WSDeploymentDescException {
        InputStream is = MappingFileManager.openStream(module, filename);
        return new MappingFile(MappingFileManager.loadMappingFile(new InputStreamReader(is), filename));
    }

    public static MappingFile getInstance(Reader r, String filename, boolean validate) throws WSDeploymentDescException {
        parsingWithValidation = validate;
        return new MappingFile(MappingFileManager.loadMappingFile(r, filename));
    }

    public static MappingFile getInstance(InputStream is, String filename) throws WSDeploymentDescException {
        return new MappingFile(MappingFileManager.loadMappingFile(new InputStreamReader(is), filename));
    }

    private static InputStream openStream(File module, String filename) throws WSDeploymentDescException {
        InputStream isMapping = null;
        if (module.exists()) {
            if (module.isFile()) {
                JarFile jf = null;
                try {
                    jf = new JarFile(module.getAbsolutePath());
                    isMapping = jf.getInputStream(jf.getEntry(filename));
                }
                catch (Exception e) {
                    if (jf != null) {
                        try {
                            jf.close();
                        }
                        catch (IOException i) {
                            logger.log(BasicLevel.WARN, (Object)("Can't close '" + module + "'"));
                        }
                    }
                    throw new WSDeploymentDescException("Cannot read the jaxrpc-mapping-file " + filename + " in " + module.getAbsolutePath(), e);
                }
            }
            try {
                isMapping = new FileInputStream(new File(module, filename));
            }
            catch (IOException ioe) {
                throw new WSDeploymentDescException("Cannot read the jaxrpc-mapping-file " + filename + " in " + module.getAbsolutePath(), ioe);
            }
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        isMapping = loader.getResourceAsStream(filename);
        return isMapping;
    }

    private static JavaWsdlMapping loadMappingFile(Reader reader, String fileName) throws WSDeploymentDescException {
        JavaWsdlMapping jwm = new JavaWsdlMapping();
        if (mfDigester == null) {
            try {
                mfDigester = new JDigester(mfRuleSet, parsingWithValidation, true, null, new JaxrpcMappingSchemas());
            }
            catch (DeploymentDescException e) {
                throw new WSDeploymentDescException(e);
            }
        }
        try {
            mfDigester.parse(reader, fileName, jwm);
        }
        catch (DeploymentDescException e) {
            throw new WSDeploymentDescException(e);
        }
        finally {
            mfDigester.push(null);
        }
        return jwm;
    }

    public static boolean isParsingWithValidation() {
        return parsingWithValidation;
    }

    public static void setParsingWithValidation(boolean parsingWithValidation) {
        MappingFileManager.parsingWithValidation = parsingWithValidation;
    }
}

