/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.measurement;

import org.osgi.util.measurement.Unit;

public class Measurement
implements Comparable {
    private final double value;
    private final double error;
    private final long time;
    private final Unit unit;
    private volatile transient String name;
    private volatile transient int hashCode;

    public Measurement(double value, double error, Unit unit, long time) {
        this.value = value;
        this.error = Math.abs(error);
        this.unit = unit != null ? unit : Unit.unity;
        this.time = time;
    }

    public Measurement(double value, double error, Unit unit) {
        this(value, error, unit, 0L);
    }

    public Measurement(double value, Unit unit) {
        this(value, 0.0, unit, 0L);
    }

    public Measurement(double value) {
        this(value, 0.0, null, 0L);
    }

    public final double getValue() {
        return this.value;
    }

    public final double getError() {
        return this.error;
    }

    public final Unit getUnit() {
        return this.unit;
    }

    public final long getTime() {
        return this.time;
    }

    public Measurement mul(Measurement m) {
        double mvalue = m.value;
        return new Measurement(this.value * mvalue, Math.abs(this.value) * m.error + this.error * Math.abs(mvalue), this.unit.mul(m.unit), this.time);
    }

    public Measurement mul(double d, Unit u) {
        return new Measurement(this.value * d, this.error * Math.abs(d), this.unit.mul(u), this.time);
    }

    public Measurement mul(double d) {
        return new Measurement(this.value * d, this.error * Math.abs(d), this.unit, this.time);
    }

    public Measurement div(Measurement m) {
        double mvalue = m.value;
        return new Measurement(this.value / mvalue, (Math.abs(this.value) * m.error + this.error * Math.abs(mvalue)) / (mvalue * mvalue), this.unit.div(m.unit), this.time);
    }

    public Measurement div(double d, Unit u) {
        return new Measurement(this.value / d, this.error / Math.abs(d), this.unit.div(u), this.time);
    }

    public Measurement div(double d) {
        return new Measurement(this.value / d, this.error / Math.abs(d), this.unit, this.time);
    }

    public Measurement add(Measurement m) {
        return new Measurement(this.value + m.value, this.error + m.error, this.unit.add(m.unit), this.time);
    }

    public Measurement add(double d, Unit u) {
        return new Measurement(this.value + d, this.error, this.unit.add(u), this.time);
    }

    public Measurement add(double d) {
        return new Measurement(this.value + d, this.error, this.unit, this.time);
    }

    public Measurement sub(Measurement m) {
        return new Measurement(this.value - m.value, this.error + m.error, this.unit.sub(m.unit), this.time);
    }

    public Measurement sub(double d, Unit u) {
        return new Measurement(this.value - d, this.error, this.unit.sub(u), this.time);
    }

    public Measurement sub(double d) {
        return new Measurement(this.value - d, this.error, this.unit, this.time);
    }

    public String toString() {
        String result = this.name;
        if (result == null) {
            String u;
            StringBuffer sb = new StringBuffer();
            sb.append(this.value);
            if (this.error != 0.0) {
                sb.append(" +/- ");
                sb.append(this.error);
            }
            if ((u = this.unit.toString()).length() > 0) {
                sb.append(" ");
                sb.append(u);
            }
            this.name = result = ((Object)sb).toString();
        }
        return result;
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        Measurement that = (Measurement)obj;
        if (!this.unit.equals(that.unit)) {
            throw new ArithmeticException("Cannot compare " + this + " and " + that);
        }
        int result = Double.compare(this.value, that.value);
        if (result == 0) {
            return 0;
        }
        if (result < 0) {
            if (Double.compare(this.value + this.error, that.value - that.error) >= 0) {
                return 0;
            }
            return -1;
        }
        if (Double.compare(this.value - this.error, that.value + that.error) <= 0) {
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            long bits = Double.doubleToLongBits(this.value);
            h = 527 + (int)(bits ^ bits >>> 32);
            bits = Double.doubleToLongBits(this.error);
            h = 31 * h + (int)(bits ^ bits >>> 32);
            this.hashCode = h = 31 * h + this.unit.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Measurement)) {
            return false;
        }
        Measurement that = (Measurement)obj;
        return Double.compare(this.value, that.value) == 0 && Double.compare(this.error, that.error) == 0 && this.unit.equals(that.unit);
    }
}

