/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.generator;

import java.util.List;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenInfos;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenJoin;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenRef;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenTable;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.type.api.PType;

public class RdbGenColumn {
    public String fieldName = null;
    public boolean hiddenField = true;
    public String constant;
    public String columnName = null;
    public int columnSize = -1;
    public int columnScale = -1;
    public PType columnType = null;
    public boolean columnNotNull = false;
    public boolean columnInPK = false;
    public RdbGenTable table = null;
    public String columnSqlType = null;
    public RdbGenColumn joinCol = null;
    public List joins = null;
    public List pes = null;

    public RdbGenColumn getJoinCol() {
        return this.joinCol;
    }

    public String getColumnSqlType() {
        return this.columnSqlType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldName(RdbGenJoin rgj) throws PException {
        if (rgj != null && this.joins != null) {
            int idx = this.joins.indexOf(rgj);
            if (idx == -1) {
                throw new PException("No field found for the column " + this.columnName + " with the join " + rgj);
            }
            return ((PrimitiveElement)this.pes.get(idx)).getName();
        }
        return this.fieldName;
    }

    public String getConstant() {
        return this.constant;
    }

    public List getJoins() {
        return this.joins;
    }

    public boolean isHiddenField() {
        return this.hiddenField;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public PType getColumnType() {
        return this.columnType;
    }

    public boolean isColumnNotNull() {
        return this.columnNotNull;
    }

    public boolean isColumnInPK() {
        return this.columnInPK;
    }

    public RdbGenTable getTable() {
        return this.table;
    }

    public String getColumnNotNull() {
        return "" + this.columnNotNull;
    }

    public String getColumnInPK() {
        return "" + this.columnInPK();
    }

    public boolean columnInPK() {
        if (this.table.isMainTable) {
            return this.table.genInfos.colInGenId(this);
        }
        if (this.table.colocatedTable) {
            return false;
        }
        return this.joinCol != null;
    }

    public String getSqlType(String adapter) throws PException {
        if (this.columnSqlType != null) {
            return "\"" + this.columnSqlType + "\"";
        }
        StringBuffer sb = new StringBuffer(adapter);
        sb.append(".getSqlType(");
        sb.append(this.columnType.getProgName());
        sb.append(".getTypeCode(), ");
        sb.append(this.columnInPK());
        sb.append(", ");
        sb.append(this.columnSize);
        sb.append(", ");
        sb.append(this.columnScale);
        sb.append(")");
        return sb.toString();
    }

    public String getSqlGet(String adapter, String resultset, String pos, String nullValue) throws PException {
        StringBuffer sb = new StringBuffer(adapter);
        sb.append(".");
        sb.append(this.getAdapterGet(this.columnType));
        sb.append("(");
        sb.append(resultset);
        sb.append(", ");
        sb.append(pos);
        switch (this.columnType.getTypeCode()) {
            case 17: {
                sb.append(", ");
                if (this.columnSqlType != null && this.columnSqlType.length() > 0) {
                    sb.append("\"");
                }
                sb.append(this.columnSqlType);
                if (this.columnSqlType == null || this.columnSqlType.length() <= 0) break;
                sb.append("\"");
            }
        }
        sb.append(", ");
        if (nullValue != null && nullValue.length() > 0) {
            sb.append(nullValue);
        } else {
            sb.append(this.getNullValue());
        }
        sb.append(")");
        return sb.toString();
    }

    public String getNullValue() {
        switch (this.columnType.getTypeCode()) {
            case 0: {
                return "false";
            }
            case 1: {
                return "((" + this.columnType.getJavaName() + ") 0)";
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return "((" + this.columnType.getJavaName() + ") -1)";
            }
        }
        return "null";
    }

    public String getSqlSet(String adapter, String pstmt, String value, int pos) throws PException {
        StringBuffer sb = new StringBuffer(adapter);
        sb.append(".");
        sb.append(this.getAdapterSet(this.columnType));
        sb.append("(");
        sb.append(pstmt);
        sb.append(", ");
        sb.append(pos);
        sb.append(", ");
        sb.append(value);
        switch (this.columnType.getTypeCode()) {
            case 17: {
                sb.append(", ");
                if (this.columnSqlType != null && this.columnSqlType.length() > 0) {
                    sb.append("\"");
                }
                sb.append(this.columnSqlType);
                if (this.columnSqlType == null || this.columnSqlType.length() <= 0) break;
                sb.append("\"");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public String getAdapterGet(PType type) {
        return "get" + this.getAdapterSuffix(type);
    }

    public String getAdapterSet(PType type) {
        return "set" + this.getAdapterSuffix(type);
    }

    private String getAdapterSuffix(PType type) {
        switch (type.getTypeCode()) {
            case 19: {
                return "ByteArray";
            }
            case 0: {
                return "Boolean";
            }
            case 8: {
                return "Oboolean";
            }
            case 6: {
                return "Float";
            }
            case 14: {
                return "Ofloat";
            }
            case 7: {
                return "Double";
            }
            case 15: {
                return "Odouble";
            }
            case 20: {
                return "Serialized";
            }
        }
        return type.getCodingName();
    }

    public String getSqlTypeCode(PType pt) throws PException {
        StringBuffer sb = new StringBuffer("adapter.getSqlTypeCode(");
        sb.append(pt.getProgName());
        sb.append(".getTypeCode(), ");
        if (this.columnSqlType != null && this.columnSqlType.length() > 0) {
            sb.append("\"");
        }
        sb.append(this.columnSqlType);
        if (this.columnSqlType != null && this.columnSqlType.length() > 0) {
            sb.append("\"");
        }
        sb.append(")");
        return sb.toString();
    }

    public String getAccessorValue(RdbGenInfos genInfos, boolean isSpecific) throws Exception {
        return this.getAccessorValue(genInfos, isSpecific, null);
    }

    public String getValue(RdbGenInfos genInfos, boolean isSpecific) throws Exception {
        return this.getValue(genInfos, isSpecific, null);
    }

    public String getValue(RdbGenInfos genInfos, boolean isSpecific, RdbGenJoin rgj) throws Exception {
        if (this.constant == null) {
            if (this.isHiddenField()) {
                return this.getRefValue(genInfos, isSpecific, rgj);
            }
            return this.getAccessorValue(genInfos, isSpecific, rgj);
        }
        if (this.constant instanceof String) {
            return "\"" + this.constant + "\"";
        }
        return this.constant;
    }

    public String getAccessorValue(RdbGenInfos genInfos, boolean isSpecific, RdbGenJoin rgj) throws Exception {
        if (this.hiddenField) {
            if (genInfos.colInGenId(this)) {
                throw new PException("unmanaged case");
            }
            RdbGenRef gen_ref = genInfos.getGenRefOfColumn(this, rgj);
            if (isSpecific) {
                return "paccessor.paGet" + RdbGenInfos.commonHelper.upperFL(gen_ref.fieldName) + "(conn)";
            }
            return "paccessorGen.paGetRefField(" + gen_ref.fieldName + "_NAME, conn)";
        }
        if (isSpecific) {
            return "paccessor.paGet" + RdbGenInfos.commonHelper.upperFL(this.getFieldName(rgj)) + "()";
        }
        return "paccessorGen." + RdbGenInfos.commonHelper.getPaGetMethod(this.columnType) + "(" + this.getFieldName(rgj) + "_NAME)";
    }

    public String getRefValue(RdbGenInfos genInfos, boolean isSpecific) throws Exception {
        return this.getRefValue(genInfos, isSpecific, null);
    }

    public String getRefValue(RdbGenInfos genInfos, boolean isSpecific, RdbGenJoin rgj) throws Exception {
        try {
            if (!this.hiddenField) {
                throw new PException("unmanaged case");
            }
            RdbGenRef gen_ref = null;
            if (genInfos.colInGenId(this)) {
                gen_ref = genInfos.genId;
                if (gen_ref.refColumn != null) {
                    return "pname." + RdbGenInfos.commonHelper.getPNameEncodeFunction(this.columnType) + "()";
                }
                return "_pngId.pnGet" + RdbGenInfos.commonHelper.upperFL(gen_ref.getFieldName(this)) + "(null)";
            }
            gen_ref = genInfos.getGenRefOfColumn(this, rgj);
            if (gen_ref == null) {
                System.out.println("Pb in getRefValue of column '" + this.getColumnName() + "', constant=" + this.constant);
                return "JORM_GENERATION_ERROR";
            }
            if (gen_ref.refColumn != null) {
                return gen_ref.fieldName + "Pnc." + RdbGenInfos.commonHelper.getPNameEncodeFunction(this.columnType) + "(" + this.getAccessorValue(genInfos, isSpecific, rgj) + ")";
            }
            return "png" + gen_ref.cnId + ".pnGet" + RdbGenInfos.commonHelper.upperFL(gen_ref.getFieldName(this)) + "(null)";
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            throw e;
        }
    }

    public String getColumnName(String tableSuffix) {
        return this.table.tableName + (tableSuffix == null ? "" : tableSuffix) + "." + this.columnName;
    }

    public boolean isInJoin(RdbGenJoin rgj) {
        return this.joins != null && this.joins.contains(rgj) || rgj.getJoinColumnsInExt().contains(this);
    }

    public boolean equals(RdbGenColumn rgc) {
        if (rgc == null) {
            return false;
        }
        return (this.columnName == null ? rgc.columnName == null : this.columnName.equals(rgc.columnName)) && (this.table == null ? rgc.table == null : this.table.tableName.equals(rgc.table.tableName)) && (this.columnSqlType == null ? rgc.columnSqlType == null : this.columnSqlType.equals(rgc.columnSqlType)) && this.columnType == rgc.columnType && (this.fieldName == null ? rgc.fieldName == null : this.fieldName.equals(rgc.fieldName)) && this.hiddenField == rgc.hiddenField && (this.joinCol == null ? rgc.joinCol == null : this.joinCol.equals(rgc.joinCol)) && this.columnInPK == rgc.columnInPK && this.columnNotNull == rgc.columnNotNull && this.columnScale == rgc.columnScale && (this.constant == null ? rgc.constant == null : this.constant.equals(rgc.constant));
    }
}

