/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.config.Configuration;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.MessageReceptor;
import org.jacorb.slf4j.Logger;
import org.jacorb.util.threadpool.Consumer;
import org.jacorb.util.threadpool.ConsumerFactory;
import org.jacorb.util.threadpool.ThreadPool;

public class MessageReceptorPool {
    private static final int MAX_DEFAULT = 1000;
    private static final int MAX_IDLE_DEFAULT = 5;
    private final ThreadPool pool;

    public MessageReceptorPool(String string, String string2, Configuration configuration) {
        if (!"server".equals(string) && !"client".equals(string)) {
            throw new IllegalArgumentException("must be client or server");
        }
        final Configuration configuration2 = configuration;
        int n = configuration2.getAttributeAsInteger("jacorb.connection." + string + ".max_receptor_threads", 1000);
        int n2 = configuration2.getAttributeAsInteger("jacorb.connection." + string + ".max_idle_receptor_threads", 5);
        Logger logger = configuration2.getLogger("jacorb.orb.giop");
        if (logger.isDebugEnabled()) {
            logger.debug("Maximum connection threads: " + n);
            logger.debug("Maximum idle threads: " + n2);
        }
        this.pool = new ThreadPool(configuration2, string2, new ConsumerFactory(){

            public Consumer create() {
                return new MessageReceptor(configuration2);
            }
        }, n, n2);
    }

    public void connectionCreated(GIOPConnection gIOPConnection) {
        this.pool.putJob(gIOPConnection);
    }

    public void shutdown() {
        this.pool.shutdown();
    }
}

