/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.DefaultProfileSelector;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ProfileSelector;
import org.jacorb.orb.diop.DIOPFactories;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.TransportListener;
import org.jacorb.slf4j.Logger;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Factories;

public class TransportManager
implements Configurable {
    private Configuration configuration = null;
    private Logger logger = null;
    private List factoryClassNames = null;
    private ProfileSelector profileSelector = null;
    private final SocketFactoryManager socketFactoryManager;
    private Map factoriesMap = null;
    private List factoriesList = null;
    private TransportListener listener = null;

    public TransportManager(ORB oRB) {
        this.socketFactoryManager = new SocketFactoryManager(oRB);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.logger = this.configuration.getLogger("jacorb.orb.giop");
        this.socketFactoryManager.configure(this.configuration);
        this.factoryClassNames = this.configuration.getAttributeList("jacorb.transport.factories");
        if (this.factoryClassNames.isEmpty()) {
            this.factoryClassNames.add("org.jacorb.orb.iiop.IIOPFactories");
        }
        this.profileSelector = (ProfileSelector)this.configuration.getAttributeAsObject("jacorb.transport.client.selector");
        if (this.profileSelector == null) {
            this.profileSelector = new DefaultProfileSelector();
        }
    }

    public ProfileSelector getProfileSelector() {
        return this.profileSelector;
    }

    public SocketFactoryManager getSocketFactoryManager() {
        return this.socketFactoryManager;
    }

    public synchronized Factories getFactories(int n) {
        if (n == 1413566212) {
            return DIOPFactories.getDIOPFactory();
        }
        if (this.factoriesMap == null) {
            this.loadFactories();
        }
        return (Factories)this.factoriesMap.get(ObjectUtil.newInteger(n));
    }

    public synchronized List getFactoriesList() {
        if (this.factoriesList == null) {
            this.loadFactories();
        }
        return Collections.unmodifiableList(this.factoriesList);
    }

    private void loadFactories() {
        if (this.configuration == null) {
            throw new BAD_INV_ORDER("TransportManager not configured!");
        }
        if (this.factoryClassNames == null) {
            throw new INTERNAL("factoryClassNames may not be null");
        }
        this.factoriesMap = new HashMap();
        this.factoriesList = new ArrayList();
        for (String string : this.factoryClassNames) {
            Factories factories = this.instantiateFactories(string);
            this.factoriesMap.put(new Integer(factories.profile_tag()), factories);
            this.factoriesList.add(factories);
        }
    }

    private Factories instantiateFactories(String string) {
        try {
            Class clazz = ObjectUtil.classForName(string);
            Object t = clazz.newInstance();
            if (t instanceof Configurable) {
                Configurable configurable = (Configurable)t;
                configurable.configure(this.configuration);
            }
            this.logger.debug("created org.omg.ETF.Factories: " + string);
            return (Factories)t;
        }
        catch (Exception exception) {
            throw new BAD_PARAM("could not instantiate Factories class " + string + ", exception: " + exception);
        }
    }

    public void notifyTransportListeners(GIOPConnection gIOPConnection) {
        if (this.listener != null) {
            this.listener.transportSelected(new TransportListener.Event(gIOPConnection));
        }
    }

    public void addTransportListener(TransportListener transportListener) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Transport listener to add: " + transportListener);
        }
        if (transportListener != null) {
            this.addTransportListenerImpl(transportListener);
        }
    }

    private synchronized void addTransportListenerImpl(final TransportListener transportListener) {
        this.listener = this.listener == null ? transportListener : new TransportListener(){
            private final TransportListener next_;
            {
                this.next_ = TransportManager.this.listener;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transportSelected(TransportListener.Event event) {
                try {
                    transportListener.transportSelected(event);
                }
                finally {
                    this.next_.transportSelected(event);
                }
            }
        };
    }
}

