/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPLoopback;
import org.jacorb.orb.iiop.IIOPLoopbackInputStream;
import org.jacorb.orb.iiop.IIOPLoopbackOutputStream;
import org.jacorb.orb.iiop.IIOPLoopbackRegistry;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.listener.TCPConnectionEvent;
import org.jacorb.orb.listener.TCPConnectionListener;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.Profile;

public class ClientIIOPConnection
extends IIOPConnection
implements Configurable {
    private int timeout = 0;
    private int ssl_port = -1;
    private int noOfRetries = 5;
    private int retryInterval = 0;
    private boolean doSupportSSL = false;
    private TransportManager transportManager;
    private TCPConnectionListener connectionListener;
    private boolean keepAlive;
    public static int openTransports = 0;

    public ClientIIOPConnection() {
        this.use_ssl = false;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.timeout = configuration.getAttributeAsInteger("jacorb.connection.client.idle_timeout", 0);
        this.noOfRetries = configuration.getAttributeAsInteger("jacorb.retries", 5);
        this.retryInterval = configuration.getAttributeAsInteger("jacorb.retry_interval", 500);
        this.doSupportSSL = configuration.getAttributeAsBoolean("jacorb.security.support_ssl", false);
        this.transportManager = this.configuration.getORB().getTransportManager();
        this.keepAlive = configuration.getAttributeAsBoolean("jacorb.connection.client.keepalive", false);
        this.connectionListener = this.transportManager.getSocketFactoryManager().getTCPListener();
    }

    public synchronized void connect(Profile profile, long l) {
        if (!this.connected) {
            if (!(profile instanceof IIOPProfile)) {
                throw new BAD_PARAM("attempt to connect an IIOP connection to a non-IIOP profile: " + profile.getClass());
            }
            this.profile = (IIOPProfile)profile;
            IIOPLoopback iIOPLoopback = this.getLocalLoopback();
            if (iIOPLoopback != null) {
                IIOPLoopbackInputStream iIOPLoopbackInputStream = new IIOPLoopbackInputStream();
                IIOPLoopbackOutputStream iIOPLoopbackOutputStream = new IIOPLoopbackOutputStream();
                iIOPLoopback.initLoopback(iIOPLoopbackInputStream, iIOPLoopbackOutputStream);
                this.in_stream = iIOPLoopbackInputStream;
                this.out_stream = iIOPLoopbackOutputStream;
                this.connected = true;
                ++openTransports;
                return;
            }
            this.checkSSL();
            int n = this.noOfRetries;
            while (n >= 0) {
                try {
                    this.createSocket(l);
                    this.socket.setTcpNoDelay(true);
                    if (this.timeout != 0) {
                        this.socket.setSoTimeout(this.timeout);
                    }
                    this.socket.setKeepAlive(this.keepAlive);
                    this.in_stream = this.socket.getInputStream();
                    this.out_stream = new BufferedOutputStream(this.socket.getOutputStream());
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Connected to " + this.connection_info + " from local port " + this.socket.getLocalPort() + (this.isSSL() ? " via SSL" : "") + (this.timeout == 0 ? "" : " Timeout: " + this.timeout));
                    }
                    this.connected = true;
                    ++openTransports;
                    return;
                }
                catch (IOException iOException) {
                    this.logger.debug("Exception", iOException);
                    if (--n < 0) continue;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Retrying to connect to " + this.connection_info);
                    }
                    try {
                        Thread.sleep(this.retryInterval);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (TIMEOUT tIMEOUT) {
                    this.profile = null;
                    this.use_ssl = false;
                    this.ssl_port = -1;
                    throw tIMEOUT;
                }
            }
            if (n < 0) {
                this.profile = null;
                this.use_ssl = false;
                this.ssl_port = -1;
                throw new TRANSIENT("Retries exceeded, couldn't reconnect to " + this.connection_info);
            }
        }
    }

    private IIOPLoopback getLocalLoopback() {
        IIOPProfile iIOPProfile = (IIOPProfile)this.profile;
        ArrayList<ProtocolAddressBase> arrayList = new ArrayList<ProtocolAddressBase>();
        arrayList.add(iIOPProfile.getAddress());
        arrayList.addAll(iIOPProfile.getAlternateAddresses());
        Iterator iterator = arrayList.iterator();
        IIOPLoopbackRegistry iIOPLoopbackRegistry = IIOPLoopbackRegistry.getRegistry();
        while (iterator.hasNext()) {
            IIOPAddress iIOPAddress = (IIOPAddress)iterator.next();
            IIOPLoopback iIOPLoopback = iIOPLoopbackRegistry.getLoopback(iIOPAddress);
            if (iIOPLoopback == null) continue;
            return iIOPLoopback;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSocket(long l) throws IOException {
        ArrayList<ProtocolAddressBase> arrayList = new ArrayList<ProtocolAddressBase>();
        arrayList.add(((IIOPProfile)this.profile).getAddress());
        arrayList.addAll(((IIOPProfile)this.profile).getAlternateAddresses());
        Iterator iterator = arrayList.iterator();
        Exception exception = null;
        this.socket = null;
        while (this.socket == null && iterator.hasNext()) {
            try {
                IIOPAddress iIOPAddress = (IIOPAddress)iterator.next();
                SocketFactory socketFactory = this.use_ssl ? this.getSSLSocketFactory() : this.getSocketFactory();
                String string = iIOPAddress.getIP();
                int n = this.use_ssl ? this.ssl_port : iIOPAddress.getPort();
                this.connection_info = string.indexOf(58) == -1 ? string + ":" + n : "[" + string + "]:" + n;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying to connect to " + this.connection_info + " with timeout=" + l + (this.use_ssl ? " using SSL." : "."));
                }
                exception = null;
                if (l > 0L) {
                    int n2 = (int)l;
                    if ((long)n2 != l) {
                        this.logger.warn("timeout might be changed due to conversion from long to int. old value: " + l + " new value: " + n2);
                    }
                    this.socket = socketFactory.createSocket(string, n, n2);
                    continue;
                }
                this.socket = socketFactory.createSocket(string, n);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            finally {
                if (this.socket == null || !this.connectionListener.isListenerEnabled()) continue;
                this.connectionListener.connectionOpened(new TCPConnectionEvent(this, this.socket.getInetAddress().toString(), this.socket.getPort(), this.socket.getLocalPort(), this.getLocalhost()));
            }
        }
        if (exception != null) {
            if (exception instanceof SocketTimeoutException) {
                throw new TIMEOUT("connection timeout of " + this.timeout + " milliseconds expired: " + exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException("Unexpected exception occured: " + exception.toString());
        }
    }

    public synchronized void close() {
        if (!this.connected) {
            return;
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.in_stream != null) {
                this.in_stream.close();
            }
            if (this.out_stream != null) {
                this.out_stream.close();
            }
            --openTransports;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Client-side TCP transport to " + this.connection_info + " closed.");
            }
            this.connected = false;
        }
        catch (IOException iOException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception when closing the socket", iOException);
            }
            throw this.handleCommFailure(iOException);
        }
        finally {
            if (this.socket != null && this.connectionListener.isListenerEnabled()) {
                this.connectionListener.connectionClosed(new TCPConnectionEvent(this, this.socket.getInetAddress().toString(), this.socket.getPort(), this.socket.getLocalPort(), this.getLocalhost()));
            }
        }
    }

    protected void checkSSL() {
        if (!this.doSupportSSL) {
            return;
        }
        int n = this.configuration.getAttributeAsInteger("jacorb.security.ssl.client.required_options", 16);
        int n2 = this.configuration.getAttributeAsInteger("jacorb.security.ssl.client.supported_options", 16);
        this.ssl_port = ((IIOPProfile)this.profile).getSslPortIfSupported(n, n2);
        this.use_ssl = this.ssl_port != -1;
    }

    public int getSsl_port() {
        return this.ssl_port;
    }

    private SocketFactory getSocketFactory() {
        return this.transportManager.getSocketFactoryManager().getSocketFactory();
    }

    private SocketFactory getSSLSocketFactory() {
        return this.transportManager.getSocketFactoryManager().getSSLSocketFactory();
    }
}

