/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.standardInterceptors.SASComponentInterceptor;
import org.jacorb.security.sas.ATLASPolicyFactory;
import org.jacorb.security.sas.SASClientInterceptor;
import org.jacorb.security.sas.SASPolicyFactory;
import org.jacorb.security.sas.SASTargetInterceptor;
import org.jacorb.slf4j.Logger;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;

public class SASInitializer
extends LocalObject
implements ORBInitializer {
    private Logger logger = null;
    public static final int SecurityAttributeService = 15;
    public static int sasPrincipalNamePIC = -1;

    public void post_init(ORBInitInfo oRBInitInfo) {
        block16: {
            block15: {
                block14: {
                    ORB oRB = ((ORBInitInfoImpl)oRBInitInfo).getORB();
                    this.logger = oRB.getConfiguration().getLogger("jacorb.security.SAS");
                    try {
                        sasPrincipalNamePIC = oRBInitInfo.allocate_slot_id();
                        oRBInitInfo.add_server_request_interceptor(new SASTargetInterceptor(oRBInitInfo));
                    }
                    catch (ConfigurationException configurationException) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("ConfigurationException", configurationException);
                        }
                    }
                    catch (DuplicateName duplicateName) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("TSS DuplicateName", duplicateName);
                        }
                    }
                    catch (UnknownEncoding unknownEncoding) {
                        if (!this.logger.isErrorEnabled()) break block14;
                        this.logger.error("TSS UnknownEncoding", unknownEncoding);
                    }
                }
                try {
                    oRBInitInfo.add_client_request_interceptor(new SASClientInterceptor(oRBInitInfo));
                }
                catch (ConfigurationException configurationException) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("ConfigurationException", configurationException);
                    }
                }
                catch (DuplicateName duplicateName) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("CSS DuplicateName", duplicateName);
                    }
                }
                catch (UnknownEncoding unknownEncoding) {
                    if (!this.logger.isErrorEnabled()) break block15;
                    this.logger.error("CSS UnknownEncoding", unknownEncoding);
                }
            }
            try {
                oRBInitInfo.add_ior_interceptor(new SASComponentInterceptor(oRBInitInfo));
            }
            catch (DuplicateName duplicateName) {
                if (!this.logger.isErrorEnabled()) break block16;
                this.logger.error("IOR DuplicateName", duplicateName);
            }
        }
        oRBInitInfo.register_policy_factory(102, new SASPolicyFactory());
        oRBInitInfo.register_policy_factory(103, new ATLASPolicyFactory());
    }

    public void pre_init(ORBInitInfo oRBInitInfo) {
    }
}

