/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.ssh.server.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.ow2.shelbie.commands.ssh.server.internal.HostKey;

public class KeyPairProviderFactory {
    private final HostKey hostKey;
    private final List<String> stdKeys;
    private final String password;

    public KeyPairProviderFactory(HostKey hostKey, String password) {
        this.hostKey = hostKey;
        this.stdKeys = new ArrayList<String>(2);
        if (hostKey.getRsaKey() != null && hostKey.getRsaKey().exists()) {
            this.stdKeys.add(hostKey.getRsaKey().getAbsolutePath());
        }
        if (hostKey.getDsaKey() != null && hostKey.getDsaKey().exists()) {
            this.stdKeys.add(hostKey.getDsaKey().getAbsolutePath());
        }
        this.password = password;
    }

    public KeyPairProvider get() throws Exception {
        File objKey = this.hostKey.getObjKey();
        if (objKey != null && objKey.exists()) {
            if (this.stdKeys.isEmpty()) {
                return new SimpleGeneratorHostKeyProvider(objKey.getAbsolutePath());
            }
            this.stdKeys.add(objKey.getAbsolutePath());
            throw new Exception("Multiple host keys exist: " + this.stdKeys);
        }
        if (this.stdKeys.isEmpty() || !SecurityUtils.isBouncyCastleRegistered()) {
            return new SimpleGeneratorHostKeyProvider();
        }
        return new FileKeyPairProvider(this.stdKeys.toArray(new String[this.stdKeys.size()]));
    }
}

