/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container;

import java.io.Serializable;
import java.security.Identity;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionManagementType;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.api.bean.info.ISecurityInfo;
import org.ow2.easybeans.api.container.EZBEJBContext;
import org.ow2.easybeans.container.session.stateful.StatefulSessionFactory;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.easybeans.security.propagation.context.SecurityCurrent;
import org.ow2.easybeans.transaction.JTransactionManager;
import org.ow2.easybeans.transaction.interceptors.CMTSupportsTransactionInterceptor;
import org.ow2.util.ee.metadata.common.api.xml.struct.ISecurityRoleRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansEJBContext<FactoryType extends Factory<?, ?>>
implements EZBEJBContext<FactoryType>,
EJBContext {
    private Log logger = LogFactory.getLog(EasyBeansEJBContext.class);
    private static final String JAVA_COMP_ENV = "java:comp/env/";
    private TransactionManager transactionManager = null;
    private TransactionManagementType transactionManagementType = null;
    private boolean runAsBean = false;
    private FactoryType easyBeansFactory = null;
    private TimerService timerService = null;

    public EasyBeansEJBContext(FactoryType easyBeansFactory) {
        this.easyBeansFactory = easyBeansFactory;
        this.transactionManagementType = easyBeansFactory.getBeanInfo().getTransactionManagementType();
        this.runAsBean = easyBeansFactory.getBeanInfo().getSecurityInfo().getRunAsRole() != null;
        this.transactionManager = JTransactionManager.getTransactionManager();
        this.timerService = easyBeansFactory.getTimerService();
        if (this.timerService == null) {
            this.timerService = new MissingTimerService();
        }
    }

    public EJBHome getEJBHome() throws IllegalStateException {
        throw new IllegalStateException("No Home");
    }

    public EJBLocalHome getEJBLocalHome() throws IllegalStateException {
        throw new IllegalStateException("No Local Home");
    }

    @Deprecated
    public Properties getEnvironment() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Identity getCallerIdentity() {
        throw new UnsupportedOperationException();
    }

    public Principal getCallerPrincipal() {
        OperationState operationState = this.getFactory().getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState && this.getFactory() instanceof StatelessSessionFactory) {
            throw new IllegalStateException("The getCallerPrincipal() method cannot be called within the operation state '" + operationState + "'.");
        }
        return SecurityCurrent.getCurrent().getSecurityContext().getCallerPrincipal(this.runAsBean);
    }

    @Deprecated
    public boolean isCallerInRole(Identity role) {
        throw new UnsupportedOperationException();
    }

    public boolean isCallerInRole(String roleName) {
        List securityRoleRefList;
        OperationState operationState = this.getFactory().getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState && this.getFactory() instanceof StatelessSessionFactory) {
            throw new IllegalStateException("The isCallerInRole() method cannot be called within the operation state '" + operationState + "'.");
        }
        ISecurityInfo securityInfo = this.easyBeansFactory.getBeanInfo().getSecurityInfo();
        ArrayList<String> declaredRoles = securityInfo.getDeclaredRoles();
        if (declaredRoles == null) {
            declaredRoles = new ArrayList<String>();
        }
        if ((securityRoleRefList = securityInfo.getSecurityRoleRefList()) != null) {
            for (ISecurityRoleRef securityRoleRef : securityRoleRefList) {
                if (declaredRoles.contains(securityRoleRef.getRoleName())) continue;
                declaredRoles.add(securityRoleRef.getRoleName());
            }
        }
        if (!declaredRoles.contains(roleName)) {
            this.logger.debug((Object)"No security-role with role name ''{0}'' was declared for the bean ''{1}''", new Object[]{roleName, this.easyBeansFactory.getBeanInfo().getName()});
            return false;
        }
        boolean inRole = this.easyBeansFactory.getContainer().getPermissionManager().isCallerInRole(this.easyBeansFactory.getBeanInfo().getName(), roleName, this.runAsBean);
        return inRole;
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        OperationState operationState = this.getFactory().getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState) {
            throw new IllegalStateException("The getUserTransaction() method cannot be called within the operation state '" + operationState + "'.");
        }
        if (this.transactionManagementType == TransactionManagementType.CONTAINER) {
            throw new IllegalStateException("This bean is not allowed to use getUserTransaction()  method as it is in ContainerManagedTransaction");
        }
        return (UserTransaction)this.transactionManager;
    }

    public void setRollbackOnly() throws IllegalStateException {
        OperationState operationState = this.getFactory().getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The setRollbackOnly() method cannot be called within the operation state '" + operationState + "'.");
        }
        if (this.transactionManagementType == TransactionManagementType.BEAN) {
            throw new IllegalStateException("This bean is not allowed to use setRollbackOnly()  method as it is in BeanManagedTransaction");
        }
        Object value = this.getContextData().get(CMTSupportsTransactionInterceptor.class.getName());
        if (value != null && ((Boolean)value).booleanValue()) {
            throw new IllegalStateException("This bean is not allowed to use getRollbackOnly()  method as it is in a SUPPORTS call");
        }
        try {
            if (this.transactionManager.getTransaction() == null) {
                throw new IllegalStateException("Cannot use setRollbackOnly() outside transaction");
            }
        }
        catch (SystemException e) {
            throw new IllegalStateException("Cannot get transaction on transaction manager", e);
        }
        try {
            this.transactionManager.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new RuntimeException("setRollbackOnly() raised an unexpected exception:", e);
        }
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        OperationState operationState = this.getFactory().getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState || OperationState.LIFECYCLE_CALLBACK_INTERCEPTOR == operationState || OperationState.AFTER_COMPLETION == operationState) {
            throw new IllegalStateException("The getRollbackOnly() method cannot be called within the operation state '" + operationState + "'.");
        }
        if (this.transactionManagementType == TransactionManagementType.BEAN) {
            throw new IllegalStateException("This bean is not allowed to use getRollbackOnly()  method as it is in BeanManagedTransaction");
        }
        Object value = this.getContextData().get(CMTSupportsTransactionInterceptor.class.getName());
        if (value != null && ((Boolean)value).booleanValue()) {
            throw new IllegalStateException("This bean is not allowed to use getRollbackOnly()  method as it is in a SUPPORTS call");
        }
        try {
            switch (this.transactionManager.getStatus()) {
                case 1: 
                case 9: {
                    return true;
                }
                case 0: 
                case 2: 
                case 7: 
                case 8: {
                    return false;
                }
                case 4: {
                    throw new IllegalStateException("Transaction already rolled back");
                }
                case 3: {
                    throw new IllegalStateException("Transaction already committed");
                }
                case 5: 
                case 6: {
                    throw new IllegalStateException("Cannot getRollbackOnly outside transaction");
                }
            }
            throw new IllegalStateException("Invalid status");
        }
        catch (SystemException e) {
            throw new IllegalStateException("Cannot get transaction status", e);
        }
    }

    public TimerService getTimerService() throws IllegalStateException {
        if (this.getFactory() instanceof StatefulSessionFactory) {
            throw new IllegalStateException("The getTimerService() method cannot be called from a stateful session bean.");
        }
        OperationState operationState = this.getFactory().getOperationState();
        if (OperationState.DEPENDENCY_INJECTION == operationState) {
            throw new IllegalStateException("The getTimerService() method cannot be called within the operation state '" + operationState + "'.");
        }
        return this.getInternalTimerService();
    }

    public TimerService getInternalTimerService() {
        return this.timerService;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1));
        return sb.toString();
    }

    public Object lookup(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Invalid resource name used for lookup '" + name + "'.");
        }
        try {
            return new InitialContext().lookup(JAVA_COMP_ENV + name);
        }
        catch (NamingException ne) {
            try {
                return new InitialContext().lookup(name);
            }
            catch (NamingException e) {
                throw new IllegalArgumentException("Lookup on '" + name + "' was not found");
            }
        }
    }

    public FactoryType getFactory() {
        return this.easyBeansFactory;
    }

    public Map<String, Object> getContextData() {
        return (Map)this.easyBeansFactory.getContextDataThreadLocal().get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MissingTimerService
    implements TimerService {
        MissingTimerService() {
        }

        public Timer createTimer(Date initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw new IllegalStateException("No timer component was found in the EasyBeans components");
        }

        public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw new IllegalStateException("No timer component was found in the EasyBeans components");
        }

        public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw new IllegalStateException("No timer component was found in the EasyBeans components");
        }

        public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw new IllegalStateException("No timer component was found in the EasyBeans components");
        }

        public Collection<Timer> getTimers() throws IllegalStateException, EJBException {
            return Collections.emptyList();
        }
    }
}

