/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session.singleton;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ejb.NoSuchEJBException;
import javax.ejb.Timer;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.api.bean.EasyBeansSingletonSB;
import org.ow2.easybeans.api.bean.info.IApplicationExceptionInfo;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationBegin;
import org.ow2.easybeans.container.session.JPoolWrapperFactory;
import org.ow2.easybeans.container.session.PoolWrapper;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.event.bean.EventBeanInvocationEnd;
import org.ow2.easybeans.event.bean.EventBeanInvocationError;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.rpc.JEJBResponse;
import org.ow2.easybeans.rpc.api.EJBLocalRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.api.RPCException;
import org.ow2.util.auditreport.api.IAuditID;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.enhanced.EnhancedPool;
import org.ow2.util.pool.impl.enhanced.PoolConfiguration;
import org.ow2.util.pool.impl.enhanced.manager.IPoolManager;
import org.ow2.util.pool.impl.enhanced.manager.optional.IPoolItemRemoveManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonSessionFactory
extends SessionFactory<EasyBeansSingletonSB>
implements IPoolItemRemoveManager<EasyBeansSingletonSB> {
    private static final Log LOGGER = LogFactory.getLog(SingletonSessionFactory.class);
    private ReadWriteLock lock = null;
    private EasyBeansSingletonSB singletonBean = null;

    public SingletonSessionFactory(String className, EZBContainer container) throws FactoryException {
        super(className, container);
        PoolConfiguration poolConfig = new PoolConfiguration();
        poolConfig.setMax(1);
        poolConfig.setMin(1);
        poolConfig.setSpare(0);
        if (Boolean.getBoolean("easybeans.useSimplePool")) {
            JPool jPool = new JPool(new JPoolWrapperFactory(this));
            jPool.setPoolConfiguration((IPoolConfiguration)poolConfig);
            this.setPool(jPool);
        } else {
            EnhancedPool singletonPool = this.getManagementPool().getEnhancedPoolFactory().createEnhancedPool((IPoolManager)this);
            singletonPool.setPoolConfiguration((IPoolConfiguration)poolConfig);
            this.setPool(new PoolWrapper(singletonPool));
        }
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    protected EasyBeansSingletonSB getBean(Long beanId) throws IllegalArgumentException {
        try {
            return (EasyBeansSingletonSB)this.getPool().get();
        }
        catch (PoolException e) {
            throw new IllegalArgumentException("Cannot get element in the pool", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EJBResponse localCall(EJBLocalRequest localCallRequest) {
        Object value;
        JEJBResponse ejbResponse;
        block26: {
            OperationState oldState;
            String oldInvokedBusinessInterface;
            ClassLoader oldClassLoader;
            Lock writeLock;
            block27: {
                ejbResponse = new JEJBResponse();
                writeLock = this.lock.writeLock();
                writeLock.lock();
                if (this.singletonBean == null) {
                    try {
                        this.singletonBean = this.getBean(null);
                    }
                    catch (IllegalArgumentException e) {
                        ejbResponse.setRPCException(new RPCException("Cannot get element in the pool", (Throwable)e));
                        return ejbResponse;
                    }
                    catch (NoSuchEJBException e) {
                        ejbResponse.setRPCException(new RPCException("Bean has been removed", (Throwable)e));
                        return ejbResponse;
                    }
                }
                writeLock.unlock();
                Method m = this.getHashes().get(localCallRequest.getMethodHash());
                if (m == null) {
                    ejbResponse.setRPCException(new RPCException("Cannot find method called on the bean '" + this.getClassName() + "'."));
                    return ejbResponse;
                }
                value = null;
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
                oldInvokedBusinessInterface = (String)this.getInvokedBusinessInterfaceNameThreadLocal().get();
                this.getInvokedBusinessInterfaceNameThreadLocal().set(localCallRequest.getInvokedBusinessInterfaceName());
                oldState = this.getOperationState();
                this.getOperationStateThreadLocal().set(OperationState.BUSINESS_METHOD);
                String methodEventProviderId = this.getJ2EEManagedObjectId() + "/" + J2EEManagedObjectNamingHelper.getMethodSignature(m) + "@Local";
                boolean enabledEvent = !localCallRequest.isCalledFromRemoteRequest();
                EZBEventBeanInvocationBegin event = null;
                long number = 0L;
                IAuditID previousID = null;
                if (enabledEvent) {
                    if (this.getCurrentInvocationID() != null) {
                        previousID = this.getCurrentInvocationID().newInvocation();
                    }
                    event = this.getInvocationEventBegin(methodEventProviderId, localCallRequest.getMethodArgs());
                    number = event.getInvocationNumber();
                    this.getEventDispatcher().dispatch((IEvent)event);
                }
                writeLock.lock();
                try {
                    try {
                        value = m.invoke((Object)this.singletonBean, localCallRequest.getMethodArgs());
                    }
                    catch (IllegalArgumentException e) {
                        ejbResponse.setRPCException(new RPCException((Throwable)e));
                        if (enabledEvent) {
                            this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                        }
                        Object var20_17 = null;
                        if (enabledEvent) {
                            this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                            if (this.getCurrentInvocationID() != null) {
                                this.getCurrentInvocationID().setAuditID(previousID);
                            }
                        }
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                        this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                        this.getOperationStateThreadLocal().set(oldState);
                        writeLock.unlock();
                        break block26;
                    }
                    catch (IllegalAccessException e) {
                        ejbResponse.setRPCException(new RPCException((Throwable)e));
                        if (enabledEvent) {
                            this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                        }
                        Object var20_18 = null;
                        if (enabledEvent) {
                            this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                            if (this.getCurrentInvocationID() != null) {
                                this.getCurrentInvocationID().setAuditID(previousID);
                            }
                        }
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                        this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                        this.getOperationStateThreadLocal().set(oldState);
                        writeLock.unlock();
                        break block26;
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        RPCException rpcException = new RPCException(cause);
                        IApplicationExceptionInfo applicationException = this.getBeanInfo().getApplicationException(cause);
                        if (applicationException != null) {
                            rpcException.setApplicationException();
                        }
                        ejbResponse.setRPCException(rpcException);
                        if (enabledEvent) {
                            this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                        }
                        Object var20_19 = null;
                        if (enabledEvent) {
                            this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                            if (this.getCurrentInvocationID() != null) {
                                this.getCurrentInvocationID().setAuditID(previousID);
                            }
                        }
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                        this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                        this.getOperationStateThreadLocal().set(oldState);
                        writeLock.unlock();
                        break block26;
                    }
                    Object var20_16 = null;
                    if (!enabledEvent) break block27;
                }
                catch (Throwable throwable) {
                    Object var20_20 = null;
                    if (enabledEvent) {
                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                        if (this.getCurrentInvocationID() != null) {
                            this.getCurrentInvocationID().setAuditID(previousID);
                        }
                    }
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                    this.getOperationStateThreadLocal().set(oldState);
                    writeLock.unlock();
                    throw throwable;
                }
                this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                if (this.getCurrentInvocationID() != null) {
                    this.getCurrentInvocationID().setAuditID(previousID);
                }
            }
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
            this.getOperationStateThreadLocal().set(oldState);
            writeLock.unlock();
        }
        ejbResponse.setValue(value);
        return ejbResponse;
    }

    @Override
    public void start() throws FactoryException {
        super.start();
        if (this.getSessionBeanInfo().isStartup()) {
            try {
                this.singletonBean = this.getBean(null);
            }
            catch (RuntimeException e) {
                throw new FactoryException("Cannot initialize Singleton bean", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTimeout(Timer timer) {
        if (this.singletonBean == null) {
            this.singletonBean = this.getBean(null);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            this.singletonBean.timeoutCallByEasyBeans(timer);
            Object var4_3 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            throw throwable;
        }
    }

    @Override
    public void stop() {
        if (this.singletonBean != null) {
            try {
                this.getPool().release((Object)this.singletonBean);
            }
            catch (PoolException e) {
                LOGGER.error((Object)"Unable to release singleton bean", new Object[]{e});
            }
        }
        super.stop();
    }
}

