/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session.stateless;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.Timer;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.api.bean.EasyBeansSLSB;
import org.ow2.easybeans.api.bean.info.IApplicationExceptionInfo;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationBegin;
import org.ow2.easybeans.container.session.JPoolWrapperFactory;
import org.ow2.easybeans.container.session.PoolWrapper;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.event.bean.EventBeanInvocationEnd;
import org.ow2.easybeans.event.bean.EventBeanInvocationError;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.rpc.JEJBResponse;
import org.ow2.easybeans.rpc.api.EJBLocalRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.api.RPCException;
import org.ow2.util.auditreport.api.IAuditID;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.enhanced.EnhancedPool;
import org.ow2.util.pool.impl.enhanced.manager.IPoolManager;
import org.ow2.util.pool.impl.enhanced.manager.optional.IPoolItemRemoveManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessSessionFactory
extends SessionFactory<EasyBeansSLSB>
implements IPoolItemRemoveManager<EasyBeansSLSB> {
    private static Log logger = LogFactory.getLog(StatelessSessionFactory.class);

    public StatelessSessionFactory(String className, EZBContainer container) throws FactoryException {
        super(className, container);
        if (Boolean.getBoolean("easybeans.useSimplePool")) {
            this.setPool(new JPool(new JPoolWrapperFactory(this)));
        } else {
            EnhancedPool statelessPool = this.getManagementPool().getEnhancedPoolFactory().createEnhancedPool((IPoolManager)this);
            this.setPool(new PoolWrapper(statelessPool));
        }
    }

    @Override
    protected EasyBeansSLSB getBean(Long beanId) throws IllegalArgumentException {
        try {
            return (EasyBeansSLSB)this.getPool().get();
        }
        catch (PoolException e) {
            throw new IllegalArgumentException("Cannot get element in the pool", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public EJBResponse localCall(EJBLocalRequest localCallRequest) {
        Object value;
        JEJBResponse ejbResponse;
        block32: {
            IAuditID previousID;
            long number;
            boolean enabledEvent;
            String methodEventProviderId;
            OperationState oldState;
            String oldInvokedBusinessInterface;
            ClassLoader oldClassLoader;
            EasyBeansSLSB bean;
            block31: {
                ejbResponse = new JEJBResponse();
                bean = null;
                try {
                    bean = this.getBean(null);
                }
                catch (IllegalArgumentException e) {
                    ejbResponse.setRPCException(new RPCException("Cannot get element in the pool", (Throwable)e));
                    return ejbResponse;
                }
                catch (NoSuchEJBException e) {
                    ejbResponse.setRPCException(new RPCException("Bean has been removed", (Throwable)e));
                    return ejbResponse;
                }
                Method m = this.getHashes().get(localCallRequest.getMethodHash());
                if (m == null) {
                    ejbResponse.setRPCException(new RPCException("Cannot find method called on the bean '" + this.getClassName() + "'.", (Throwable)new NoSuchMethodException("The method is not found on the bean")));
                    return ejbResponse;
                }
                value = null;
                oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
                oldInvokedBusinessInterface = (String)this.getInvokedBusinessInterfaceNameThreadLocal().get();
                this.getInvokedBusinessInterfaceNameThreadLocal().set(localCallRequest.getInvokedBusinessInterfaceName());
                oldState = this.getOperationState();
                this.getOperationStateThreadLocal().set(OperationState.BUSINESS_METHOD);
                methodEventProviderId = this.getJ2EEManagedObjectId() + "/" + J2EEManagedObjectNamingHelper.getMethodSignature(m) + "@Local";
                enabledEvent = !localCallRequest.isCalledFromRemoteRequest();
                EZBEventBeanInvocationBegin event = null;
                number = 0L;
                previousID = null;
                if (enabledEvent) {
                    if (this.getCurrentInvocationID() != null) {
                        previousID = this.getCurrentInvocationID().newInvocation();
                    }
                    event = this.getInvocationEventBegin(methodEventProviderId, localCallRequest.getMethodArgs());
                    number = event.getInvocationNumber();
                    this.getEventDispatcher().dispatch((IEvent)event);
                }
                value = m.invoke((Object)bean, localCallRequest.getMethodArgs());
                Object var20_16 = null;
                if (!enabledEvent) break block31;
                this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                if (this.getCurrentInvocationID() != null) {
                    this.getCurrentInvocationID().setAuditID(previousID);
                }
            }
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
            this.getOperationStateThreadLocal().set(oldState);
            try {
                this.getPool().release((Object)bean);
            }
            catch (PoolException e2) {
                ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e2));
            }
            break block32;
            {
                catch (IllegalArgumentException e) {
                    ejbResponse.setRPCException(new RPCException((Throwable)e));
                    if (enabledEvent) {
                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                    }
                    Object var20_17 = null;
                    if (enabledEvent) {
                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                        if (this.getCurrentInvocationID() != null) {
                            this.getCurrentInvocationID().setAuditID(previousID);
                        }
                    }
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                    this.getOperationStateThreadLocal().set(oldState);
                    try {
                        this.getPool().release((Object)bean);
                    }
                    catch (PoolException e2) {
                        ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e2));
                    }
                    break block32;
                }
                catch (IllegalAccessException e) {
                    ejbResponse.setRPCException(new RPCException((Throwable)e));
                    if (enabledEvent) {
                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                    }
                    Object var20_18 = null;
                    if (enabledEvent) {
                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                        if (this.getCurrentInvocationID() != null) {
                            this.getCurrentInvocationID().setAuditID(previousID);
                        }
                    }
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                    this.getOperationStateThreadLocal().set(oldState);
                    try {
                        this.getPool().release((Object)bean);
                    }
                    catch (PoolException e2) {
                        ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e2));
                    }
                    break block32;
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    RPCException rpcException = new RPCException(cause);
                    IApplicationExceptionInfo applicationException = this.getBeanInfo().getApplicationException(cause);
                    if (applicationException != null) {
                        rpcException.setApplicationException();
                    }
                    ejbResponse.setRPCException(rpcException);
                    if (enabledEvent) {
                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                    }
                    Object var20_19 = null;
                    if (enabledEvent) {
                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                        if (this.getCurrentInvocationID() != null) {
                            this.getCurrentInvocationID().setAuditID(previousID);
                        }
                    }
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                    this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                    this.getOperationStateThreadLocal().set(oldState);
                    try {
                        this.getPool().release((Object)bean);
                    }
                    catch (PoolException e2) {
                        ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e2));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                if (enabledEvent) {
                    this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                    if (this.getCurrentInvocationID() != null) {
                        this.getCurrentInvocationID().setAuditID(previousID);
                    }
                }
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                this.getOperationStateThreadLocal().set(oldState);
                try {
                    this.getPool().release((Object)bean);
                }
                catch (PoolException e2) {
                    ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e2));
                }
                throw throwable;
            }
        }
        ejbResponse.setValue(value);
        return ejbResponse;
    }

    @Override
    public void remove(EasyBeansSLSB instance) {
        super.remove(instance);
        instance.setEasyBeansRemoved(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTimeout(Timer timer) {
        if (!this.isStarted()) {
            logger.warn((Object)"Received a timer call but the factory has been stopped, so ignore this call", new Object[0]);
            return;
        }
        EasyBeansSLSB bean = null;
        bean = this.getBean(null);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            bean.timeoutCallByEasyBeans(timer);
            Object var5_4 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            try {
                this.getPool().release((Object)bean);
            }
            catch (PoolException e) {
                throw new EJBException("cannot release bean", (Exception)((Object)e));
            }
            throw throwable;
        }
        try {
            this.getPool().release((Object)bean);
        }
        catch (PoolException e) {
            throw new EJBException("cannot release bean", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            Collection timers = this.getTimerService().getTimers();
            for (Timer timer : timers) {
                timer.cancel();
            }
            Object var5_4 = null;
            super.stop();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            super.stop();
            throw throwable;
        }
    }
}

