/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.bean;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.EJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvocationHelper {
    private InvocationHelper() {
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] args) {
        try {
            return clazz.getMethod(methodName, args);
        }
        catch (SecurityException e) {
            throw new EJBException("Unable to get method '" + methodName + "'", (Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new EJBException("Unable to get method '" + methodName + "'", (Exception)e);
        }
    }

    public static Object invoke(Object instance, Method m, InvocationHandler handler, Object[] args) throws Throwable {
        m.setAccessible(true);
        try {
            Object object = handler.invoke(instance, m, args);
            return object;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                throw e.getCause();
            }
            throw e;
        }
        finally {
            m.setAccessible(false);
        }
    }
}

