/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.bean;

import java.lang.reflect.InvocationHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.ow2.easybeans.api.bean.proxy.EasyBeansNoInterfaceProxyBean;
import org.ow2.easybeans.asm.ClassVisitor;
import org.ow2.easybeans.asm.Label;
import org.ow2.easybeans.asm.MethodVisitor;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.enhancer.CommonClassGenerator;
import org.ow2.easybeans.enhancer.EasyBeansClassWriter;
import org.ow2.easybeans.enhancer.bean.InvocationHelper;
import org.ow2.easybeans.enhancer.lib.ProxyClassEncoder;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public class NoInterfaceViewClassGenerator
extends CommonClassGenerator {
    public static final JMethod TO_STRING_JMETHOD = new JMethod(1, "toString", "()Ljava/lang/String;", null, null);
    public static final JMethod EQUALS_JMETHOD = new JMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
    public static final JMethod HASHCODE_JMETHOD = new JMethod(1, "hashCode", "()I", null, null);
    public static final List<String> METHODS_TO_IGNORE = Arrays.asList("<init>", "<clinit>", TO_STRING_JMETHOD.getName(), EQUALS_JMETHOD.getName(), HASHCODE_JMETHOD.getName());
    private static final String INVOCATION_HELPER_CLASSNAME = Type.getInternalName(InvocationHelper.class);
    private EasyBeansEjbJarClassMetadata classMetadata = null;
    private String generatedClassName = null;

    public NoInterfaceViewClassGenerator(EasyBeansEjbJarClassMetadata classMetadata, ClassLoader readLoader) {
        super(new EasyBeansClassWriter(readLoader));
        this.classMetadata = classMetadata;
        this.generatedClassName = ProxyClassEncoder.getProxyClassName(classMetadata.getClassName());
    }

    public void generate() {
        this.addClassDeclaration();
        this.addAttributes();
        this.addConstructor();
        this.addMethods();
        this.endClass();
    }

    private void addAttributes() {
        this.addInvocationHandlerAttributes();
    }

    private void addInvocationHandlerAttributes() {
        CommonClassGenerator.addFieldGettersSetters((ClassVisitor)this.getCW(), this.generatedClassName, "invocationHandler", InvocationHandler.class);
    }

    private void addClassDeclaration() {
        String interfaceName = Type.getInternalName(EasyBeansNoInterfaceProxyBean.class);
        this.getCW().visit(49, 33, this.generatedClassName, null, this.classMetadata.getClassName(), new String[]{interfaceName});
    }

    private void addConstructor() {
        MethodVisitor mv = this.getCW().visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, this.classMetadata.getClassName(), "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addMethods() {
        Collection methodsMetadata = this.classMetadata.getMethodMetadataCollection();
        if (methodsMetadata != null) {
            for (EasyBeansEjbJarMethodMetadata methodMetadata : methodsMetadata) {
                JMethod jMethod = methodMetadata.getJMethod();
                if (METHODS_TO_IGNORE.contains(jMethod.getName())) continue;
                if ((jMethod.getAccess() & 1) != 1 && (jMethod.getAccess() & 2) != 2) {
                    this.addThrowsExceptionMethod(jMethod);
                    continue;
                }
                if ((jMethod.getAccess() & 1) != 1) continue;
                this.addTransformedMethod(methodMetadata);
            }
        }
        this.addTransformedMethod(new EasyBeansEjbJarMethodMetadata(TO_STRING_JMETHOD, this.classMetadata));
        this.addTransformedMethod(new EasyBeansEjbJarMethodMetadata(EQUALS_JMETHOD, this.classMetadata));
        this.addTransformedMethod(new EasyBeansEjbJarMethodMetadata(HASHCODE_JMETHOD, this.classMetadata));
    }

    private void addTransformedMethod(EasyBeansEjbJarMethodMetadata methodMetadata) {
        JMethod jMethod = methodMetadata.getJMethod();
        MethodVisitor mv = this.getCW().visitMethod(jMethod.getAccess(), jMethod.getName(), jMethod.getDescriptor(), jMethod.getSignature(), jMethod.getExceptions());
        mv.visitCode();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "java/lang/Throwable");
        mv.visitLdcInsn(Type.getType("L".concat(((EasyBeansEjbJarClassMetadata)methodMetadata.getClassMetadata()).getClassName()).concat(";")));
        mv.visitLdcInsn(jMethod.getName());
        Type[] args = Type.getArgumentTypes(jMethod.getDescriptor());
        int methodArg = 1;
        this.putConstNumber(args.length, mv);
        mv.visitTypeInsn(189, "java/lang/Class");
        int argCount = 0;
        for (Type type : args) {
            mv.visitInsn(89);
            this.putConstNumber(argCount, mv);
            NoInterfaceViewClassGenerator.visitClassType(type, mv);
            mv.visitInsn(83);
            int opCode = CommonClassGenerator.putFieldLoadOpCode(type.getSort());
            if (opCode == 22 || opCode == 24) {
                ++methodArg;
            }
            ++methodArg;
            ++argCount;
        }
        mv.visitMethodInsn(184, INVOCATION_HELPER_CLASSNAME, "getMethod", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
        mv.visitVarInsn(58, methodArg);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, methodArg);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.generatedClassName, "getInvocationHandler", "()Ljava/lang/reflect/InvocationHandler;");
        this.putConstNumber(args.length, mv);
        mv.visitTypeInsn(189, "java/lang/Object");
        argCount = 0;
        int localArg = 1;
        for (Type type : args) {
            mv.visitInsn(89);
            this.putConstNumber(argCount, mv);
            int opCode = CommonClassGenerator.putFieldLoadOpCode(type.getSort());
            mv.visitVarInsn(opCode, localArg);
            if (opCode == 22 || opCode == 24) {
                ++localArg;
            }
            ++localArg;
            CommonClassGenerator.transformPrimitiveIntoObject(type, mv);
            mv.visitInsn(83);
            ++argCount;
        }
        mv.visitMethodInsn(184, INVOCATION_HELPER_CLASSNAME, "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;Ljava/lang/reflect/InvocationHandler;[Ljava/lang/Object;)Ljava/lang/Object;");
        Type returnType = Type.getReturnType(jMethod.getDescriptor());
        CommonClassGenerator.transformObjectIntoPrimitive(returnType, mv);
        mv.visitLabel(l1);
        CommonClassGenerator.addReturnType(returnType, mv);
        mv.visitLabel(l2);
        mv.visitVarInsn(58, ++methodArg);
        String[] methodExceptions = jMethod.getExceptions();
        if (methodExceptions != null) {
            Label[] ifLabels = new Label[methodExceptions.length + 1];
            for (int i = 0; i < ifLabels.length; ++i) {
                ifLabels[i] = new Label();
            }
            for (int ifBlock = 0; ifBlock < methodExceptions.length; ++ifBlock) {
                mv.visitLabel(ifLabels[ifBlock]);
                mv.visitVarInsn(25, methodArg);
                mv.visitTypeInsn(193, methodExceptions[ifBlock]);
                mv.visitJumpInsn(153, ifLabels[ifBlock + 1]);
                mv.visitVarInsn(25, methodArg);
                mv.visitTypeInsn(192, methodExceptions[ifBlock]);
                mv.visitInsn(191);
            }
            mv.visitLabel(ifLabels[methodExceptions.length]);
        }
        mv.visitVarInsn(25, methodArg);
        mv.visitTypeInsn(193, "java/lang/RuntimeException");
        Label notRuntimeException = new Label();
        mv.visitJumpInsn(153, notRuntimeException);
        mv.visitVarInsn(25, methodArg);
        mv.visitTypeInsn(192, "java/lang/RuntimeException");
        mv.visitInsn(191);
        mv.visitLabel(notRuntimeException);
        mv.visitVarInsn(25, methodArg);
        mv.visitTypeInsn(193, "java/lang/Exception");
        Label notException = new Label();
        mv.visitJumpInsn(153, notException);
        mv.visitTypeInsn(187, "javax/ejb/EJBException");
        mv.visitInsn(89);
        mv.visitLdcInsn("Unable to invoke method");
        mv.visitVarInsn(25, methodArg);
        mv.visitTypeInsn(192, "java/lang/Exception");
        mv.visitMethodInsn(183, "javax/ejb/EJBException", "<init>", "(Ljava/lang/String;Ljava/lang/Exception;)V");
        mv.visitInsn(191);
        mv.visitLabel(notException);
        mv.visitTypeInsn(187, "javax/ejb/EJBException");
        mv.visitInsn(89);
        mv.visitLdcInsn("Unable to invoke method");
        mv.visitTypeInsn(187, "java/lang/RuntimeException");
        mv.visitInsn(89);
        mv.visitVarInsn(25, methodArg);
        mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/Throwable;)V");
        mv.visitMethodInsn(183, "javax/ejb/EJBException", "<init>", "(Ljava/lang/String;Ljava/lang/Exception;)V");
        mv.visitInsn(191);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addThrowsExceptionMethod(JMethod jMethod) {
        MethodVisitor mv = this.getCW().visitMethod(jMethod.getAccess(), jMethod.getName(), jMethod.getDescriptor(), jMethod.getSignature(), jMethod.getExceptions());
        mv.visitCode();
        mv.visitTypeInsn(187, "javax/ejb/EJBException");
        mv.visitInsn(89);
        mv.visitLdcInsn("This method is not a public method. Access is not allowed");
        mv.visitMethodInsn(183, "javax/ejb/EJBException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void endClass() {
        this.getCW().visitEnd();
    }

    public byte[] getBytes() {
        return this.getCW().toByteArray();
    }

    public String getGeneratedClassName() {
        return this.generatedClassName;
    }
}

