/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.osgi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.ow2.util.archive.api.IArchiveMetadata;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.OSGiDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiDeployer
extends AbsDeployer<OSGiDeployable> {
    private Log logger = LogFactory.getLog(OSGiDeployer.class);
    private BundleContext bundleContext = null;
    private Map<String, Bundle> installedBundles = null;
    public static String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    public static String BUNDLE_VERSION = "Bundle-Version";

    public OSGiDeployer(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.installedBundles = new HashMap<String, Bundle>();
    }

    @Override
    public void doUndeploy(IDeployable<OSGiDeployable> osgiDeployable) throws DeployerException {
        this.logger.debug((Object)"Undeploying {0}", new Object[]{osgiDeployable});
        Bundle bundle = this.stopBundle(osgiDeployable);
        if (bundle != null) {
            this.uninstallBundle(osgiDeployable, bundle);
        }
    }

    @Override
    public void doDeploy(IDeployable<OSGiDeployable> deployable) throws DeployerException {
        this.logger.debug((Object)"Deploying {0}", new Object[]{deployable});
        OSGiDeployable osgiDeployable = (OSGiDeployable)OSGiDeployable.class.cast(deployable);
        Bundle bundle = this.installBundle(osgiDeployable);
        if (bundle != null) {
            this.startBundle(osgiDeployable, bundle);
            this.addInstalledBundle(osgiDeployable, bundle);
        }
    }

    @Override
    public boolean supports(IDeployable<?> deployable) {
        return OSGiDeployable.class.isInstance(deployable);
    }

    @Override
    protected void check(IDeployable<?> deployable) throws DeployerException {
        if (this.bundleContext == null) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not available as there is no bundle context set on this deployer.");
        }
        super.check(deployable);
    }

    @Override
    public boolean isDeployed(IDeployable<OSGiDeployable> deployable) throws DeployerException {
        List<Bundle> bundles = Arrays.asList(this.bundleContext.getBundles());
        IArchiveMetadata archiveMetadata = deployable.getArchive().getMetadata();
        String symbolicName = archiveMetadata.get(BUNDLE_SYMBOLIC_NAME);
        String version = archiveMetadata.get(BUNDLE_VERSION);
        for (Bundle bundle : bundles) {
            if (!bundle.getSymbolicName().equals(symbolicName) || !bundle.getVersion().toString().equals(version)) continue;
            if (bundle.getState() == 2 || bundle.getState() == 4) {
                this.startBundle((OSGiDeployable)OSGiDeployable.class.cast(deployable), bundle);
            }
            this.installedBundles.put(this.getURL(deployable).toExternalForm(), bundle);
            return true;
        }
        return super.isDeployed(deployable);
    }

    @Override
    public List<IDeployable<OSGiDeployable>> doDeploy(List<IDeployable<OSGiDeployable>> osgiDeployables) {
        Bundle bundle;
        OSGiDeployable osgiDeployable;
        ArrayList<IDeployable<OSGiDeployable>> failed = new ArrayList<IDeployable<OSGiDeployable>>();
        HashMap<OSGiDeployable, Bundle> osgiDeployableBundleMap = new HashMap<OSGiDeployable, Bundle>();
        for (IDeployable<OSGiDeployable> iDeployable : osgiDeployables) {
            this.logger.debug((Object)"Deploying {0}", new Object[]{iDeployable});
            osgiDeployable = (OSGiDeployable)OSGiDeployable.class.cast(iDeployable);
            try {
                bundle = this.installBundle(osgiDeployable);
                if (bundle == null) continue;
                osgiDeployableBundleMap.put(osgiDeployable, bundle);
            }
            catch (DeployerException e) {
                this.logger.error((Object)"Bundle {0}\u00a0cannot be installed", new Object[]{osgiDeployable, e});
                failed.add((IDeployable<OSGiDeployable>)osgiDeployable);
            }
        }
        for (Map.Entry entry : osgiDeployableBundleMap.entrySet()) {
            osgiDeployable = (OSGiDeployable)entry.getKey();
            bundle = (Bundle)entry.getValue();
            this.startBundle(osgiDeployable, bundle);
            try {
                this.addInstalledBundle(osgiDeployable, bundle);
            }
            catch (DeployerException e) {
                this.logger.error((Object)"Cannot add {0} to the list of installed bundle", new Object[]{osgiDeployable, e});
                failed.add((IDeployable<OSGiDeployable>)osgiDeployable);
            }
        }
        return failed;
    }

    @Override
    public List<IDeployable<OSGiDeployable>> doUndeploy(List<IDeployable<OSGiDeployable>> osgiDeployables) {
        ArrayList<IDeployable<OSGiDeployable>> failed = new ArrayList<IDeployable<OSGiDeployable>>();
        HashMap<IDeployable<OSGiDeployable>, Bundle> osgiDeployableBundleMap = new HashMap<IDeployable<OSGiDeployable>, Bundle>();
        for (IDeployable<OSGiDeployable> iDeployable : osgiDeployables) {
            this.logger.debug((Object)"Undeploying {0}", new Object[]{iDeployable});
            try {
                Bundle bundle = this.stopBundle(iDeployable);
                if (bundle == null) continue;
                osgiDeployableBundleMap.put(iDeployable, bundle);
            }
            catch (DeployerException e) {
                this.logger.error((Object)"Cannot stop bundle {0}", new Object[]{iDeployable, e});
                failed.add(iDeployable);
            }
        }
        for (Map.Entry entry : osgiDeployableBundleMap.entrySet()) {
            IDeployable osgiDeployable = (IDeployable)entry.getKey();
            try {
                this.uninstallBundle((IDeployable<OSGiDeployable>)osgiDeployable, (Bundle)entry.getValue());
            }
            catch (DeployerException e) {
                this.logger.error((Object)"Cannot uninstall bundle {0}", new Object[]{osgiDeployable, e});
                failed.add((IDeployable<OSGiDeployable>)osgiDeployable);
            }
        }
        return failed;
    }

    protected Bundle installBundle(OSGiDeployable osgiDeployable) throws DeployerException {
        Bundle osgiBundle;
        try {
            String url = this.getURL(osgiDeployable).toExternalForm();
            if (osgiDeployable.isReference().booleanValue()) {
                url = "reference:".concat(url);
            }
            osgiBundle = this.bundleContext.installBundle(url);
            ((BundleStartLevel)osgiBundle.adapt(BundleStartLevel.class)).setStartLevel(osgiDeployable.getStartLevel().intValue());
        }
        catch (BundleException e) {
            if (e.getType() == 9) {
                this.logger.warn((Object)"Cannot deploy a bundle that is already installed", new Object[]{e.getMessage()});
                return null;
            }
            throw new DeployerException("Cannot install the bundle '" + osgiDeployable + "'.", (Throwable)e);
        }
        return osgiBundle;
    }

    protected void startBundle(OSGiDeployable osgiDeployable, Bundle bundle) {
        if (osgiDeployable.isStart().booleanValue()) {
            try {
                int options = 2;
                if (osgiDeployable.isStartTransient().booleanValue()) {
                    options |= 1;
                }
                bundle.start(options);
            }
            catch (BundleException e) {
                this.logger.error((Object)"Cannot start the bundle ''{0}''.", new Object[]{osgiDeployable, e});
            }
        }
    }

    private void addInstalledBundle(OSGiDeployable osgiDeployable, Bundle bundle) throws DeployerException {
        this.installedBundles.put(this.getURL(osgiDeployable).toExternalForm(), bundle);
    }

    protected Bundle stopBundle(IDeployable<OSGiDeployable> osgiDeployable) throws DeployerException {
        if (!this.isDeployed(osgiDeployable)) {
            throw new DeployerException("Cannot undeploy the bundle '" + osgiDeployable + "' as it was not deployed.");
        }
        Bundle bundle = this.installedBundles.get(this.getURL(osgiDeployable).toExternalForm());
        if (bundle == null) {
            throw new DeployerException("No bundle found for the '" + osgiDeployable + "'.");
        }
        if (1 != bundle.getState()) {
            try {
                bundle.stop();
            }
            catch (BundleException e) {
                throw new DeployerException("Cannot stop the bundle '" + osgiDeployable + "'.", (Throwable)e);
            }
            return bundle;
        }
        this.installedBundles.remove(this.getURL(osgiDeployable).toExternalForm());
        return null;
    }

    protected void uninstallBundle(IDeployable<OSGiDeployable> osgiDeployable, Bundle bundle) throws DeployerException {
        try {
            bundle.uninstall();
        }
        catch (BundleException e) {
            throw new DeployerException("Cannot uninstall the bundle '" + osgiDeployable + "'.", (Throwable)e);
        }
        this.installedBundles.remove(this.getURL(osgiDeployable).toExternalForm());
    }
}

