/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.multitenant.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import javax.servlet.Filter;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.tenant.TenantIdInfo;
import org.ow2.jonas.lib.tenant.filter.HttpTenantIdFilter;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.multitenant.MultitenantService;
import org.ow2.jonas.multitenant.internal.MultitenantVirtualJNDIBinding;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployableInfo;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultitenantServiceImpl
extends AbsServiceImpl
implements MultitenantService,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(MultitenantServiceImpl.class);
    private static JmxService jmxService = null;
    private static RegistryService registryService = null;
    private boolean __FmultitenantEnabled;
    private boolean multitenantEnabled;
    private boolean __FdefaultPolicy;
    private String defaultPolicy;
    private boolean __MgetDefaultDeploymentPolicy;
    private boolean __MisMultitenantEnabled;
    private boolean __MsetJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MsetRegistryService$org_ow2_jonas_registry_RegistryService;
    private boolean __MdoStart;
    private boolean __MdoStop;
    private boolean __MgetTenantIdFilter$java_lang_String;
    private boolean __MgetDefaultTenantID;
    private boolean __McreateJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String;
    private boolean __MgetOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MgarbageCollectJNDIBindingMBeans;
    private boolean __MupdatePersistenceUnitManager$org_ow2_easybeans_persistence_api_EZBPersistenceUnitManager$java_lang_String;
    private boolean __MaddTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String;
    private boolean __MgetTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable;

    boolean __getmultitenantEnabled() {
        if (!this.__FmultitenantEnabled) {
            return this.multitenantEnabled;
        }
        Object object = this.__IM.onGet((Object)this, "multitenantEnabled");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setmultitenantEnabled(boolean bl) {
        if (!this.__FmultitenantEnabled) {
            this.multitenantEnabled = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "multitenantEnabled", (Object)bl2);
    }

    String __getdefaultPolicy() {
        if (!this.__FdefaultPolicy) {
            return this.defaultPolicy;
        }
        return (String)this.__IM.onGet((Object)this, "defaultPolicy");
    }

    void __setdefaultPolicy(String string) {
        if (!this.__FdefaultPolicy) {
            this.defaultPolicy = string;
            return;
        }
        this.__IM.onSet((Object)this, "defaultPolicy", (Object)string);
    }

    public MultitenantServiceImpl() {
        this(null);
    }

    private MultitenantServiceImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setmultitenantEnabled(true);
        this.__setdefaultPolicy("Reserved");
    }

    @Override
    public String getDefaultDeploymentPolicy() {
        String string;
        if (!this.__MgetDefaultDeploymentPolicy) {
            return this.__getDefaultDeploymentPolicy();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultDeploymentPolicy", new Object[0]);
            string = this.__getDefaultDeploymentPolicy();
            this.__IM.onExit((Object)this, "getDefaultDeploymentPolicy", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultDeploymentPolicy", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getDefaultDeploymentPolicy() {
        return this.__getdefaultPolicy();
    }

    @Override
    public boolean isMultitenantEnabled() {
        boolean bl;
        if (!this.__MisMultitenantEnabled) {
            return this.__isMultitenantEnabled();
        }
        try {
            this.__IM.onEntry((Object)this, "isMultitenantEnabled", new Object[0]);
            bl = this.__isMultitenantEnabled();
            this.__IM.onExit((Object)this, "isMultitenantEnabled", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isMultitenantEnabled", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isMultitenantEnabled() {
        return this.isStarted() && this.__getmultitenantEnabled();
    }

    public void setJmxService(JmxService jmxService) {
        if (!this.__MsetJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__setJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__setJmxService(jmxService);
            this.__IM.onExit((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __setJmxService(JmxService jmxService) {
        MultitenantServiceImpl.jmxService = jmxService;
    }

    public void setRegistryService(RegistryService registryService) {
        if (!this.__MsetRegistryService$org_ow2_jonas_registry_RegistryService) {
            this.__setRegistryService(registryService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", new Object[]{registryService});
            this.__setRegistryService(registryService);
            this.__IM.onExit((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", throwable);
            throw throwable;
        }
    }

    private void __setRegistryService(RegistryService registryService) {
        MultitenantServiceImpl.registryService = registryService;
    }

    protected void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __doStart() throws ServiceException {
        MultitenantVirtualJNDIBinding.initialize(jmxService, registryService, this);
        jmxService.loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        try {
            jmxService.registerModelMBean((Object)this, JonasObjectName.multitenant((String)this.getDomainName()));
        }
        catch (Exception e) {
            throw new ServiceException("Cannot register 'multitenant' service MBean", (Throwable)e);
        }
        logger.info((Object)"Multitenant service management bean has been registered successfully", new Object[0]);
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __doStop() throws ServiceException {
        jmxService.unregisterMBean(JonasObjectName.multitenant((String)this.getDomainName()));
        logger.info((Object)"Multitenant service management bean has been unregistered successfully", new Object[0]);
    }

    @Override
    public Filter getTenantIdFilter(String string) {
        Filter filter;
        if (!this.__MgetTenantIdFilter$java_lang_String) {
            return this.__getTenantIdFilter(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getTenantIdFilter$java_lang_String", new Object[]{string});
            filter = this.__getTenantIdFilter(string);
            this.__IM.onExit((Object)this, "getTenantIdFilter$java_lang_String", (Object)filter);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTenantIdFilter$java_lang_String", throwable);
            throw throwable;
        }
        return filter;
    }

    private Filter __getTenantIdFilter(String tenantId) {
        return new HttpTenantIdFilter(tenantId);
    }

    @Override
    public String getDefaultTenantID() {
        String string;
        if (!this.__MgetDefaultTenantID) {
            return this.__getDefaultTenantID();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultTenantID", new Object[0]);
            string = this.__getDefaultTenantID();
            this.__IM.onExit((Object)this, "getDefaultTenantID", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultTenantID", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getDefaultTenantID() {
        return "T0";
    }

    @Override
    public void createJNDIBindingMBeans(IDeployable<?> iDeployable, String string) {
        if (!this.__McreateJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String) {
            this.__createJNDIBindingMBeans(iDeployable, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String", new Object[]{iDeployable, string});
            this.__createJNDIBindingMBeans(iDeployable, string);
            this.__IM.onExit((Object)this, "createJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __createJNDIBindingMBeans(IDeployable<?> deployable, String tenantId) {
        if (tenantId.equals(this.getDefaultTenantID())) {
            logger.warn((Object)"This application has not a specific tenant identifier. Default tenant identifier is used", new Object[0]);
        }
        String applicationName = this.getOriginalDeployable(deployable).getModuleName();
        String prefix = tenantId;
        MultitenantVirtualJNDIBinding.createJNDIBindingMBeans(applicationName, prefix);
    }

    private IDeployable<?> getOriginalDeployable(IDeployable<?> iDeployable) {
        IDeployable<?> iDeployable2;
        if (!this.__MgetOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            return this.__getOriginalDeployable(iDeployable);
        }
        try {
            this.__IM.onEntry((Object)this, "getOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            iDeployable2 = this.__getOriginalDeployable(iDeployable);
            this.__IM.onExit((Object)this, "getOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable", iDeployable2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
        return iDeployable2;
    }

    private IDeployable<?> __getOriginalDeployable(IDeployable<?> deployable) {
        IDeployable originalDeployable = deployable;
        while (originalDeployable.getOriginalDeployable() != null) {
            originalDeployable = originalDeployable.getOriginalDeployable();
        }
        return originalDeployable;
    }

    @Override
    public void garbageCollectJNDIBindingMBeans() {
        if (!this.__MgarbageCollectJNDIBindingMBeans) {
            this.__garbageCollectJNDIBindingMBeans();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "garbageCollectJNDIBindingMBeans", new Object[0]);
            this.__garbageCollectJNDIBindingMBeans();
            this.__IM.onExit((Object)this, "garbageCollectJNDIBindingMBeans", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "garbageCollectJNDIBindingMBeans", throwable);
            throw throwable;
        }
    }

    private void __garbageCollectJNDIBindingMBeans() {
        MultitenantVirtualJNDIBinding.garbageCollectJNDIBindingMBeans();
    }

    @Override
    public void updatePersistenceUnitManager(EZBPersistenceUnitManager eZBPersistenceUnitManager, String string) {
        if (!this.__MupdatePersistenceUnitManager$org_ow2_easybeans_persistence_api_EZBPersistenceUnitManager$java_lang_String) {
            this.__updatePersistenceUnitManager(eZBPersistenceUnitManager, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updatePersistenceUnitManager$org_ow2_easybeans_persistence_api_EZBPersistenceUnitManager$java_lang_String", new Object[]{eZBPersistenceUnitManager, string});
            this.__updatePersistenceUnitManager(eZBPersistenceUnitManager, string);
            this.__IM.onExit((Object)this, "updatePersistenceUnitManager$org_ow2_easybeans_persistence_api_EZBPersistenceUnitManager$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updatePersistenceUnitManager$org_ow2_easybeans_persistence_api_EZBPersistenceUnitManager$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __updatePersistenceUnitManager(EZBPersistenceUnitManager persistenceUnitManager, String tenantId) {
        String sessionCustomizerProperty = "eclipselink.session.customizer";
        String sessionCustomizerClass = "org.ow2.easybeans.persistence.eclipselink.MultitenantEntitiesSessionCustomizer";
        persistenceUnitManager.addProperty(sessionCustomizerProperty, sessionCustomizerClass);
        String tenantIdProperty = "eclipselink.tenant-id";
        String tenantIdValue = tenantId;
        persistenceUnitManager.addProperty(tenantIdProperty, tenantIdValue);
        logger.debug((Object)"Tenant id ''{0}'' was propagate to eclipselink", new Object[]{tenantId});
    }

    @Override
    public void addTenantIdDeployableInfo(IDeployable iDeployable, String string) {
        if (!this.__MaddTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String) {
            this.__addTenantIdDeployableInfo(iDeployable, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String", new Object[]{iDeployable, string});
            this.__addTenantIdDeployableInfo(iDeployable, string);
            this.__IM.onExit((Object)this, "addTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addTenantIdDeployableInfo(IDeployable deployable, String tenantId) {
        TenantIdInfo tenantIdInfo = new TenantIdInfo();
        tenantIdInfo.setTenantIdInfo(tenantId);
        deployable.addExtension((IDeployableInfo)tenantIdInfo);
    }

    @Override
    public String getTenantIdDeployableInfo(IDeployable iDeployable) {
        String string;
        if (!this.__MgetTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            return this.__getTenantIdDeployableInfo(iDeployable);
        }
        try {
            this.__IM.onEntry((Object)this, "getTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            string = this.__getTenantIdDeployableInfo(iDeployable);
            this.__IM.onExit((Object)this, "getTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getTenantIdDeployableInfo(IDeployable deployable) {
        if (deployable == null) {
            logger.debug((Object)"Deployable is null", new Object[0]);
            return null;
        }
        IDeployableInfo tenantIdInfo = deployable.getExtension(TenantIdInfo.class);
        String tenantId = null;
        try {
            if (tenantIdInfo != null) {
                tenantId = (String)tenantIdInfo.getClass().getDeclaredMethod("getTenantIdInfo", new Class[0]).invoke((Object)tenantIdInfo, new Object[0]);
            } else {
                logger.debug((Object)"TenantIdInfo was not found in ''{0}''", new Object[]{deployable});
            }
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("Method was not found", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("Invocation method fail ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Method access fail", (Throwable)e);
        }
        return tenantId;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("defaultPolicy")) {
                this.__FdefaultPolicy = true;
            }
            if (set.contains("multitenantEnabled")) {
                this.__FmultitenantEnabled = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getDefaultDeploymentPolicy")) {
                this.__MgetDefaultDeploymentPolicy = true;
            }
            if (set.contains("isMultitenantEnabled")) {
                this.__MisMultitenantEnabled = true;
            }
            if (set.contains("setJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MsetJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("setRegistryService$org_ow2_jonas_registry_RegistryService")) {
                this.__MsetRegistryService$org_ow2_jonas_registry_RegistryService = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("getTenantIdFilter$java_lang_String")) {
                this.__MgetTenantIdFilter$java_lang_String = true;
            }
            if (set.contains("getDefaultTenantID")) {
                this.__MgetDefaultTenantID = true;
            }
            if (set.contains("createJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String")) {
                this.__McreateJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String = true;
            }
            if (set.contains("getOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MgetOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("garbageCollectJNDIBindingMBeans")) {
                this.__MgarbageCollectJNDIBindingMBeans = true;
            }
            if (set.contains("updatePersistenceUnitManager$org_ow2_easybeans_persistence_api_EZBPersistenceUnitManager$java_lang_String")) {
                this.__MupdatePersistenceUnitManager$org_ow2_easybeans_persistence_api_EZBPersistenceUnitManager$java_lang_String = true;
            }
            if (set.contains("addTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String")) {
                this.__MaddTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String = true;
            }
            if (set.contains("getTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MgetTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

