/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.PortInfo;
import org.apache.cxf.BusException;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.WSDLGetInterceptor;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.ow2.jonas.ws.cxf.jaxws.CXFWSEndpoint;
import org.ow2.jonas.ws.cxf.jaxws.WebservicesContainer;
import org.ow2.jonas.ws.cxf.wsdl.ContainerWsdlInterceptor;
import org.ow2.jonas.ws.jaxws.handler.PostConstructProcessor;
import org.ow2.jonas.ws.jaxws.handler.builder.AnnotationHandlerChainBuilder;
import org.ow2.jonas.ws.jaxws.handler.builder.HandlerChainBuilder;
import org.ow2.util.annotation.processor.DefaultAnnotationProcessor;
import org.ow2.util.annotation.processor.IAnnotationHandler;
import org.ow2.util.annotation.processor.ProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASJaxWsServerFactoryBean
extends JaxWsServerFactoryBean {
    private HandlerChainBuilder handlerChainBuilder;
    private WebservicesContainer<? extends CXFWSEndpoint> container;

    public JOnASJaxWsServerFactoryBean(JaxWsServiceFactoryBean serviceFactory, WebservicesContainer<? extends CXFWSEndpoint> container) {
        super(serviceFactory);
        this.container = container;
        this.doInit = false;
    }

    public void setHandlerChainBuilder(HandlerChainBuilder builder) {
        this.handlerChainBuilder = builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server create() {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JaxWsServiceFactoryBean.class.getClassLoader());
            Server server = super.create();
            this.buildHandlerChain();
            Server server2 = server;
            return server2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void buildHandlerChain() {
        if (this.handlerChainBuilder == null) {
            this.handlerChainBuilder = new AnnotationHandlerChainBuilder(this.getServiceBeanClass());
        }
        final JaxWsServiceFactoryBean sf = (JaxWsServiceFactoryBean)this.getServiceFactory();
        PortInfo portInfo = new PortInfo(){

            public QName getServiceName() {
                return sf.getServiceQName();
            }

            public QName getPortName() {
                return sf.getEndpointInfo().getName();
            }

            public String getBindingID() {
                return JOnASJaxWsServerFactoryBean.this.getBindingId();
            }
        };
        ArrayList chain = new ArrayList(this.handlers);
        chain.addAll(this.handlerChainBuilder.buildHandlerChain(portInfo, this.getHandlerClassLoader()));
        for (Handler h : chain) {
            this.injectHandler(h);
            this.constructHandler(h);
        }
        ((JaxWsEndpointImpl)this.getServer().getEndpoint()).getJaxwsBinding().setHandlerChain(chain);
    }

    protected ClassLoader getHandlerClassLoader() {
        return this.getServiceBeanClass().getClassLoader();
    }

    private void injectHandler(Handler handler) {
        DefaultAnnotationProcessor processor = new DefaultAnnotationProcessor();
        try {
            processor.process((Object)handler);
        }
        catch (ProcessorException e) {
            throw new WebServiceException("Cannot inject resources", (Throwable)e);
        }
    }

    private void constructHandler(Handler handler) {
        DefaultAnnotationProcessor processor = new DefaultAnnotationProcessor();
        processor.addAnnotationHandler((IAnnotationHandler)new PostConstructProcessor());
        try {
            processor.process((Object)handler);
        }
        catch (ProcessorException e) {
            throw new WebServiceException("Cannot start handler", (Throwable)e);
        }
    }

    protected Endpoint createEndpoint() throws BusException, EndpointException {
        Endpoint endpoint = super.createEndpoint();
        int index = endpoint.getInInterceptors().indexOf(WSDLGetInterceptor.INSTANCE);
        if (index != -1) {
            endpoint.getInInterceptors().add(index, new ContainerWsdlInterceptor(this.container));
        }
        return endpoint;
    }
}

