/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Util;

public class JmxTest {
    MBeanServer server;
    JChannel channel;
    final String domain = "JGroups";

    private boolean start(String props) throws Exception {
        this.server = Util.getMBeanServer();
        if (this.server == null) {
            System.err.println("No MBeanServers found;\nJmxTest needs to be run with an MBeanServer present, or inside JDK 5");
            return false;
        }
        this.channel = new JChannel(props);
        this.channel.connect("DemoChannel");
        JmxConfigurator.registerChannel(this.channel, this.server, "JGroups", this.channel.getClusterName(), true);
        return true;
    }

    void doWork() throws Exception {
        this.server = Util.getMBeanServer();
        if (this.server == null) {
            System.err.println("No MBeanServers found;\nJmxTest needs to be run with an MBeanServer present, or inside JDK 5");
            return;
        }
        ObjectName channelName = new ObjectName("JGroups:channel=DemoChannel");
        View v = (View)this.server.getAttribute(channelName, "View");
        System.out.println("view: " + v);
        System.out.println("sending some messages");
        for (int i = 0; i < 5; ++i) {
            Message msg = new Message(null, null, "hello from " + i);
            this.server.invoke(channelName, "send", new Object[]{msg}, new String[]{msg.getClass().getName()});
        }
        Util.sleep(500L);
        int numMsgs = (Integer)this.server.getAttribute(channelName, "NumMessages");
        System.out.println("channel has " + numMsgs + " messages:");
        String queue = (String)this.server.invoke(channelName, "dumpQueue", null, null);
        System.out.println(queue);
        System.out.println("messages are:");
        for (int i = 0; i < numMsgs; ++i) {
            Object obj = this.server.invoke(channelName, "receive", new Object[]{new Long(10L)}, new String[]{Long.TYPE.getName()});
            System.out.println("#" + i + ": " + obj);
        }
    }

    public static void main(String[] args) {
        String props = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            System.out.println("JmxTest [-props <props>]");
        }
        try {
            boolean rc = false;
            JmxTest test = new JmxTest();
            rc = test.start(props);
            if (!rc) {
                return;
            }
            while (true) {
                Util.sleep(60000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

