/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.deployment.web.lib.WebDeploymentDescManager;
import org.ow2.jonas.deployment.ws.WSDeploymentDesc;
import org.ow2.jonas.deployment.ws.lib.WSDeploymentDescManager;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Application;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.EjbRefModule;
import org.ow2.jonas.generators.genbase.archive.FileArchive;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.archive.WsClient;
import org.ow2.jonas.generators.genbase.archive.WsEndpoint;
import org.ow2.jonas.generators.genbase.utils.TempRepository;
import org.ow2.jonas.generators.genbase.utils.XMLUtils;
import org.ow2.jonas.lib.loader.WebappClassLoader;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WebApp
extends J2EEArchive
implements EjbRefModule,
WsClient,
WsEndpoint {
    private Application app = null;
    private String webFilename;
    private WebContainerDeploymentDesc webDD;
    private WSDeploymentDesc wsDD = null;
    private List sRefs;
    private Document webApp = null;
    private Document jonasWebApp = null;
    private Document webservices = null;
    private Document jonasWebservices = null;
    private Document context = null;
    private Document webjetty = null;
    private Map descriptors;
    private List ejbRefs;

    public WebApp(Archive archive) throws GenBaseException {
        super(archive);
        this.webFilename = archive.getName();
        if (WebApp.getLogger().isLoggable(BasicLevel.DEBUG)) {
            WebApp.getLogger().log(BasicLevel.DEBUG, (Object)("Wrapping '" + archive.getName() + "' in WebApp"));
        }
        this.init();
    }

    public WebApp(Archive archive, Application app) throws GenBaseException {
        super(archive);
        this.webFilename = archive.getName();
        this.setApplication(app);
        if (WebApp.getLogger().isLoggable(BasicLevel.DEBUG)) {
            WebApp.getLogger().log(BasicLevel.DEBUG, (Object)("Wrapping '" + archive.getName() + "' in WebApp"));
        }
        this.init();
    }

    private void init() throws GenBaseException {
        this.loadDescriptors();
    }

    private void loadDescriptors() throws GenBaseException {
        try {
            InputStream isWebJetty;
            InputStream isContext;
            InputStream isJWS;
            InputStream isWS;
            InputStream is;
            InputStream webIs = this.getWebInputStream();
            if (webIs != null) {
                this.webApp = XMLUtils.newDocument(webIs, "WEB-INF/web.xml", this.isDTDsAllowed());
            }
            if ((is = this.getJonasWebInputStream()) != null) {
                this.jonasWebApp = XMLUtils.newDocument(is, "WEB-INF/jonas-web.xml", this.isDTDsAllowed());
            }
            if ((isWS = this.getWebservicesInputStream()) != null) {
                this.webservices = XMLUtils.newDocument(isWS, "WEB-INF/webservices.xml", this.isDTDsAllowed());
            }
            if ((isJWS = this.getJonasWebservicesInputStream()) != null) {
                this.jonasWebservices = XMLUtils.newDocument(isJWS, "WEB-INF/jonas-webservices.xml", this.isDTDsAllowed());
            }
            if ((isContext = this.getContextInputStream()) != null) {
                this.context = XMLUtils.newDocument(isContext, "META-INF/context.xml", this.isDTDsAllowed(), false);
            }
            if ((isWebJetty = this.getWebJettyInputStream()) != null) {
                this.webjetty = XMLUtils.newDocument(isWebJetty, "WEB-INF/web-jetty.xml", true, true);
            }
        }
        catch (SAXException saxe) {
            String err = WebApp.getI18n().getMessage("WebApp.loadDescriptors.parseError");
            throw new GenBaseException(err, saxe);
        }
        catch (ParserConfigurationException pce) {
            String err = WebApp.getI18n().getMessage("WebApp.loadDescriptors.prepare");
            throw new GenBaseException(err, pce);
        }
        catch (IOException ioe) {
            String err = WebApp.getI18n().getMessage("WebApp.loadDescriptors.parseError");
            throw new GenBaseException(err, ioe);
        }
        this.descriptors = new Hashtable();
        if (this.webApp != null) {
            this.descriptors.put("WEB-INF/web.xml", this.webApp);
        }
        if (this.jonasWebApp != null) {
            this.descriptors.put("WEB-INF/jonas-web.xml", this.jonasWebApp);
        }
        if (this.webservices != null) {
            this.descriptors.put("WEB-INF/webservices.xml", this.webservices);
        }
        if (this.jonasWebservices != null) {
            this.descriptors.put("WEB-INF/jonas-webservices.xml", this.jonasWebservices);
        }
        if (this.context != null) {
            this.descriptors.put("META-INF/context.xml", this.context);
        }
        if (this.webjetty != null) {
            this.descriptors.put("WEB-INF/web-jetty.xml", this.webjetty);
        }
    }

    public String getName() {
        return this.webFilename;
    }

    public void setApplication(Application app) {
        this.app = app;
    }

    public Application getApplication() {
        return this.app;
    }

    public List getServiceRefDescs() {
        return this.sRefs;
    }

    public List getServiceDescs() {
        if (this.wsDD != null) {
            return this.wsDD.getServiceDescs();
        }
        return new Vector();
    }

    public void addClasses(File classes) {
        this.addDirectoryIn("WEB-INF/classes", classes);
    }

    public Document getWebAppDoc() {
        return this.webApp;
    }

    public Document getJonasWebAppDoc() {
        return this.jonasWebApp;
    }

    public Document getWebservicesDoc() {
        return this.webservices;
    }

    public Document getJonasWebservicesDoc() {
        return this.jonasWebservices;
    }

    public Document newContextDoc() throws GenBaseException {
        this.context = this.loadXMLDescriptorAsResource("context.xml", "META-INF/context.xml", false);
        return this.context;
    }

    public Document newWebJettyDoc() throws GenBaseException {
        this.webjetty = this.loadXMLDescriptorAsResource("web-jetty.xml", "WEB-INF/web-jetty.xml");
        return this.webjetty;
    }

    private Document loadXMLDescriptorAsResource(String resource, String name) throws GenBaseException {
        return this.loadXMLDescriptorAsResource(resource, name, true);
    }

    private Document loadXMLDescriptorAsResource(String resource, String name, boolean validate) throws GenBaseException {
        Document doc = null;
        try {
            doc = XMLUtils.newDocument(this.getClass().getResourceAsStream(resource), name, validate);
        }
        catch (Exception e) {
            throw new GenBaseException("Cannot load '" + name + "'", e);
        }
        this.descriptors.put(name, doc);
        return doc;
    }

    public Document getContextDoc() {
        return this.context;
    }

    public Document getWebJettyDoc() {
        return this.webjetty;
    }

    private InputStream getWebInputStream() throws IOException {
        InputStream is = null;
        is = this.isPacked() ? this.getInputStream("WEB-INF/web.xml") : this.getInputStream("WEB-INF" + File.separator + "web.xml");
        return is;
    }

    private InputStream getJonasWebInputStream() throws IOException {
        InputStream is = null;
        is = this.isPacked() ? this.getInputStream("WEB-INF/jonas-web.xml") : this.getInputStream("WEB-INF" + File.separator + "jonas-web.xml");
        return is;
    }

    private InputStream getWebservicesInputStream() throws IOException {
        InputStream is = null;
        is = this.isPacked() ? this.getInputStream("WEB-INF/webservices.xml") : this.getInputStream("WEB-INF" + File.separator + "webservices.xml");
        return is;
    }

    private InputStream getJonasWebservicesInputStream() throws IOException {
        InputStream is = null;
        is = this.isPacked() ? this.getInputStream("WEB-INF/jonas-webservices.xml") : this.getInputStream("WEB-INF" + File.separator + "jonas-webservices.xml");
        return is;
    }

    private InputStream getContextInputStream() throws IOException {
        InputStream is = null;
        is = this.isPacked() ? this.getInputStream("META-INF/context.xml") : this.getInputStream("META-INF" + File.separator + "context.xml");
        return is;
    }

    private InputStream getWebJettyInputStream() throws IOException {
        InputStream is = null;
        is = this.isPacked() ? this.getInputStream("WEB-INF/web-jetty.xml") : this.getInputStream("WEB-INF" + File.separator + "web-jetty.xml");
        return is;
    }

    public Map getDescriptors() {
        return this.descriptors;
    }

    public boolean omit(String name) {
        return name.equals("WEB-INF/web.xml") || name.equals("WEB-INF\\web.xml") || name.equals("WEB-INF/jonas-web.xml") || name.equals("WEB-INF\\jonas-web.xml") || name.equals("WEB-INF/webservices.xml") || name.equals("WEB-INF\\webservices.xml") || name.equals("WEB-INF/jonas-webservices.xml") || name.equals("WEB-INF\\jonas-webservices.xml") || name.equals("META-INF/context.xml") || name.equals("META-INF\\context.xml") || name.equals("WEB-INF/web-jetty.xml") || name.equals("WEB-INF\\web-jetty.xml");
    }

    public void initialize() throws GenBaseException {
        File webappUnpackDir = this.getRootFile();
        try {
            if (this.getArchive().isPacked()) {
                JarFile jf = new JarFile(this.getRootFile());
                TempRepository tr = TempRepository.getInstance();
                webappUnpackDir = tr.createDir(".war");
                FileUtils.unpack((JarFile)jf, (File)webappUnpackDir);
                jf.close();
                this.setArchive(new FileArchive(webappUnpackDir));
            }
            if (this.app == null) {
                this.setModuleClassloader((ClassLoader)new WebappClassLoader(webappUnpackDir.toURL(), Thread.currentThread().getContextClassLoader()));
            } else {
                this.setModuleClassloader((ClassLoader)new WebappClassLoader(webappUnpackDir.toURL(), (ClassLoader)this.app.getEJBClassLoader()));
            }
        }
        catch (IOException ioe) {
            String err = WebApp.getI18n().getMessage("WebApp.init.loader", (Object)this.getArchive().getRootFile());
            throw new GenBaseException(err, ioe);
        }
        catch (FileUtilsException fue) {
            String err = WebApp.getI18n().getMessage("WebApp.init.loader", (Object)this.getArchive().getRootFile());
            throw new GenBaseException(err, (Exception)((Object)fue));
        }
        try {
            this.webDD = WebDeploymentDescManager.getDeploymentDesc((String)webappUnpackDir.getAbsolutePath(), (ClassLoader)this.getModuleClassloader());
        }
        catch (DeploymentDescException dde) {
            throw new GenBaseException((Exception)((Object)dde));
        }
        try {
            this.wsDD = WSDeploymentDescManager.getDeploymentDesc((String)webappUnpackDir.getAbsolutePath(), (ClassLoader)this.getModuleClassloader());
        }
        catch (DeploymentDescException dde) {
            throw new GenBaseException((Exception)((Object)dde));
        }
        this.sRefs = new Vector();
        IServiceRefDesc[] refs = this.webDD.getServiceRefDesc();
        for (int i = 0; i < refs.length; ++i) {
            this.sRefs.add(refs[i]);
        }
        this.ejbRefs = new Vector();
        EjbRefDesc[] refDesc = this.webDD.getEjbRefDesc();
        for (int i = 0; i < refDesc.length; ++i) {
            this.ejbRefs.add(refDesc[i]);
        }
    }

    public String getContextRoot() {
        return this.wsDD.getContextRoot();
    }

    public List getEjbRefDescs() {
        return this.ejbRefs;
    }

    public void close() {
        this.sRefs = null;
        this.ejbRefs = null;
        this.webDD = null;
        this.wsDD = null;
        this.webApp = null;
        this.app = null;
        this.descriptors = null;
        this.jonasWebApp = null;
        this.webFilename = null;
        this.webservices = null;
        this.jonasWebservices = null;
        this.context = null;
        this.webjetty = null;
    }
}

