/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.unified;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELResolver;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.el.convert.PropertyResolverToELResolver;
import org.apache.myfaces.el.convert.VariableResolverToELResolver;
import org.apache.myfaces.shared_impl.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverBuilderBase {
    private static final Logger log = Logger.getLogger(ResolverBuilderBase.class.getName());
    public static final String EL_RESOLVER_COMPARATOR = "org.apache.myfaces.EL_RESOLVER_COMPARATOR";
    private final RuntimeConfig _config;

    public ResolverBuilderBase(RuntimeConfig config) {
        this._config = config;
    }

    protected void addFromRuntimeConfig(List<ELResolver> resolvers) {
        if (this._config.getFacesConfigElResolvers() != null) {
            for (ELResolver resolver : this._config.getFacesConfigElResolvers()) {
                resolvers.add(resolver);
            }
        }
        if (this._config.getVariableResolver() != null) {
            resolvers.add(this.createELResolver(this._config.getVariableResolver()));
        } else if (this._config.getVariableResolverChainHead() != null) {
            resolvers.add(this.createELResolver(this._config.getVariableResolverChainHead()));
        }
        if (this._config.getPropertyResolver() != null) {
            resolvers.add(this.createELResolver(this._config.getPropertyResolver()));
        } else if (this._config.getPropertyResolverChainHead() != null) {
            resolvers.add(this.createELResolver(this._config.getPropertyResolverChainHead()));
        }
        if (this._config.getApplicationElResolvers() != null) {
            for (ELResolver resolver : this._config.getApplicationElResolvers()) {
                resolvers.add(resolver);
            }
        }
    }

    protected void sortELResolvers(List<ELResolver> resolvers) {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        String comparatorClass = externalContext.getInitParameter(EL_RESOLVER_COMPARATOR);
        if (comparatorClass != null && !"".equals(comparatorClass)) {
            Comparator comparator = (Comparator)externalContext.getApplicationMap().get(EL_RESOLVER_COMPARATOR);
            try {
                if (comparator == null) {
                    Class clazz = ClassUtils.classForName(comparatorClass);
                    comparator = (Comparator)clazz.newInstance();
                    externalContext.getApplicationMap().put(EL_RESOLVER_COMPARATOR, comparator);
                }
                Collections.sort(resolvers, comparator);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not sort ELResolvers with custom Comparator", e);
            }
        }
    }

    protected ELResolver createELResolver(VariableResolver resolver) {
        return new VariableResolverToELResolver(resolver);
    }

    protected ELResolver createELResolver(PropertyResolver resolver) {
        return new PropertyResolverToELResolver(resolver);
    }
}

