/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.services.bootstrap.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.services.bootstrap.repository.JOnASRepositoriesMBean;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.exceptions.InvalidRepositoryException;
import org.ow2.util.plan.bindings.repository.ExtendedRepository;
import org.ow2.util.plan.bindings.repository.Repositories;
import org.ow2.util.plan.bindings.repository.Repository;
import org.ow2.util.plan.bindings.repository.RepositoryKind;
import org.ow2.util.plan.deployer.api.IRepositoryDeployer;
import org.ow2.util.plan.reader.repository.IRepositoryDataReader;
import org.ow2.util.plan.repository.api.IRepositoryManager;
import org.ow2.util.plan.repository.api.RepositoryIdCollisionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASRepositories
implements JOnASRepositoriesMBean,
Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private boolean __FserverProperties;
    private ServerProperties serverProperties;
    private boolean __FrepositoryManager;
    private IRepositoryManager repositoryManager;
    private boolean __FconfigurationAdmin;
    private ConfigurationAdmin configurationAdmin;
    private boolean __FmbeanServer;
    private MBeanServer mbeanServer;
    private boolean __FrepositoryDeployer;
    private IRepositoryDeployer repositoryDeployer;
    private boolean __FrepositoryReader;
    private IRepositoryDataReader repositoryReader;
    private static final String PROP_M2_LOCAL_REPOSITORY = "m2.repository";
    private static final String PATH_DEFAULT_REPOSITORY = ".m2/repository";
    private static final String CONFIG_FILE = "initial-repositories.xml";
    private static final String ROOT_URL_INTERNAL_REPOSITORY_ID = "Root URL internal";
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MgetRepositoryDeployablesCount;
    private boolean __MgetRepositoriesDescriptions;
    private boolean __MgetURLRepositories;
    private boolean __MgetRepositoriesNumber;
    private boolean __MsetServerProperties$org_ow2_jonas_properties_ServerProperties;
    private boolean __MsetRepositoryManager$org_ow2_util_plan_repository_api_IRepositoryManager;
    private boolean __MsetRepositoryDeployer$org_ow2_util_plan_deployer_api_IRepositoryDeployer;
    private boolean __MsetMBeanServer$javax_management_MBeanServer;
    private boolean __MsetRepositoryReader$org_ow2_util_plan_reader_repository_IRepositoryDataReader;
    private boolean __MsetConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin;
    private boolean __MaddLocalRepositories;
    private boolean __MaddRepository$java_lang_String$java_lang_String$org_ow2_util_plan_bindings_repository_RepositoryKind;
    private boolean __MaddLocalMaven2Repositories;
    private boolean __MgetURLInternalRootRepositoryLocation;
    private boolean __MgetURLInternalBaseRepositoryLocation;
    private boolean __MgetMaven2RepositoryLocation;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    ServerProperties __getserverProperties() {
        if (!this.__FserverProperties) {
            return this.serverProperties;
        }
        return (ServerProperties)this.__IM.onGet((Object)this, "serverProperties");
    }

    void __setserverProperties(ServerProperties serverProperties) {
        if (!this.__FserverProperties) {
            this.serverProperties = serverProperties;
            return;
        }
        this.__IM.onSet((Object)this, "serverProperties", (Object)serverProperties);
    }

    IRepositoryManager __getrepositoryManager() {
        if (!this.__FrepositoryManager) {
            return this.repositoryManager;
        }
        return (IRepositoryManager)this.__IM.onGet((Object)this, "repositoryManager");
    }

    void __setrepositoryManager(IRepositoryManager iRepositoryManager) {
        if (!this.__FrepositoryManager) {
            this.repositoryManager = iRepositoryManager;
            return;
        }
        this.__IM.onSet((Object)this, "repositoryManager", (Object)iRepositoryManager);
    }

    ConfigurationAdmin __getconfigurationAdmin() {
        if (!this.__FconfigurationAdmin) {
            return this.configurationAdmin;
        }
        return (ConfigurationAdmin)this.__IM.onGet((Object)this, "configurationAdmin");
    }

    void __setconfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (!this.__FconfigurationAdmin) {
            this.configurationAdmin = configurationAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "configurationAdmin", (Object)configurationAdmin);
    }

    MBeanServer __getmbeanServer() {
        if (!this.__FmbeanServer) {
            return this.mbeanServer;
        }
        return (MBeanServer)this.__IM.onGet((Object)this, "mbeanServer");
    }

    void __setmbeanServer(MBeanServer mBeanServer) {
        if (!this.__FmbeanServer) {
            this.mbeanServer = mBeanServer;
            return;
        }
        this.__IM.onSet((Object)this, "mbeanServer", (Object)mBeanServer);
    }

    IRepositoryDeployer __getrepositoryDeployer() {
        if (!this.__FrepositoryDeployer) {
            return this.repositoryDeployer;
        }
        return (IRepositoryDeployer)this.__IM.onGet((Object)this, "repositoryDeployer");
    }

    void __setrepositoryDeployer(IRepositoryDeployer iRepositoryDeployer) {
        if (!this.__FrepositoryDeployer) {
            this.repositoryDeployer = iRepositoryDeployer;
            return;
        }
        this.__IM.onSet((Object)this, "repositoryDeployer", (Object)iRepositoryDeployer);
    }

    IRepositoryDataReader __getrepositoryReader() {
        if (!this.__FrepositoryReader) {
            return this.repositoryReader;
        }
        return (IRepositoryDataReader)this.__IM.onGet((Object)this, "repositoryReader");
    }

    void __setrepositoryReader(IRepositoryDataReader iRepositoryDataReader) {
        if (!this.__FrepositoryReader) {
            this.repositoryReader = iRepositoryDataReader;
            return;
        }
        this.__IM.onSet((Object)this, "repositoryReader", (Object)iRepositoryDataReader);
    }

    public JOnASRepositories() {
        this(null);
    }

    private JOnASRepositories(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(JOnASRepositories.class));
        this.__setserverProperties(null);
        this.__setrepositoryManager(null);
        this.__setconfigurationAdmin(null);
        this.__setmbeanServer(null);
        this.__setrepositoryReader(null);
    }

    public void start() throws Exception {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() throws Exception {
        Configuration configuration = this.__getconfigurationAdmin().getConfiguration("org.ow2.util.plan.fetcher", null);
        if (configuration != null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("local.repositories.base.dir", JProp.getJonasBase() + "/repositories");
            configuration.update(props);
        }
        this.addLocalRepositories();
        Repositories initialRepositories = null;
        File configFile = new File(JProp.getConfDir(), CONFIG_FILE);
        if (configFile.exists()) {
            try {
                initialRepositories = this.__getrepositoryReader().readRepositories(configFile);
            }
            catch (Exception e) {
                this.__getlogger().error((Object)"Exception while parsing the initial repositories file : {0}", new Object[]{e});
            }
        }
        if (initialRepositories != null) {
            int repositoryCount = 0;
            for (Repository repository : initialRepositories.getRepositories()) {
                try {
                    this.__getrepositoryManager().addRepository(repository);
                    ++repositoryCount;
                }
                catch (RepositoryIdCollisionException e) {
                    this.__getlogger().warn((Object)"Multiple repository with same id; id={0}", new Object[]{repository.getId()});
                }
                catch (InvalidRepositoryException e) {
                    this.__getlogger().warn((Object)"Invalid repository with id {0}", new Object[]{repository.getId()});
                }
            }
            this.__getlogger().debug((Object)"JOnAS started with {0} repositories.", new Object[]{repositoryCount});
        } else {
            this.__getlogger().debug((Object)"JOnAS started with no repositories", new Object[0]);
        }
        try {
            ObjectName objectName = JonasObjectName.repository((String)this.__getserverProperties().getDomainName());
            this.__getmbeanServer().registerMBean(this, objectName);
        }
        catch (Exception e) {
            this.__getlogger().error((Object)"MBean registration error, {0}", new Object[]{e});
        }
    }

    public void stop() throws Exception {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() throws Exception {
        if (this.__getmbeanServer() != null) {
            try {
                ObjectName objectName = JonasObjectName.repository((String)this.__getserverProperties().getDomainName());
                this.__getmbeanServer().unregisterMBean(objectName);
            }
            catch (Exception e) {
                this.__getlogger().error((Object)"MBean unregistration error, {0}", new Object[]{e});
            }
        }
    }

    @Override
    public Integer getRepositoryDeployablesCount() {
        Integer n;
        if (!this.__MgetRepositoryDeployablesCount) {
            return this.__getRepositoryDeployablesCount();
        }
        try {
            this.__IM.onEntry((Object)this, "getRepositoryDeployablesCount", new Object[0]);
            n = this.__getRepositoryDeployablesCount();
            this.__IM.onExit((Object)this, "getRepositoryDeployablesCount", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRepositoryDeployablesCount", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __getRepositoryDeployablesCount() {
        return this.__getrepositoryDeployer().getDeployablesCount();
    }

    @Override
    public List<String> getRepositoriesDescriptions() {
        List<String> list;
        if (!this.__MgetRepositoriesDescriptions) {
            return this.__getRepositoriesDescriptions();
        }
        try {
            this.__IM.onEntry((Object)this, "getRepositoriesDescriptions", new Object[0]);
            list = this.__getRepositoriesDescriptions();
            this.__IM.onExit((Object)this, "getRepositoriesDescriptions", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRepositoriesDescriptions", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getRepositoriesDescriptions() {
        ArrayList<String> repositoriesDescriptions = new ArrayList<String>();
        for (Repository repository : this.__getrepositoryManager()) {
            repositoriesDescriptions.add(repository.toString());
        }
        return repositoriesDescriptions;
    }

    @Override
    public List<String> getURLRepositories() {
        List<String> list;
        if (!this.__MgetURLRepositories) {
            return this.__getURLRepositories();
        }
        try {
            this.__IM.onEntry((Object)this, "getURLRepositories", new Object[0]);
            list = this.__getURLRepositories();
            this.__IM.onExit((Object)this, "getURLRepositories", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getURLRepositories", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getURLRepositories() {
        ArrayList<String> urlRepositories = new ArrayList<String>();
        for (Repository repository : this.__getrepositoryManager()) {
            RepositoryKind repositoryType = repository.getType();
            String repositoryId = repository.getId();
            if (!repositoryType.equals((Object)RepositoryKind.URL) || repositoryId.equals(ROOT_URL_INTERNAL_REPOSITORY_ID)) continue;
            String location = repository.getUrl();
            urlRepositories.add(location);
        }
        return urlRepositories;
    }

    @Override
    public Integer getRepositoriesNumber() {
        Integer n;
        if (!this.__MgetRepositoriesNumber) {
            return this.__getRepositoriesNumber();
        }
        try {
            this.__IM.onEntry((Object)this, "getRepositoriesNumber", new Object[0]);
            n = this.__getRepositoriesNumber();
            this.__IM.onExit((Object)this, "getRepositoriesNumber", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRepositoriesNumber", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __getRepositoriesNumber() {
        return this.__getrepositoryManager().getRepositoryCount();
    }

    public void setServerProperties(ServerProperties serverProperties) {
        if (!this.__MsetServerProperties$org_ow2_jonas_properties_ServerProperties) {
            this.__setServerProperties(serverProperties);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", new Object[]{serverProperties});
            this.__setServerProperties(serverProperties);
            this.__IM.onExit((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", throwable);
            throw throwable;
        }
    }

    private void __setServerProperties(ServerProperties serverProperties) {
        this.__setserverProperties(serverProperties);
    }

    public void setRepositoryManager(IRepositoryManager iRepositoryManager) {
        if (!this.__MsetRepositoryManager$org_ow2_util_plan_repository_api_IRepositoryManager) {
            this.__setRepositoryManager(iRepositoryManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRepositoryManager$org_ow2_util_plan_repository_api_IRepositoryManager", new Object[]{iRepositoryManager});
            this.__setRepositoryManager(iRepositoryManager);
            this.__IM.onExit((Object)this, "setRepositoryManager$org_ow2_util_plan_repository_api_IRepositoryManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRepositoryManager$org_ow2_util_plan_repository_api_IRepositoryManager", throwable);
            throw throwable;
        }
    }

    private void __setRepositoryManager(IRepositoryManager repositoryManager) {
        this.__setrepositoryManager(repositoryManager);
    }

    public void setRepositoryDeployer(IRepositoryDeployer iRepositoryDeployer) {
        if (!this.__MsetRepositoryDeployer$org_ow2_util_plan_deployer_api_IRepositoryDeployer) {
            this.__setRepositoryDeployer(iRepositoryDeployer);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRepositoryDeployer$org_ow2_util_plan_deployer_api_IRepositoryDeployer", new Object[]{iRepositoryDeployer});
            this.__setRepositoryDeployer(iRepositoryDeployer);
            this.__IM.onExit((Object)this, "setRepositoryDeployer$org_ow2_util_plan_deployer_api_IRepositoryDeployer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRepositoryDeployer$org_ow2_util_plan_deployer_api_IRepositoryDeployer", throwable);
            throw throwable;
        }
    }

    private void __setRepositoryDeployer(IRepositoryDeployer repositoryDeployer) {
        this.__setrepositoryDeployer(repositoryDeployer);
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        if (!this.__MsetMBeanServer$javax_management_MBeanServer) {
            this.__setMBeanServer(mBeanServer);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setMBeanServer$javax_management_MBeanServer", new Object[]{mBeanServer});
            this.__setMBeanServer(mBeanServer);
            this.__IM.onExit((Object)this, "setMBeanServer$javax_management_MBeanServer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setMBeanServer$javax_management_MBeanServer", throwable);
            throw throwable;
        }
    }

    private void __setMBeanServer(MBeanServer mbeanServer) {
        this.__setmbeanServer(mbeanServer);
    }

    public void setRepositoryReader(IRepositoryDataReader iRepositoryDataReader) {
        if (!this.__MsetRepositoryReader$org_ow2_util_plan_reader_repository_IRepositoryDataReader) {
            this.__setRepositoryReader(iRepositoryDataReader);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRepositoryReader$org_ow2_util_plan_reader_repository_IRepositoryDataReader", new Object[]{iRepositoryDataReader});
            this.__setRepositoryReader(iRepositoryDataReader);
            this.__IM.onExit((Object)this, "setRepositoryReader$org_ow2_util_plan_reader_repository_IRepositoryDataReader", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRepositoryReader$org_ow2_util_plan_reader_repository_IRepositoryDataReader", throwable);
            throw throwable;
        }
    }

    private void __setRepositoryReader(IRepositoryDataReader repositoryReader) {
        this.__setrepositoryReader(repositoryReader);
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (!this.__MsetConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin) {
            this.__setConfigurationAdmin(configurationAdmin);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", new Object[]{configurationAdmin});
            this.__setConfigurationAdmin(configurationAdmin);
            this.__IM.onExit((Object)this, "setConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin", throwable);
            throw throwable;
        }
    }

    private void __setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.__setconfigurationAdmin(configurationAdmin);
    }

    private void addLocalRepositories() {
        if (!this.__MaddLocalRepositories) {
            this.__addLocalRepositories();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addLocalRepositories", new Object[0]);
            this.__addLocalRepositories();
            this.__IM.onExit((Object)this, "addLocalRepositories", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addLocalRepositories", throwable);
            throw throwable;
        }
    }

    private void __addLocalRepositories() {
        this.addLocalMaven2Repositories();
        File base = new File(this.getURLInternalBaseRepositoryLocation());
        File root = new File(this.getURLInternalRootRepositoryLocation());
        if (!root.equals(base) && base.exists()) {
            this.addRepository("Base URL internal", base.getPath(), RepositoryKind.URL);
        }
        this.addRepository(ROOT_URL_INTERNAL_REPOSITORY_ID, root.getPath(), RepositoryKind.URL);
    }

    private void addRepository(String string, String string2, RepositoryKind repositoryKind) {
        if (!this.__MaddRepository$java_lang_String$java_lang_String$org_ow2_util_plan_bindings_repository_RepositoryKind) {
            this.__addRepository(string, string2, repositoryKind);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addRepository$java_lang_String$java_lang_String$org_ow2_util_plan_bindings_repository_RepositoryKind", new Object[]{string, string2, repositoryKind});
            this.__addRepository(string, string2, repositoryKind);
            this.__IM.onExit((Object)this, "addRepository$java_lang_String$java_lang_String$org_ow2_util_plan_bindings_repository_RepositoryKind", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addRepository$java_lang_String$java_lang_String$org_ow2_util_plan_bindings_repository_RepositoryKind", throwable);
            throw throwable;
        }
    }

    private void __addRepository(String id, String location, RepositoryKind repositoryKind) {
        ExtendedRepository repository = new ExtendedRepository();
        repository.setType(repositoryKind);
        repository.setId(id);
        String locationWithAppendingSlash = location.startsWith("/") ? location : '/' + location;
        repository.setUrl("file:" + locationWithAppendingSlash);
        try {
            this.__getrepositoryManager().addRepository((Repository)repository);
        }
        catch (RepositoryIdCollisionException e) {
            this.__getlogger().error((Object)"Cannot add repository {0}, it already exists", new Object[]{repository});
        }
        catch (InvalidRepositoryException e) {
            this.__getlogger().error((Object)"Invalid repository {0}", new Object[]{repository});
        }
    }

    private void addLocalMaven2Repositories() {
        if (!this.__MaddLocalMaven2Repositories) {
            this.__addLocalMaven2Repositories();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addLocalMaven2Repositories", new Object[0]);
            this.__addLocalMaven2Repositories();
            this.__IM.onExit((Object)this, "addLocalMaven2Repositories", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addLocalMaven2Repositories", throwable);
            throw throwable;
        }
    }

    private void __addLocalMaven2Repositories() {
        boolean developer = Boolean.getBoolean("jonas.developer");
        if (developer) {
            this.addRepository("Maven2 local repository", this.getMaven2RepositoryLocation(), RepositoryKind.MAVEN_2);
        } else {
            File repositoriesRootDir = new File(JProp.getRepositoriesRootDir());
            File repositoriesBaseDir = new File(JProp.getRepositoriesBaseDir());
            ArrayList<File> repositoriesDirs = new ArrayList<File>();
            if (repositoriesRootDir.exists()) {
                repositoriesDirs.add(repositoriesRootDir);
            }
            if (!repositoriesBaseDir.equals(repositoriesRootDir) && repositoriesBaseDir.exists()) {
                repositoriesDirs.add(repositoriesBaseDir);
            }
            for (File repositoryDir : repositoriesDirs) {
                String dir = repositoriesRootDir.equals(repositoryDir) ? "root" : "base";
                List<File> repositories = Arrays.asList(repositoryDir.listFiles());
                for (File repository : repositories) {
                    if (!repository.isDirectory() || !repository.getName().startsWith("maven2-")) continue;
                    String repositoryId = repository.getName() + "-" + dir;
                    this.addRepository(repositoryId, repository.getAbsolutePath(), RepositoryKind.MAVEN_2);
                }
            }
        }
    }

    private String getURLInternalRootRepositoryLocation() {
        String string;
        if (!this.__MgetURLInternalRootRepositoryLocation) {
            return this.__getURLInternalRootRepositoryLocation();
        }
        try {
            this.__IM.onEntry((Object)this, "getURLInternalRootRepositoryLocation", new Object[0]);
            string = this.__getURLInternalRootRepositoryLocation();
            this.__IM.onExit((Object)this, "getURLInternalRootRepositoryLocation", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getURLInternalRootRepositoryLocation", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getURLInternalRootRepositoryLocation() {
        return JProp.getRepositoriesRootDir() + File.separator + "url-internal";
    }

    private String getURLInternalBaseRepositoryLocation() {
        String string;
        if (!this.__MgetURLInternalBaseRepositoryLocation) {
            return this.__getURLInternalBaseRepositoryLocation();
        }
        try {
            this.__IM.onEntry((Object)this, "getURLInternalBaseRepositoryLocation", new Object[0]);
            string = this.__getURLInternalBaseRepositoryLocation();
            this.__IM.onExit((Object)this, "getURLInternalBaseRepositoryLocation", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getURLInternalBaseRepositoryLocation", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getURLInternalBaseRepositoryLocation() {
        return JProp.getRepositoriesBaseDir() + File.separator + "url-internal";
    }

    private String getMaven2RepositoryLocation() {
        String string;
        if (!this.__MgetMaven2RepositoryLocation) {
            return this.__getMaven2RepositoryLocation();
        }
        try {
            this.__IM.onEntry((Object)this, "getMaven2RepositoryLocation", new Object[0]);
            string = this.__getMaven2RepositoryLocation();
            this.__IM.onExit((Object)this, "getMaven2RepositoryLocation", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMaven2RepositoryLocation", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getMaven2RepositoryLocation() {
        String m2Repository = System.getProperty(PROP_M2_LOCAL_REPOSITORY);
        if (m2Repository == null) {
            String userHome = System.getProperty("user.home");
            m2Repository = userHome + File.separator + PATH_DEFAULT_REPOSITORY;
        }
        return m2Repository;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("repositoryReader")) {
                this.__FrepositoryReader = true;
            }
            if (set.contains("mbeanServer")) {
                this.__FmbeanServer = true;
            }
            if (set.contains("repositoryDeployer")) {
                this.__FrepositoryDeployer = true;
            }
            if (set.contains("serverProperties")) {
                this.__FserverProperties = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("configurationAdmin")) {
                this.__FconfigurationAdmin = true;
            }
            if (set.contains("repositoryManager")) {
                this.__FrepositoryManager = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("getRepositoryDeployablesCount")) {
                this.__MgetRepositoryDeployablesCount = true;
            }
            if (set.contains("getRepositoriesDescriptions")) {
                this.__MgetRepositoriesDescriptions = true;
            }
            if (set.contains("getURLRepositories")) {
                this.__MgetURLRepositories = true;
            }
            if (set.contains("getRepositoriesNumber")) {
                this.__MgetRepositoriesNumber = true;
            }
            if (set.contains("setServerProperties$org_ow2_jonas_properties_ServerProperties")) {
                this.__MsetServerProperties$org_ow2_jonas_properties_ServerProperties = true;
            }
            if (set.contains("setRepositoryManager$org_ow2_util_plan_repository_api_IRepositoryManager")) {
                this.__MsetRepositoryManager$org_ow2_util_plan_repository_api_IRepositoryManager = true;
            }
            if (set.contains("setRepositoryDeployer$org_ow2_util_plan_deployer_api_IRepositoryDeployer")) {
                this.__MsetRepositoryDeployer$org_ow2_util_plan_deployer_api_IRepositoryDeployer = true;
            }
            if (set.contains("setMBeanServer$javax_management_MBeanServer")) {
                this.__MsetMBeanServer$javax_management_MBeanServer = true;
            }
            if (set.contains("setRepositoryReader$org_ow2_util_plan_reader_repository_IRepositoryDataReader")) {
                this.__MsetRepositoryReader$org_ow2_util_plan_reader_repository_IRepositoryDataReader = true;
            }
            if (set.contains("setConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin")) {
                this.__MsetConfigurationAdmin$org_osgi_service_cm_ConfigurationAdmin = true;
            }
            if (set.contains("addLocalRepositories")) {
                this.__MaddLocalRepositories = true;
            }
            if (set.contains("addRepository$java_lang_String$java_lang_String$org_ow2_util_plan_bindings_repository_RepositoryKind")) {
                this.__MaddRepository$java_lang_String$java_lang_String$org_ow2_util_plan_bindings_repository_RepositoryKind = true;
            }
            if (set.contains("addLocalMaven2Repositories")) {
                this.__MaddLocalMaven2Repositories = true;
            }
            if (set.contains("getURLInternalRootRepositoryLocation")) {
                this.__MgetURLInternalRootRepositoryLocation = true;
            }
            if (set.contains("getURLInternalBaseRepositoryLocation")) {
                this.__MgetURLInternalBaseRepositoryLocation = true;
            }
            if (set.contains("getMaven2RepositoryLocation")) {
                this.__MgetMaven2RepositoryLocation = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

