/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.web.tomcat;

import org.ow2.jonas.antmodular.jonasbase.bootstrap.JReplace;
import org.ow2.jonas.antmodular.jonasbase.web.tomcat.TomcatAjp;
import org.ow2.jonas.antmodular.jonasbase.web.tomcat.TomcatHttp;
import org.ow2.jonas.antmodular.jonasbase.web.tomcat.TomcatHttps;
import org.ow2.jonas.antmodular.web.base.Ajp;
import org.ow2.jonas.antmodular.web.base.Connectors;
import org.ow2.jonas.antmodular.web.base.Director;
import org.ow2.jonas.antmodular.web.base.Http;

public abstract class TomcatConnectors
extends Connectors {
    protected boolean httpConfigured = false;
    private static final String AJP_CONNECTOR_TOKEN = "<!-- Define an AJP";
    private static final String HTTPS_CONNECTOR_TOKEN = "<!-- Define a SSL Coyote HTTP/1.1";
    private static final String DIRECTOR_CONNECTOR_TOKEN = "<!-- Define a Proxied HTTP/1.1";

    public void addConfiguredHttp(Http http, String confFile) {
        this.httpConfigured = true;
        super.addConfiguredHttp(http, confFile, "[Tomcat] ");
    }

    public void addConfiguredHttps(TomcatHttps https, String confFile) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(confFile);
        propertyReplace.setToken(HTTPS_CONNECTOR_TOKEN);
        StringBuffer value = new StringBuffer();
        value.append("<!-- Define a SSL Coyote HTTP/1.1 Connector on port " + https.getPort() + " -->\n");
        value.append("    <Connector port=\"" + https.getPort() + "\" maxHttpHeaderSize=\"8192\"\n");
        value.append("               maxThreads=\"150\" minSpareThreads=\"25\" maxSpareThreads=\"75\"\n");
        value.append("               enableLookups=\"false\" disableUploadTimeout=\"true\"\n");
        value.append("               acceptCount=\"100\" scheme=\"https\" secure=\"true\"\n");
        value.append("               clientAuth=\"false\" sslProtocol=\"TLS\"\n");
        if (https.getKeystoreFile() != null) {
            value.append("               keystoreFile=\"" + https.getKeystoreFile() + "\"\n");
        }
        if (https.getKeystorePass() != null) {
            value.append("               keystorePass=\"" + https.getKeystorePass() + "\"\n");
        }
        value.append("               />\n\n");
        value.append("    <!-- Define a SSL Coyote HTTP/1.1");
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Tomcat] Setting HTTPS Connector to : " + https.getPort());
        this.addTask(propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(confFile);
        propertyReplace.setToken(" redirectPort=\"9043\" ");
        propertyReplace.setValue(" redirectPort=\"" + https.getPort() + "\" ");
        propertyReplace.setLogInfo("[Tomcat] Fix HTTP redirect port number to : " + https.getPort());
        this.addTask(propertyReplace);
    }

    public void addConfiguredAjp(Ajp ajp, String confFile) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(confFile);
        propertyReplace.setToken(AJP_CONNECTOR_TOKEN);
        StringBuffer value = new StringBuffer();
        value.append(" <!-- Define an AJP 1.3 Connector on port " + ajp.getPort() + " -->\n");
        value.append("    <Connector port=\"" + ajp.getPort() + "\" enableLookups=\"false\"\n");
        value.append("               redirectPort=\"" + TomcatAjp.DEFAULT_REDIRECT_PORT + "\" protocol=\"AJP/1.3\" />\n\n");
        value.append("    <!-- Define an AJP");
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Tomcat] Setting AJP Connector to : " + ajp.getPort());
        this.addTask(propertyReplace);
    }

    public void addConfiguredDirector(Director dir, String confFile) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(confFile);
        propertyReplace.setToken(DIRECTOR_CONNECTOR_TOKEN);
        StringBuffer value = new StringBuffer();
        value.append("<!--  Define a Director Connector on port " + dir.getPort() + " -->\n");
        value.append("    <Connector protocol=\"org.enhydra.servlet.connectionMethods.EnhydraDirector.DirectorProtocol\"\n");
        value.append("               port=\"" + dir.getPort() + "\"\n");
        value.append("               threadTimeout = \"300\"\n");
        value.append("               clientTimeout = \"30\"\n");
        value.append("               sessionAffinity = \"false\"\n");
        value.append("               queueSize = \"400\"\n");
        value.append("               numThreads = \"200\"\n");
        value.append("               bindAddress = \"(All Interfaces)\"\n");
        value.append("               authKey = \"(Unauthenticated)\"\n");
        value.append("               />\n\n");
        value.append("    <!-- Define a Proxied HTTP/1.1");
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Tomcat] Setting Director Connector to : " + dir.getPort());
        this.addTask(propertyReplace);
    }

    public boolean isHttpConfigured() {
        return this.httpConfigured;
    }

    public abstract void addConfiguredHttp(TomcatHttp var1);

    public abstract void addConfiguredHttps(TomcatHttps var1);

    public abstract void addConfiguredDirector(Director var1);

    public abstract void addConfiguredAjp(TomcatAjp var1);
}

