/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.idlpreprocessor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.corba.idlpreprocessor.IncludeResolver;
import org.apache.cxf.tools.corba.idlpreprocessor.PreprocessingException;

public class DefaultIncludeResolver
implements IncludeResolver {
    private static final Logger LOG = LogUtils.getL7dLogger(DefaultIncludeResolver.class);
    private final File[] userIdlDirs;

    public DefaultIncludeResolver(File ... idlDirs) {
        for (File dir : idlDirs) {
            if (dir.isDirectory()) continue;
            throw new IllegalArgumentException("not a directory: " + dir.getAbsoluteFile());
        }
        this.userIdlDirs = idlDirs;
    }

    public URL findSystemInclude(String spec) {
        return this.findUserInclude(spec);
    }

    public URL findUserInclude(String spec) {
        for (File searchDir : this.userIdlDirs) {
            URI searchDirURI = searchDir.toURI();
            try {
                URL searchDirURL = searchDirURI.toURL();
                URL url = new URL(searchDirURL, spec);
                try {
                    InputStream str = url.openStream();
                    str.close();
                    return url;
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.fine("Not able to resolve " + spec + "from  " + searchDirURL.toString());
                }
            }
            catch (MalformedURLException e) {
                PreprocessingException preprocessingException = new PreprocessingException("Unable to resolve user include '" + spec + "' in '" + Arrays.toString(this.userIdlDirs) + "'", null, 0);
                preprocessingException.initCause(e);
                throw preprocessingException;
            }
        }
        throw new PreprocessingException("unable to resolve " + spec, null, 0);
    }
}

