/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.KeyValueToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyValueTokenBuilder
implements AssertionBuilder<Element> {
    private static final String MS_NS = "http://schemas.microsoft.com/ws/2005/07/securitypolicy";

    public Assertion build(Element element, AssertionBuilderFactory factory) {
        QName qname;
        Element child;
        Element polEl;
        SPConstants consts = MS_NS.equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        KeyValueToken token = new KeyValueToken(consts);
        token.setOptional(PolicyConstants.isOptional(element));
        token.setIgnorable(PolicyConstants.isIgnorable(element));
        String attribute = element.getAttributeNS(element.getNamespaceURI(), "IncludeToken");
        if (StringUtils.isEmpty(attribute)) {
            attribute = element.getAttributeNS(consts.getNamespace(), "IncludeToken");
        }
        if (StringUtils.isEmpty(attribute)) {
            attribute = element.getAttributeNS(SP11Constants.INSTANCE.getNamespace(), "IncludeToken");
        }
        if (!StringUtils.isEmpty(attribute)) {
            token.setInclusion(consts.getInclusionFromAttributeValue(attribute));
        }
        if ((polEl = PolicyConstants.findPolicyElement(element)) != null && (child = DOMUtils.getFirstElement(polEl)) != null && "RsaKeyValue".equals((qname = new QName(child.getNamespaceURI(), child.getLocalName())).getLocalPart())) {
            token.setForceRsaKeyValue(true);
        }
        return token;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.KEYVALUE_TOKEN, new QName(MS_NS, "RsaToken")};
    }
}

