/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.db.base;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.db.base.User;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsDBServiceImpl
extends AbsServiceImpl {
    private static final String DEFAULT_DATABASE_NAME = "db_jonas";
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.db");
    private List<User> users = new ArrayList<User>();
    private String port = null;
    private String dbName = "db_jonas";

    public void setUsers(String users) {
        List configuredUsers = AbsDBServiceImpl.convertToList((String)users);
        for (String user : configuredUsers) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Adding user/password '" + user + "'."));
            }
            StringTokenizer st = new StringTokenizer(user, ":");
            String name = st.nextToken();
            String pass = "";
            if (st.hasMoreTokens()) {
                pass = st.nextToken();
            }
            this.users.add(new User(name, pass));
        }
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setDbname(String db) {
        this.dbName = db;
    }

    protected abstract void initServer(List<User> var1, String var2, String var3) throws ServiceException;

    protected void doStart() throws ServiceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        this.initServer(this.users, this.dbName, this.port);
    }

    protected void doStop() throws ServiceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
    }

    public static Logger getLogger() {
        return logger;
    }
}

