/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.util;

import javax.persistence.LockModeType;
import org.hibernate.AssertionFailure;
import org.hibernate.LockMode;

public class LockModeTypeHelper {
    public static LockModeType getLockModeType(LockMode lockMode) {
        if (lockMode == LockMode.NONE) {
            return LockModeType.NONE;
        }
        if (lockMode == LockMode.OPTIMISTIC || lockMode == LockMode.READ) {
            return LockModeType.OPTIMISTIC;
        }
        if (lockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT || lockMode == LockMode.WRITE) {
            return LockModeType.OPTIMISTIC_FORCE_INCREMENT;
        }
        if (lockMode == LockMode.PESSIMISTIC_READ) {
            return LockModeType.PESSIMISTIC_READ;
        }
        if (lockMode == LockMode.PESSIMISTIC_WRITE || lockMode == LockMode.UPGRADE || lockMode == LockMode.UPGRADE_NOWAIT) {
            return LockModeType.PESSIMISTIC_WRITE;
        }
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT || lockMode == LockMode.FORCE) {
            return LockModeType.PESSIMISTIC_FORCE_INCREMENT;
        }
        throw new AssertionFailure("unhandled lock mode " + (Object)((Object)lockMode));
    }

    public static LockMode getLockMode(LockModeType lockMode) {
        switch (lockMode) {
            case READ: 
            case OPTIMISTIC: {
                return LockMode.OPTIMISTIC;
            }
            case OPTIMISTIC_FORCE_INCREMENT: 
            case WRITE: {
                return LockMode.OPTIMISTIC_FORCE_INCREMENT;
            }
            case PESSIMISTIC_READ: {
                return LockMode.PESSIMISTIC_READ;
            }
            case PESSIMISTIC_WRITE: {
                return LockMode.PESSIMISTIC_WRITE;
            }
            case PESSIMISTIC_FORCE_INCREMENT: {
                return LockMode.PESSIMISTIC_FORCE_INCREMENT;
            }
            case NONE: {
                return LockMode.NONE;
            }
        }
        throw new AssertionFailure("Unknown LockModeType: " + lockMode);
    }

    public static LockMode interpretLockMode(Object value) {
        if (value == null) {
            return LockMode.NONE;
        }
        if (LockMode.class.isInstance(value)) {
            return (LockMode)((Object)value);
        }
        if (LockModeType.class.isInstance(value)) {
            return LockModeTypeHelper.getLockMode((LockModeType)value);
        }
        if (String.class.isInstance(value)) {
            LockMode lockMode = LockMode.valueOf((String)value);
            if (lockMode == null) {
                try {
                    lockMode = LockModeTypeHelper.getLockMode(LockModeType.valueOf((String)((String)value)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (lockMode != null) {
                return lockMode;
            }
        }
        throw new IllegalArgumentException("Unknown lock mode source : " + value);
    }
}

