/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.GenerationType;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.EnumConversionHelper;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.logging.Logger;

public class IdGeneratorBinder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, IdGeneratorBinder.class.getName());

    private IdGeneratorBinder() {
    }

    public static void bind(AnnotationBindingContext bindingContext) {
        List annotations = bindingContext.getIndex().getAnnotations(JPADotNames.SEQUENCE_GENERATOR);
        for (AnnotationInstance generator : annotations) {
            IdGeneratorBinder.bindSequenceGenerator(bindingContext.getMetadataImplementor(), generator);
        }
        annotations = bindingContext.getIndex().getAnnotations(JPADotNames.TABLE_GENERATOR);
        for (AnnotationInstance generator : annotations) {
            IdGeneratorBinder.bindTableGenerator(bindingContext.getMetadataImplementor(), generator);
        }
        annotations = bindingContext.getIndex().getAnnotations(HibernateDotNames.GENERIC_GENERATOR);
        for (AnnotationInstance generator : annotations) {
            IdGeneratorBinder.bindGenericGenerator(bindingContext.getMetadataImplementor(), generator);
        }
        annotations = bindingContext.getIndex().getAnnotations(HibernateDotNames.GENERIC_GENERATORS);
        for (AnnotationInstance generators : annotations) {
            for (AnnotationInstance generator : JandexHelper.getValue(generators, "value", AnnotationInstance[].class)) {
                IdGeneratorBinder.bindGenericGenerator(bindingContext.getMetadataImplementor(), generator);
            }
        }
    }

    private static void addStringParameter(AnnotationInstance annotation, String element, Map<String, String> parameters, String parameter) {
        String string = JandexHelper.getValue(annotation, element, String.class);
        if (StringHelper.isNotEmpty(string)) {
            parameters.put(parameter, string);
        }
    }

    private static void bindGenericGenerator(MetadataImplementor metadata, AnnotationInstance generator) {
        AnnotationInstance[] parameterAnnotations;
        String name = JandexHelper.getValue(generator, "name", String.class);
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (AnnotationInstance parameterAnnotation : parameterAnnotations = JandexHelper.getValue(generator, "parameters", AnnotationInstance[].class)) {
            parameterMap.put(JandexHelper.getValue(parameterAnnotation, "name", String.class), JandexHelper.getValue(parameterAnnotation, "value", String.class));
        }
        metadata.addIdGenerator(new IdGenerator(name, JandexHelper.getValue(generator, "strategy", String.class), parameterMap));
        LOG.tracef("Add generic generator with name: %s", (Object)name);
    }

    private static void bindSequenceGenerator(MetadataImplementor metadata, AnnotationInstance generator) {
        String name = JandexHelper.getValue(generator, "name", String.class);
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        IdGeneratorBinder.addStringParameter(generator, "sequenceName", parameterMap, "sequence_name");
        boolean useNewIdentifierGenerators = metadata.getOptions().useNewIdentifierGenerators();
        String strategy = EnumConversionHelper.generationTypeToGeneratorStrategyName(GenerationType.SEQUENCE, useNewIdentifierGenerators);
        if (useNewIdentifierGenerators) {
            IdGeneratorBinder.addStringParameter(generator, "catalog", parameterMap, "catalog");
            IdGeneratorBinder.addStringParameter(generator, "schema", parameterMap, "schema");
            parameterMap.put("increment_size", String.valueOf(JandexHelper.getValue(generator, "allocationSize", Integer.class)));
            parameterMap.put("initial_value", String.valueOf(JandexHelper.getValue(generator, "initialValue", Integer.class)));
        } else {
            if (JandexHelper.getValue(generator, "initialValue", Integer.class) != 1) {
                LOG.unsupportedInitialValue("hibernate.id.new_generator_mappings");
            }
            parameterMap.put("max_lo", String.valueOf(JandexHelper.getValue(generator, "allocationSize", Integer.class) - 1));
        }
        metadata.addIdGenerator(new IdGenerator(name, strategy, parameterMap));
        LOG.tracef("Add sequence generator with name: %s", (Object)name);
    }

    private static void bindTableGenerator(MetadataImplementor metadata, AnnotationInstance generator) {
        String name = JandexHelper.getValue(generator, "name", String.class);
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        IdGeneratorBinder.addStringParameter(generator, "catalog", parameterMap, "catalog");
        IdGeneratorBinder.addStringParameter(generator, "schema", parameterMap, "schema");
        boolean useNewIdentifierGenerators = metadata.getOptions().useNewIdentifierGenerators();
        String strategy = EnumConversionHelper.generationTypeToGeneratorStrategyName(GenerationType.TABLE, useNewIdentifierGenerators);
        if (useNewIdentifierGenerators) {
            parameterMap.put("prefer_entity_table_as_segment_value", "true");
            IdGeneratorBinder.addStringParameter(generator, "table", parameterMap, "table_name");
            IdGeneratorBinder.addStringParameter(generator, "pkColumnName", parameterMap, "segment_column_name");
            IdGeneratorBinder.addStringParameter(generator, "pkColumnValue", parameterMap, "segment_value");
            IdGeneratorBinder.addStringParameter(generator, "valueColumnName", parameterMap, "value_column_name");
            parameterMap.put("increment_size", String.valueOf(JandexHelper.getValue(generator, "allocationSize", String.class)));
            parameterMap.put("initial_value", String.valueOf(JandexHelper.getValue(generator, "initialValue", String.class) + 1));
        } else {
            IdGeneratorBinder.addStringParameter(generator, "table", parameterMap, "table");
            IdGeneratorBinder.addStringParameter(generator, "pkColumnName", parameterMap, "primary_key_column");
            IdGeneratorBinder.addStringParameter(generator, "pkColumnValue", parameterMap, "primary_key_value");
            IdGeneratorBinder.addStringParameter(generator, "valueColumnName", parameterMap, "value_column");
            parameterMap.put("max_lo", String.valueOf(JandexHelper.getValue(generator, "allocationSize", Integer.class) - 1));
        }
        if (JandexHelper.getValue(generator, "uniqueConstraints", AnnotationInstance[].class).length > 0) {
            LOG.ignoringTableGeneratorConstraints(name);
        }
        metadata.addIdGenerator(new IdGenerator(name, strategy, parameterMap));
        LOG.tracef("Add table generator with name: %s", (Object)name);
    }
}

