/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.jetty8.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.ow2.jonas.lib.security.context.SecurityContext;
import org.ow2.jonas.lib.security.context.SecurityCurrent;
import org.ow2.jonas.security.auth.callback.NoInputCallbackHandler;
import org.ow2.jonas.web.jetty8.security.JettyPrincipal;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASLoginService
extends AbstractLifeCycle
implements LoginService {
    private static final String JAAS_CONFIG_NAME = "jetty";
    private Log logger = LogFactory.getLog(JOnASLoginService.class);
    private String name;
    private IdentityService identityService;
    private Map<String, UserIdentity> users = new ConcurrentHashMap<String, UserIdentity>();

    public JOnASLoginService() {
        this("JOnAS Login Service");
    }

    public JOnASLoginService(String name) {
        this.setName(name);
    }

    protected void doStart() throws Exception {
        if (this.identityService == null) {
            this.identityService = new DefaultIdentityService();
        }
        super.doStart();
    }

    public UserIdentity login(String username, Object credentials) {
        if (username == null) {
            return null;
        }
        UserIdentity userIdentity = this.getUsers().get(username);
        if (userIdentity != null) {
            this.removeUser(username);
        }
        NoInputCallbackHandler noInputCH = null;
        LoginContext loginContext = null;
        noInputCH = new NoInputCallbackHandler(username, (String)credentials, null);
        try {
            loginContext = new LoginContext(JAAS_CONFIG_NAME, (CallbackHandler)noInputCH);
        }
        catch (LoginException e) {
            this.logger.error((Object)"Cannot create a login context for the user ''{0}''", new Object[]{username, e});
            return null;
        }
        Subject subject = null;
        try {
            loginContext.login();
            subject = loginContext.getSubject();
            if (subject == null) {
                this.logger.error((Object)"No Subject for user ''{0}''", new Object[]{username});
                return null;
            }
        }
        catch (AccountExpiredException e) {
            this.logger.error((Object)"Account expired for user ''{0}''", new Object[]{username, e});
            return null;
        }
        catch (CredentialExpiredException e) {
            this.logger.error((Object)"Credential Expired for user ''{0}''", new Object[]{username, e});
            return null;
        }
        catch (FailedLoginException e) {
            this.logger.error((Object)"Failed Login exception for user ''{0}''", new Object[]{username, e});
            return null;
        }
        catch (LoginException e) {
            this.logger.error((Object)"Login exception for user ''{0}''", new Object[]{username, e});
            return null;
        }
        Iterator<Principal> iterator = subject.getPrincipals(Principal.class).iterator();
        String userName = null;
        while (iterator.hasNext() && userName == null) {
            Principal principal = iterator.next();
            if (principal instanceof Group) continue;
            userName = principal.getName();
        }
        if (userName == null) {
            this.logger.error((Object)"No Username found in the subject", new Object[0]);
            return null;
        }
        Set<Group> groups = subject.getPrincipals(Group.class);
        ArrayList<String> roles = new ArrayList<String>();
        for (Group group : groups) {
            Enumeration e = group.members();
            while (e.hasMoreElements()) {
                Principal p = (Principal)e.nextElement();
                roles.add(p.getName());
            }
        }
        JettyPrincipal principal = new JettyPrincipal(userName, roles);
        SecurityContext ctx = new SecurityContext(userName, roles);
        SecurityCurrent current = SecurityCurrent.getCurrent();
        current.setSecurityContext(ctx);
        UserIdentity identity = this.identityService.newUserIdentity(subject, (Principal)principal, roles.toArray(new String[roles.size()]));
        this.addUser(username, identity);
        return identity;
    }

    public boolean validate(UserIdentity user) {
        return true;
    }

    protected Map<String, UserIdentity> getUsers() {
        return this.users;
    }

    protected void addUser(String username, UserIdentity userIdentity) {
        this.users.put(username, userIdentity);
    }

    protected void removeUser(String username) {
        this.users.remove(username);
    }

    public void logout(UserIdentity user) {
        SecurityCurrent.getCurrent().setSecurityContext(new SecurityContext());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }
}

