/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.ejbjar.impl.xml.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.Remove;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import javax.persistence.PersistenceContextType;
import org.ow2.util.asm.Type;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.metadata.common.api.ICommonFieldMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonMethodMetadata;
import org.ow2.util.ee.metadata.common.api.interfaces.ISharedMetadata;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJEjbEJB;
import org.ow2.util.ee.metadata.common.api.struct.IJInterceptors;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceContext;
import org.ow2.util.ee.metadata.common.api.struct.IJavaxPersistenceUnit;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.ee.metadata.common.api.struct.IJwsHandlerChain;
import org.ow2.util.ee.metadata.common.api.xml.struct.IActivationConfig;
import org.ow2.util.ee.metadata.common.api.xml.struct.IAroundInvoke;
import org.ow2.util.ee.metadata.common.api.xml.struct.ICommonEJBRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEJBLocalRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEJBRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEnvEntry;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEnvironment;
import org.ow2.util.ee.metadata.common.api.xml.struct.IInjectionTarget;
import org.ow2.util.ee.metadata.common.api.xml.struct.ILifeCycleCallback;
import org.ow2.util.ee.metadata.common.api.xml.struct.IMessageDestinationRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IMethodDD;
import org.ow2.util.ee.metadata.common.api.xml.struct.IPersistenceContextRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IPersistenceUnitRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IResourceEnvRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IResourceRef;
import org.ow2.util.ee.metadata.common.api.xml.struct.IServiceRef;
import org.ow2.util.ee.metadata.common.impl.CommonFieldMetadata;
import org.ow2.util.ee.metadata.common.impl.CommonMethodMetadata;
import org.ow2.util.ee.metadata.common.impl.struct.EnvEntry;
import org.ow2.util.ee.metadata.common.impl.struct.JAnnotationResource;
import org.ow2.util.ee.metadata.common.impl.struct.JEjbEJB;
import org.ow2.util.ee.metadata.common.impl.struct.JInterceptors;
import org.ow2.util.ee.metadata.common.impl.struct.JavaxPersistenceContext;
import org.ow2.util.ee.metadata.common.impl.struct.JavaxPersistenceUnit;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ActivationConfig;
import org.ow2.util.ee.metadata.ejbjar.api.ClassType;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarClassMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarDeployableMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarFieldMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarMethodMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.TransactionAttributeLevel;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IApplicationException;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJCommonBean;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJLocal;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJMessageDriven;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJRemote;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IAssemblyDescriptor;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IBean;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IContainerTransaction;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IEJB3;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IEnterpriseBeans;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IInterceptor;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IInterceptorBinding;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IInterceptors;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IMessageDriven;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IMethodPermission;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IRemoveMethod;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.ISession;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JActivationConfigProperty;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JCommonBean;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JLocal;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JMessageDriven;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JRemote;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JRemove;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.helper.CommonMetadataMerge;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EjbJarMetadataMerge<E extends EJBDeployable<E>, D extends IEjbJarDeployableMetadata<E, D, C, M, F>, C extends IEjbJarClassMetadata<E, D, C, M, F>, M extends IEjbJarMethodMetadata<E, D, C, M, F>, F extends IEjbJarFieldMetadata<E, D, C, M, F>>
extends CommonMetadataMerge<E, D, C, M, F> {
    private static final String WILDCARD = "*";
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static Log logger = LogFactory.getLog(EjbJarMetadataMerge.class);

    private EjbJarMetadataMerge(D ejbMetadata) {
        super(ejbMetadata);
    }

    public static <E extends EJBDeployable<E>, D extends IEjbJarDeployableMetadata<E, D, C, M, F>, C extends IEjbJarClassMetadata<E, D, C, M, F>, M extends IEjbJarMethodMetadata<E, D, C, M, F>, F extends IEjbJarFieldMetadata<E, D, C, M, F>> void merge(D ejbMetadata) {
        super.resolve();
    }

    private void resolve() {
        String ejbClass;
        String ejbName;
        String ejbClass2;
        String ejbName2;
        List sessionList;
        IEnterpriseBeans enterpriseBeans;
        IEJB3 ejb3 = this.getEjbJarDeployableMetadata().getEjb3();
        HashMap<String, String> ejbNameClasses = new HashMap<String, String>();
        if (ejb3 != null && (enterpriseBeans = ejb3.getEnterpriseBeans()) != null) {
            sessionList = enterpriseBeans.getSessionList();
            for (ISession session : sessionList) {
                ejbName2 = session.getEjbName();
                ejbClass2 = session.getEjbClass();
                if (ejbName2 == null || "".equals(ejbName2) || ejbClass2 == null || "".equals(ejbClass2)) continue;
                ejbNameClasses.put(ejbName2, ejbClass2);
            }
            List mdbList = enterpriseBeans.getMessageDrivenList();
            for (IMessageDriven mdb : mdbList) {
                ejbName = mdb.getEjbName();
                ejbClass = mdb.getEjbClass();
                if (ejbName == null || "".equals(ejbName) || ejbClass == null || "".equals(ejbClass)) continue;
                ejbNameClasses.put(ejbName, ejbClass);
            }
        }
        for (IEjbJarClassMetadata classMetadata : this.getEjbJarDeployableMetadata().getEjbJarClassMetadataCollection()) {
            if (!classMetadata.isBean()) continue;
            String ejbName3 = classMetadata.getJCommonBean().getName();
            String ejbClass3 = classMetadata.getClassName();
            String existingEjbClassForEJBName = (String)ejbNameClasses.get(ejbName3);
            if (existingEjbClassForEJBName != null && !ejbClass3.equals(existingEjbClassForEJBName)) continue;
            this.getEjbJarDeployableMetadata().getBeanEjbJarClassMetadataForEjbName(ejbName3, ejbClass3);
        }
        if (ejb3 != null) {
            IAssemblyDescriptor assemblyDescriptor;
            IInterceptors interceptors;
            enterpriseBeans = ejb3.getEnterpriseBeans();
            if (enterpriseBeans != null) {
                sessionList = enterpriseBeans.getSessionList();
                for (ISession session : sessionList) {
                    ejbName2 = session.getEjbName();
                    ejbClass2 = session.getEjbClass();
                    IEjbJarClassMetadata classAnnotationMetadata = this.getEjbJarDeployableMetadata().getBeanEjbJarClassMetadataForEjbName(ejbName2, ejbClass2);
                    this.applySessionBean(session, classAnnotationMetadata);
                }
                List messageDrivenList = enterpriseBeans.getMessageDrivenList();
                for (IMessageDriven messageDriven : messageDrivenList) {
                    ejbName = messageDriven.getEjbName();
                    ejbClass = messageDriven.getEjbClass();
                    IEjbJarClassMetadata classAnnotationMetadata = this.getEjbJarDeployableMetadata().getBeanEjbJarClassMetadataForEjbName(ejbName, ejbClass);
                    this.applyMessageDrivenBean(messageDriven, classAnnotationMetadata);
                }
            }
            if ((interceptors = ejb3.getInterceptors()) != null) {
                this.applyInterceptors(interceptors);
            }
            if ((assemblyDescriptor = ejb3.getAssemblyDescriptor()) != null) {
                this.mergeApplicationException(assemblyDescriptor);
                this.mergeInterceptorBinding(assemblyDescriptor);
                this.mergeContainerTransaction(assemblyDescriptor);
                this.mergeAssemblySecurity(assemblyDescriptor);
            }
        }
    }

    private void applyInterceptors(IInterceptors interceptors) {
        List interceptorList = interceptors.getInterceptorList();
        if (interceptorList != null) {
            for (IInterceptor interceptor : interceptorList) {
                String itCptClass = interceptor.getInterceptorClass();
                if (itCptClass == null) {
                    throw new IllegalStateException("Invalid interceptor with name '" + interceptor + "': No interceptor-class");
                }
                IEjbJarClassMetadata itcpMetadata = this.getEjbJarDeployableMetadata().getScannedClassMetadata(EjbJarMetadataMerge.encode((String)itCptClass));
                if (itcpMetadata == null) {
                    throw new IllegalStateException("No metadata found for class '" + itCptClass + "'.");
                }
                this.applyJndiEnvironmentRefsGroup((IEnvironment)interceptor, itcpMetadata);
            }
        }
    }

    private void applySessionBean(ISession sessionbean, C classAnnotationMetadata) {
        String encodedItf;
        String localHome;
        this.applyCommonBean((IBean)sessionbean, classAnnotationMetadata);
        String sessionType = sessionbean.getSessionType();
        if (sessionType == null && !classAnnotationMetadata.isSession()) {
            throw new IllegalStateException("Missing session-type for bean '" + sessionbean + "' and no annotation in '" + classAnnotationMetadata + "'.");
        }
        if ("Stateless".equals(sessionType)) {
            classAnnotationMetadata.setClassType(ClassType.STATELESS);
        } else if ("Stateful".equals(sessionType)) {
            classAnnotationMetadata.setClassType(ClassType.STATEFUL);
        } else if ("Singleton".equals(sessionType)) {
            classAnnotationMetadata.setClassType(ClassType.SINGLETON);
        }
        String remoteHome = sessionbean.getRemoteHome();
        if (remoteHome != null) {
            classAnnotationMetadata.setRemoteHome(remoteHome);
        }
        if ((localHome = sessionbean.getLocalHome()) != null) {
            classAnnotationMetadata.setLocalHome(localHome);
        }
        if (sessionbean.getBusinessLocalList().size() > 0) {
            IJLocal jLocal = classAnnotationMetadata.getLocalInterfaces();
            if (jLocal == null) {
                jLocal = new JLocal();
                classAnnotationMetadata.setLocalInterfaces(jLocal);
            }
            for (String itf : sessionbean.getBusinessLocalList()) {
                encodedItf = EjbJarMetadataMerge.encode((String)itf);
                if (jLocal.contains(encodedItf)) continue;
                jLocal.addInterface(encodedItf);
            }
        }
        if (sessionbean.getMappedName() != null) {
            IJCommonBean jCommonBean = classAnnotationMetadata.getJCommonBean();
            if (jCommonBean == null) {
                throw new IllegalStateException("No JCommonBean attribute on class '" + classAnnotationMetadata.getClassName() + "' while there is a mapped name.");
            }
            jCommonBean.setMappedName(sessionbean.getMappedName());
        }
        if (sessionbean.getBusinessRemoteList().size() > 0) {
            IJRemote jRemote = classAnnotationMetadata.getRemoteInterfaces();
            if (jRemote == null) {
                jRemote = new JRemote();
                classAnnotationMetadata.setRemoteInterfaces(jRemote);
            }
            for (String itf : sessionbean.getBusinessRemoteList()) {
                encodedItf = EjbJarMetadataMerge.encode((String)itf);
                if (jRemote.contains(encodedItf)) continue;
                jRemote.addInterface(encodedItf);
            }
        }
        if (sessionbean.getRemoveMethodList().size() > 0) {
            if (!classAnnotationMetadata.isStateful()) {
                throw new IllegalStateException("Cannot apply XML DD remove methods on a bean which is not a stateful bean. Bean class is '" + classAnnotationMetadata.getClassName() + "'. Remove Methods are '" + sessionbean.getRemoveMethodList() + "'.");
            }
            for (IRemoveMethod removeMethod : sessionbean.getRemoveMethodList()) {
                IMethodDD method = removeMethod.getMethod();
                List<M> methods = this.getMethodsForGivenMethodDD(method, classAnnotationMetadata);
                if (methods.size() == 0) {
                    logger.warn((Object)"No method found for the remove-method ''{0}'' on the class ''{1}''", new Object[]{method, classAnnotationMetadata.getClassName()});
                } else if (methods.size() > 1) {
                    logger.warn((Object)"Found more than 1 method for the remove-method ''{0}'' on the class ''{1}''.All these methods will be set as remove methods.", new Object[]{method, classAnnotationMetadata.getClassName()});
                }
                for (IEjbJarMethodMetadata methodAnnotationMetadata : methods) {
                    Remove previousRemove = methodAnnotationMetadata.getJRemove();
                    Boolean retainXML = removeMethod.getRetainIfException();
                    boolean retain = false;
                    if (retainXML != null) {
                        retain = retainXML;
                    } else if (previousRemove != null) {
                        retain = previousRemove.retainIfException();
                    }
                    JRemove jRemove = new JRemove(retain);
                    methodAnnotationMetadata.setRemove((Remove)jRemove);
                }
            }
        }
    }

    private void applyMessageDrivenBean(IMessageDriven messageDrivenBean, C classAnnotationMetadata) {
        String existingInterface;
        String messagingType;
        this.applyCommonBean((IBean)messageDrivenBean, classAnnotationMetadata);
        if (messageDrivenBean.getMessageDestinationType() != null) {
            ActivationConfig activationConfig = new ActivationConfig();
            messageDrivenBean.addActivationConfig((IActivationConfig)activationConfig);
            activationConfig.setName("destinationType");
            activationConfig.setValue(messageDrivenBean.getMessageDestinationType());
        }
        classAnnotationMetadata.setClassType(ClassType.MDB);
        IJMessageDriven jMessageDriven = classAnnotationMetadata.getJMessageDriven();
        if (jMessageDriven == null) {
            jMessageDriven = new JMessageDriven();
            classAnnotationMetadata.setJMessageDriven(jMessageDriven);
        }
        if ((messagingType = messageDrivenBean.getMessagingType()) != null && (existingInterface = jMessageDriven.getMessageListenerInterface()) == null) {
            jMessageDriven.setMessageListenerInterface(messagingType);
        }
        List activationConfigList = messageDrivenBean.getActivationConfigList();
        for (IActivationConfig activationConfig : activationConfigList) {
            JActivationConfigProperty actProperty = new JActivationConfigProperty(activationConfig.getName(), activationConfig.getValue());
            jMessageDriven.addActivationConfigProperty((ActivationConfigProperty)actProperty);
        }
        jMessageDriven.setMessageDestinationLink(messageDrivenBean.getMessageDestinationLink());
    }

    private void applyCommonBean(IBean bean, C classAnnotationMetadata) {
        String runAsRole;
        if (classAnnotationMetadata.getJCommonBean() == null) {
            classAnnotationMetadata.setJCommonBean((IJCommonBean)new JCommonBean());
        }
        IJCommonBean jCommonBean = classAnnotationMetadata.getJCommonBean();
        jCommonBean.setName(bean.getEjbName());
        if (bean.getMappedName() != null) {
            jCommonBean.setMappedName(bean.getMappedName());
        }
        if ((runAsRole = bean.getRunAsRole()) != null) {
            classAnnotationMetadata.setRunAs(runAsRole);
        }
        classAnnotationMetadata.setSecurityRoleRefList(bean.getSecurityRoleRefList());
        String transactionType = bean.getTransactionType();
        if (transactionType != null) {
            if ("Bean".equals(transactionType)) {
                classAnnotationMetadata.setTransactionManagementType(TransactionManagementType.BEAN);
            } else if ("Container".equals(transactionType)) {
                classAnnotationMetadata.setTransactionManagementType(TransactionManagementType.CONTAINER);
            } else {
                throw new IllegalStateException("Invalid transaction type '" + transactionType + "' found");
            }
        }
        this.applyJndiEnvironmentRefsGroup((IEnvironment)bean, classAnnotationMetadata);
    }

    protected void applyJndiEnvironmentRefsGroup(IEnvironment envGroup, C classAnnotationMetadata) {
        this.applyLifeCycle(envGroup.getPostConstructCallbackList(), classAnnotationMetadata, "post-construct");
        this.applyLifeCycle(envGroup.getPreDestroyCallbackList(), classAnnotationMetadata, "pre-destroy");
        this.applyLifeCycle(envGroup.getPrePassivateCallbackList(), classAnnotationMetadata, "pre-passivate");
        this.applyLifeCycle(envGroup.getPostActivateCallbackList(), classAnnotationMetadata, "post-activate");
        this.applyAroundInvoke(envGroup.getAroundInvokeList(), classAnnotationMetadata, "around-invoke");
        this.applyEjbRef(envGroup.getEJBRefList(), classAnnotationMetadata);
        this.applyEjbLocalRef(envGroup.getEJBLocalRefList(), classAnnotationMetadata);
        this.applyResourceRef(envGroup.getResourceRefList(), classAnnotationMetadata);
        this.applyResourceEnvRef(envGroup.getResourceEnvRefList(), classAnnotationMetadata);
        this.applyEnvEntry(envGroup.getEnvEntryList(), classAnnotationMetadata);
        this.applyPersistenceUnitRef(envGroup.getPersistenceUnitRefList(), classAnnotationMetadata);
        this.applyPersistenceContextRef(envGroup.getPersistenceContextRefList(), classAnnotationMetadata);
        this.applyMessageDestinationRef(envGroup.getMessageDestinationRefList(), classAnnotationMetadata);
        this.applyServiceRef(envGroup.getServiceRefList(), classAnnotationMetadata);
        this.applyHandlerChain(classAnnotationMetadata);
    }

    protected void applyEnvEntry(List<IEnvEntry> envEntryList, C classAnnotationMetadata) {
        if (envEntryList == null) {
            return;
        }
        ArrayList<EnvEntry> structEnvEntryList = new ArrayList<EnvEntry>();
        for (IEnvEntry envEntry : envEntryList) {
            EnvEntry builtEntry = new EnvEntry(envEntry.getEnvEntryName(), envEntry.getEnvEntryType(), envEntry.getEnvEntryValue(), envEntry.getLookupName());
            structEnvEntryList.add(builtEntry);
            List injectionTargetList = envEntry.getInjectionTargetList();
            if (injectionTargetList == null) continue;
            for (IInjectionTarget injectionTarget : injectionTargetList) {
                ISharedMetadata sharedMetadata = this.getInjectionTarget(classAnnotationMetadata, injectionTarget);
                if (builtEntry.getType() == null) {
                    builtEntry.setType(this.getEnvEntryType(sharedMetadata));
                }
                if (envEntry.getEnvEntryValue() == null && envEntry.getLookupName() == null) continue;
                JAnnotationResource jResource = new JAnnotationResource();
                jResource.setName(envEntry.getEnvEntryName());
                jResource.setType(envEntry.getEnvEntryType());
                jResource.setLookup(envEntry.getLookupName());
                sharedMetadata.setJAnnotationResource((IJAnnotationResource)jResource);
            }
        }
        classAnnotationMetadata.setEnvEntryCollection(structEnvEntryList);
    }

    protected void applyServiceRef(List<IServiceRef> serviceRefList, C classAnnotationMetadata) {
        if (serviceRefList == null) {
            return;
        }
        for (IServiceRef serviceRef : serviceRefList) {
            List injectionTargetList = serviceRef.getInjectionTargetList();
            if (injectionTargetList != null && injectionTargetList.size() > 0) {
                for (IInjectionTarget target : injectionTargetList) {
                    ISharedMetadata sharedMetadata = this.getInjectionTarget(classAnnotationMetadata, target);
                    IJaxwsWebServiceRef wsr = sharedMetadata.getJaxwsWebServiceRef();
                    if (wsr != null) {
                        this.mergeWebServiceRef(serviceRef, wsr);
                        continue;
                    }
                    sharedMetadata.setJaxwsWebServiceRef(this.createJaxwsWebServiceRefFromXML(serviceRef));
                }
                continue;
            }
            String name = serviceRef.getName();
            List<IJaxwsWebServiceRef> metadatas = this.findJaxwsWebServiceRefMetadata(classAnnotationMetadata, name);
            if (metadatas.isEmpty()) {
                IJaxwsWebServiceRef existing = classAnnotationMetadata.getJaxwsWebServiceRef();
                ArrayList<IJaxwsWebServiceRef> webServiceRefs = classAnnotationMetadata.getJaxwsWebServiceRefs();
                if (webServiceRefs == null) {
                    webServiceRefs = new ArrayList<IJaxwsWebServiceRef>();
                    classAnnotationMetadata.setJaxwsWebServiceRefs(webServiceRefs);
                }
                if (existing != null) {
                    webServiceRefs.add(existing);
                    classAnnotationMetadata.setJaxwsWebServiceRef(null);
                }
                webServiceRefs.add(this.createJaxwsWebServiceRefFromXML(serviceRef));
                continue;
            }
            if (metadatas.size() > 1) {
                throw new IllegalStateException("Too many matching WebServiceRef metadata for '" + name + "' service-ref of class '" + classAnnotationMetadata.getClassName() + "'");
            }
            this.mergeWebServiceRef(serviceRef, metadatas.get(0));
        }
    }

    private List<IJaxwsWebServiceRef> findJaxwsWebServiceRefMetadata(C classAnnotationMetadata, String name) {
        Collection methodMetadatas;
        Collection fieldMetadatas;
        List webServiceRefs;
        ArrayList<IJaxwsWebServiceRef> elements = new ArrayList<IJaxwsWebServiceRef>();
        IJaxwsWebServiceRef classAnnotation = classAnnotationMetadata.getJaxwsWebServiceRef();
        if (classAnnotation != null && name.equals(classAnnotation.getName())) {
            elements.add(classAnnotation);
        }
        if ((webServiceRefs = classAnnotationMetadata.getJaxwsWebServiceRefs()) != null) {
            for (IJaxwsWebServiceRef ref : webServiceRefs) {
                if (!name.equals(ref.getName())) continue;
                elements.add(ref);
            }
        }
        if ((fieldMetadatas = classAnnotationMetadata.getStandardFieldMetadataCollection()) != null) {
            for (IEjbJarFieldMetadata fieldMetadata : fieldMetadatas) {
                this.addJaxwsWebServiceRefIfFound((ISharedMetadata)fieldMetadata, name, elements);
            }
        }
        if ((methodMetadatas = classAnnotationMetadata.getStandardMethodMetadataCollection()) != null) {
            for (IEjbJarMethodMetadata methodMetadata : methodMetadatas) {
                this.addJaxwsWebServiceRefIfFound((ISharedMetadata)methodMetadata, name, elements);
            }
        }
        return elements;
    }

    private void applyMessageDestinationRef(List<IMessageDestinationRef> messageDestinationRefList, C classAnnotationMetadata) {
        if (messageDestinationRefList == null) {
            return;
        }
        for (IMessageDestinationRef messageDestinationRef : messageDestinationRefList) {
            JAnnotationResource jResource = new JAnnotationResource();
            jResource.setName(messageDestinationRef.getName());
            jResource.setType(messageDestinationRef.getType());
            jResource.setMappedName(messageDestinationRef.getMappedName());
            if (messageDestinationRef.getLookupName() != null) {
                jResource.setLookup(messageDestinationRef.getLookupName());
            }
            jResource.setMessageDestinationLink(messageDestinationRef.getLink());
            this.applyJResource(jResource, classAnnotationMetadata, messageDestinationRef.getInjectionTargetList());
        }
    }

    private void applyResourceRef(List<IResourceRef> resourceRefList, C classAnnotationMetadata) {
        if (resourceRefList == null) {
            return;
        }
        for (IResourceRef resourceRef : resourceRefList) {
            JAnnotationResource jResource = new JAnnotationResource();
            jResource.setName(resourceRef.getResRefName());
            jResource.setType(resourceRef.getResRefType());
            jResource.setMappedName(resourceRef.getMappedName());
            if (resourceRef.getLookupName() != null) {
                jResource.setLookup(resourceRef.getLookupName());
            }
            this.applyJResource(jResource, classAnnotationMetadata, resourceRef.getInjectionTargetList());
        }
    }

    private void applyResourceEnvRef(List<IResourceEnvRef> resourceEnvRefList, C classAnnotationMetadata) {
        if (resourceEnvRefList == null) {
            return;
        }
        for (IResourceEnvRef resourceEnvRef : resourceEnvRefList) {
            JAnnotationResource jResource = new JAnnotationResource();
            jResource.setName(resourceEnvRef.getResourceEnvRefName());
            jResource.setType(resourceEnvRef.getResourceEnvRefType());
            jResource.setMappedName(resourceEnvRef.getMappedName());
            if (resourceEnvRef.getLookupName() != null) {
                jResource.setLookup(resourceEnvRef.getLookupName());
            }
            this.applyJResource(jResource, classAnnotationMetadata, resourceEnvRef.getInjectionTargetList());
        }
    }

    private void applyPersistenceUnitRef(List<IPersistenceUnitRef> persistenceUnitRefList, C classAnnotationMetadata) {
        if (persistenceUnitRefList == null) {
            return;
        }
        for (IPersistenceUnitRef persistenceUnitRef : persistenceUnitRefList) {
            JavaxPersistenceUnit jPersistenceUnit = new JavaxPersistenceUnit();
            jPersistenceUnit.setName(persistenceUnitRef.getPersistenceUnitRefName());
            jPersistenceUnit.setUnitName(persistenceUnitRef.getPersistenceUnitName());
            this.applyJPersistenceUnit(jPersistenceUnit, classAnnotationMetadata, persistenceUnitRef.getInjectionTargetList());
        }
    }

    private void applyPersistenceContextRef(List<IPersistenceContextRef> persistenceContextRefList, C classAnnotationMetadata) {
        if (persistenceContextRefList == null) {
            return;
        }
        for (IPersistenceContextRef persistenceContextRef : persistenceContextRefList) {
            JavaxPersistenceContext jPersistenceContext = new JavaxPersistenceContext();
            jPersistenceContext.setName(persistenceContextRef.getPersistenceContextRefName());
            jPersistenceContext.setUnitName(persistenceContextRef.getPersistenceUnitName());
            String type = persistenceContextRef.getPersistenceUnitName();
            if (PersistenceContextType.TRANSACTION.toString().equals(type)) {
                jPersistenceContext.setType(PersistenceContextType.TRANSACTION);
            } else if (PersistenceContextType.EXTENDED.toString().equals(type)) {
                jPersistenceContext.setType(PersistenceContextType.EXTENDED);
            }
            this.applyJPersistenceContext(jPersistenceContext, classAnnotationMetadata, persistenceContextRef.getInjectionTargetList());
        }
    }

    protected void applyJPersistenceUnit(JavaxPersistenceUnit jPersistenceUnit, C classAnnotationMetadata, List<IInjectionTarget> injectionTargetList) {
        IJavaxPersistenceUnit existingJPersistentUnit = classAnnotationMetadata.getJavaxPersistenceUnit();
        ArrayList<Object> jPersistentUnits = classAnnotationMetadata.getJavaxPersistencePersistenceUnits();
        if (jPersistentUnits == null) {
            jPersistentUnits = new ArrayList<Object>();
            classAnnotationMetadata.setJavaxPersistencePersistenceUnits(jPersistentUnits);
        }
        if (existingJPersistentUnit != null) {
            jPersistentUnits.add(existingJPersistentUnit);
            classAnnotationMetadata.setJavaxPersistenceUnit(null);
        }
        jPersistentUnits.add(jPersistenceUnit);
        if (injectionTargetList != null) {
            for (IInjectionTarget injectionTarget : injectionTargetList) {
                this.getInjectionTarget(classAnnotationMetadata, injectionTarget).setJavaxPersistenceUnit((IJavaxPersistenceUnit)jPersistenceUnit);
            }
        }
    }

    protected void applyJPersistenceContext(JavaxPersistenceContext jPersistenceContext, C classAnnotationMetadata, List<IInjectionTarget> injectionTargetList) {
        IJavaxPersistenceContext existingJPersistentContext = classAnnotationMetadata.getJavaxPersistenceContext();
        ArrayList<Object> jPersistentContexts = classAnnotationMetadata.getJavaxPersistencePersistenceContexts();
        if (jPersistentContexts == null) {
            jPersistentContexts = new ArrayList<Object>();
            classAnnotationMetadata.setJavaxPersistencePersistenceContexts(jPersistentContexts);
        }
        if (existingJPersistentContext != null) {
            jPersistentContexts.add(existingJPersistentContext);
            classAnnotationMetadata.setJavaxPersistenceContext(null);
        }
        jPersistentContexts.add(jPersistenceContext);
        if (injectionTargetList != null) {
            for (IInjectionTarget injectionTarget : injectionTargetList) {
                this.getInjectionTarget(classAnnotationMetadata, injectionTarget).setJavaxPersistenceContext((IJavaxPersistenceContext)jPersistenceContext);
            }
        }
    }

    private void applyEjbRef(List<IEJBRef> ejbRefList, C classAnnotationMetadata) {
        if (ejbRefList == null) {
            return;
        }
        for (IEJBRef ejbRef : ejbRefList) {
            JEjbEJB jEJB = EjbJarMetadataMerge.buildEJB((ICommonEJBRef)ejbRef);
            if (ejbRef.getHome() != null) {
                jEJB.setBeanInterface(ejbRef.getHome());
            } else if (ejbRef.getRemote() != null) {
                jEJB.setBeanInterface(ejbRef.getRemote());
            }
            this.applyJEJB(jEJB, classAnnotationMetadata, ejbRef.getInjectionTargetList());
        }
    }

    private void applyEjbLocalRef(List<IEJBLocalRef> ejbLocalRefList, C classAnnotationMetadata) {
        if (ejbLocalRefList == null) {
            return;
        }
        for (IEJBLocalRef ejbLocalRef : ejbLocalRefList) {
            JEjbEJB jEJB = EjbJarMetadataMerge.buildEJB((ICommonEJBRef)ejbLocalRef);
            if (ejbLocalRef.getLocalHome() != null) {
                jEJB.setBeanInterface(ejbLocalRef.getLocalHome());
            } else if (ejbLocalRef.getLocal() != null) {
                jEJB.setBeanInterface(ejbLocalRef.getLocal());
            }
            this.applyJEJB(jEJB, classAnnotationMetadata, ejbLocalRef.getInjectionTargetList());
        }
    }

    protected void applyJResource(JAnnotationResource jResource, C classAnnotationMetadata, List<IInjectionTarget> injectionTargetList) {
        IJAnnotationResource existingJResource = classAnnotationMetadata.getJAnnotationResource();
        ArrayList<IJAnnotationResource> jResources = classAnnotationMetadata.getJAnnotationResources();
        if (jResources == null) {
            jResources = new ArrayList<IJAnnotationResource>();
            classAnnotationMetadata.setJAnnotationResources(jResources);
        }
        if (existingJResource != null) {
            jResources.add(existingJResource);
            classAnnotationMetadata.setJAnnotationResource(null);
        }
        JAnnotationResource resourceToUse = null;
        for (IJAnnotationResource currentResource : jResources) {
            if (!jResource.getName().equals(currentResource.getName())) continue;
            resourceToUse = currentResource;
        }
        if (resourceToUse != null) {
            if (jResource.getMappedName() != null && !"".equals(jResource.getMappedName())) {
                resourceToUse.setMappedName(jResource.getMappedName());
            }
        } else {
            jResources.add((IJAnnotationResource)jResource);
            resourceToUse = jResource;
        }
        if (injectionTargetList != null) {
            for (IInjectionTarget injectionTarget : injectionTargetList) {
                this.getInjectionTarget(classAnnotationMetadata, injectionTarget).setJAnnotationResource((IJAnnotationResource)resourceToUse);
            }
        }
    }

    protected ISharedMetadata getInjectionTarget(C classAnnotationMetadata, IInjectionTarget injectionTarget) {
        String injectionTargetName = injectionTarget.getTargetName();
        M method = this.getMethod(classAnnotationMetadata, injectionTarget);
        if (method != null) {
            return method;
        }
        F field = this.getField(classAnnotationMetadata, injectionTarget);
        if (field == null) {
            throw new IllegalArgumentException("No method or field for injection target name '" + injectionTargetName + "' found in the class '" + classAnnotationMetadata.getClassName() + "'.");
        }
        return field;
    }

    protected M getMethod(C classAnnotationMetadata, IInjectionTarget injectionTarget) {
        String clName = injectionTarget.getClassname();
        clName = clName == null ? classAnnotationMetadata.getClassName() : clName.replace(".", "/");
        String methodName = injectionTarget.getTargetName();
        IEjbJarClassMetadata foundClassMetadata = classAnnotationMetadata.getLinkedClassMetadata(clName);
        if (foundClassMetadata == null) {
            throw new IllegalArgumentException("Cannot find the class metadata named '" + clName + "'.");
        }
        List methods = foundClassMetadata.searchStandardMethodMetadata(methodName);
        if (methods.size() == 0) {
            return null;
        }
        if (methods.size() > 1) {
            throw new IllegalArgumentException("Too many methods with name '" + methodName + "' found in the class '" + clName + "'.");
        }
        return (M)((IEjbJarMethodMetadata)methods.get(0));
    }

    protected F getField(C classAnnotationMetadata, IInjectionTarget injectionTarget) {
        String clName = injectionTarget.getClassname();
        clName = clName == null ? classAnnotationMetadata.getClassName() : clName.replace(".", "/");
        String fieldName = injectionTarget.getTargetName();
        IEjbJarClassMetadata foundClassMetadata = classAnnotationMetadata.getLinkedClassMetadata(clName);
        if (foundClassMetadata == null) {
            throw new IllegalArgumentException("Cannot find the class metadata named '" + clName + "'.");
        }
        List fields = foundClassMetadata.searchStandardFieldMetadata(fieldName);
        if (fields.size() == 0) {
            return null;
        }
        if (fields.size() > 1) {
            throw new IllegalArgumentException("Too many fields with name '" + fieldName + "' found in the class '" + clName + "'.");
        }
        return (F)((IEjbJarFieldMetadata)fields.get(0));
    }

    private String getEnvEntryType(ISharedMetadata commonMetadata) {
        if (commonMetadata == null) {
            throw new IllegalArgumentException("Null is not a valid metadata");
        }
        if (commonMetadata instanceof CommonFieldMetadata) {
            CommonFieldMetadata fieldAnnotationMetadata = (CommonFieldMetadata)commonMetadata;
            Type typeInterface = Type.getType(fieldAnnotationMetadata.getJField().getDescriptor());
            return this.envEntryTypeConvert(typeInterface.getClassName());
        }
        if (commonMetadata instanceof CommonMethodMetadata) {
            CommonMethodMetadata methodAnnotationMetadata = (CommonMethodMetadata)commonMetadata;
            JMethod jMethod = methodAnnotationMetadata.getJMethod();
            Type[] args = Type.getArgumentTypes(jMethod.getDescriptor());
            if (args.length != 1) {
                throw new IllegalArgumentException("Method args '" + Arrays.asList(args) + "' for method '" + jMethod + "' are invalid. Length should be of 1.");
            }
            Type typeInterface = args[0];
            return this.envEntryTypeConvert(typeInterface.getClassName());
        }
        throw new IllegalArgumentException("Unknown metadata type '" + commonMetadata + "'");
    }

    protected String envEntryTypeConvert(String className) {
        if (Boolean.TYPE.toString().equals(className)) {
            return Boolean.class.getName();
        }
        if (Byte.TYPE.toString().equals(className)) {
            return Byte.class.getName();
        }
        if (Character.TYPE.toString().equals(className)) {
            return Character.class.getName();
        }
        if (Short.TYPE.toString().equals(className)) {
            return Short.class.getName();
        }
        if (Integer.TYPE.toString().equals(className)) {
            return Integer.class.getName();
        }
        if (Long.TYPE.toString().equals(className)) {
            return Long.class.getName();
        }
        if (Float.TYPE.toString().equals(className)) {
            return Float.class.getName();
        }
        if (Double.TYPE.toString().equals(className)) {
            return Double.class.getName();
        }
        if (String.class.getName().equals(className)) {
            return String.class.getName();
        }
        if (Class.class.getName().equals(className)) {
            return Class.class.getName();
        }
        return className;
    }

    protected void applyJEJB(JEjbEJB jEJB, C classAnnotationMetadata, List<IInjectionTarget> injectionTargetList) {
        IJEjbEJB existingJEjbEJB = classAnnotationMetadata.getJEjbEJB();
        ArrayList<Object> jEjbEJBs = classAnnotationMetadata.getJEjbEJBs();
        if (jEjbEJBs == null) {
            jEjbEJBs = new ArrayList<Object>();
            classAnnotationMetadata.setJEjbEJBs(jEjbEJBs);
        }
        if (existingJEjbEJB != null) {
            jEjbEJBs.add(existingJEjbEJB);
            classAnnotationMetadata.setJEjbEJB(null);
        }
        jEjbEJBs.add(jEJB);
        if (injectionTargetList != null) {
            for (IInjectionTarget injectionTarget : injectionTargetList) {
                this.getInjectionTarget(classAnnotationMetadata, injectionTarget).setJEjbEJB((IJEjbEJB)jEJB);
            }
        }
    }

    private static JEjbEJB buildEJB(ICommonEJBRef ref) {
        JEjbEJB jEJB = new JEjbEJB();
        if (ref.getEjbRefName() != null) {
            jEJB.setName(ref.getEjbRefName());
        }
        if (ref.getMappedName() != null) {
            jEJB.setMappedName(ref.getMappedName());
        }
        if (ref.getLookupName() != null) {
            jEJB.setLookup(ref.getLookupName());
        }
        if (ref.getEjbLink() != null) {
            jEJB.setBeanName(ref.getEjbLink());
        }
        return jEJB;
    }

    private void applyAroundInvoke(List<IAroundInvoke> aroundInvokeList, C classAnnotationMetadata, String type) {
        for (IAroundInvoke aroundInvoke : aroundInvokeList) {
            String interceptorClassName = null;
            interceptorClassName = aroundInvoke.getClassName() == null ? classAnnotationMetadata.getClassName() : EjbJarMetadataMerge.encode((String)aroundInvoke.getClassName());
            String searchMethodName = aroundInvoke.getMethodName();
            if (searchMethodName == null) {
                throw new IllegalStateException("Invalid null method name for the callback '" + interceptorClassName + "'.");
            }
            this.applyInterceptor(type, interceptorClassName, searchMethodName, classAnnotationMetadata);
        }
    }

    private void applyLifeCycle(List<ILifeCycleCallback> lifecycleList, C classAnnotationMetadata, String type) {
        for (ILifeCycleCallback lifecycleCallback : lifecycleList) {
            String interceptorClassName = null;
            interceptorClassName = lifecycleCallback.getLifecycleCallbackClass() == null ? classAnnotationMetadata.getClassName() : EjbJarMetadataMerge.encode((String)lifecycleCallback.getLifecycleCallbackClass());
            String searchMethodName = lifecycleCallback.getLifecycleCallbackMethod();
            if (searchMethodName == null) {
                throw new IllegalStateException("Invalid null method name for the callback '" + interceptorClassName + "'.");
            }
            this.applyInterceptor(type, interceptorClassName, searchMethodName, classAnnotationMetadata);
        }
    }

    private void addInterceptorForClass(C classAnnotationMetadata, String interceptorClassName) {
        IJInterceptors interceptors = classAnnotationMetadata.getAnnotationInterceptors();
        if (interceptors == null) {
            interceptors = new JInterceptors();
            classAnnotationMetadata.setAnnotationsInterceptors(interceptors);
        }
        if (!interceptors.contains(interceptorClassName)) {
            interceptors.addClass(interceptorClassName);
        }
    }

    private void applyInterceptor(String type, String interceptorClassName, String methodName, C classAnnotationMetadata) {
        ArrayList<String> superClassesOfBean = new ArrayList<String>();
        Object beanClassMetadata = classAnnotationMetadata;
        String superClassBeanName = beanClassMetadata.getClassName();
        while (!superClassBeanName.equals(JAVA_LANG_OBJECT)) {
            superClassesOfBean.add(superClassBeanName);
            beanClassMetadata = beanClassMetadata.getLinkedClassMetadata(superClassBeanName);
            superClassBeanName = beanClassMetadata.getSuperName();
        }
        if (classAnnotationMetadata != null && !superClassesOfBean.contains(interceptorClassName)) {
            this.addInterceptorForClass(classAnnotationMetadata, interceptorClassName);
        }
        IEjbJarMethodMetadata foundMethod = null;
        IEjbJarClassMetadata interceptorMetadata = classAnnotationMetadata.getLinkedClassMetadata(interceptorClassName);
        boolean loop = true;
        while (foundMethod == null && loop) {
            List listMethods = interceptorMetadata.searchStandardMethodMetadata(methodName);
            if (listMethods.size() == 1) {
                foundMethod = (IEjbJarMethodMetadata)listMethods.get(0);
                continue;
            }
            if (listMethods.size() > 1) {
                throw new IllegalStateException("Method with name '" + methodName + "' was found more than once on the class '" + interceptorMetadata.getClassName() + "'.");
            }
            String superClassName = interceptorMetadata.getSuperName();
            if (!superClassName.equals(JAVA_LANG_OBJECT)) {
                interceptorMetadata = this.getEjbJarDeployableMetadata().getScannedClassMetadata(superClassName);
                continue;
            }
            loop = false;
        }
        if (foundMethod == null) {
            throw new IllegalStateException("The method named '" + methodName + "' was not found in the class '" + interceptorMetadata.getClassName() + "' and all its super-classes.");
        }
        if ("post-construct".equals(type)) {
            if (!foundMethod.isPostConstruct()) {
                foundMethod.setPostConstruct(true);
            }
        } else if ("pre-destroy".equals(type)) {
            if (!foundMethod.isPreDestroy()) {
                foundMethod.setPreDestroy(true);
            }
        } else if ("pre-passivate".equals(type)) {
            if (!foundMethod.isPrePassivate()) {
                foundMethod.setPrePassivate(true);
            }
        } else if ("post-activate".equals(type)) {
            if (!foundMethod.isPostActivate()) {
                foundMethod.setPostActivate(true);
            }
        } else if ("around-invoke".equals(type)) {
            if (!foundMethod.isAroundInvoke()) {
                foundMethod.setAroundInvoke(true);
            }
        } else {
            throw new IllegalStateException("No case for type '" + type + "'..");
        }
    }

    public void mergeApplicationException(IAssemblyDescriptor assemblyDescriptor) {
        List assemblyDescriptorList = assemblyDescriptor.getApplicationExceptionList();
        if (assemblyDescriptorList != null) {
            for (IApplicationException applicationException : assemblyDescriptorList) {
                String className = applicationException.getClassName();
                IEjbJarClassMetadata exceptionMetadata = this.getEjbJarDeployableMetadata().getScannedClassMetadata(EjbJarMetadataMerge.encode((String)className));
                if (exceptionMetadata == null) {
                    throw new IllegalStateException("The class named '" + className + "' was not found. Cannot set ApplicationException on it");
                }
                exceptionMetadata.setApplicationException(applicationException);
                logger.debug((Object)"Setting the application-exception ''{0}'' on the class ''{1}''", new Object[]{applicationException, className});
            }
        }
    }

    public void mergeAssemblySecurity(IAssemblyDescriptor assemblyDescriptor) {
        List securityRoles = assemblyDescriptor.getSecurityRoleList();
        for (String role : securityRoles) {
            for (IEjbJarClassMetadata beanMetadata : this.getEjbJarDeployableMetadata().getEjbJarClassMetadataCollection()) {
                if (!beanMetadata.isBean()) continue;
                ArrayList<String> declaredRoles = beanMetadata.getDeclareRoles();
                if (declaredRoles == null) {
                    declaredRoles = new ArrayList<String>();
                }
                if (declaredRoles.contains(role)) continue;
                declaredRoles.add(role);
                beanMetadata.setDeclareRoles(declaredRoles);
            }
        }
        List methodPermissionList = assemblyDescriptor.getMethodPermissionList();
        for (IMethodPermission methodPermission : methodPermissionList) {
            List methodDDs = methodPermission.getMethods();
            for (IMethodDD method : methodDDs) {
                String ejbName = method.getEjbName();
                IEjbJarClassMetadata beanMetadata = this.getEjbJarDeployableMetadata().getEjbJarClassMetadataForEjbName(ejbName);
                if (beanMetadata == null) {
                    throw new IllegalStateException("No metadata found for the the ejb '" + ejbName + "'. Check that this ejb is defined. This ejb-name is referenced from " + "a method of an assembly descriptor / method-permission");
                }
                List<M> methods = this.getMethodsForGivenMethodDD(method, beanMetadata);
                for (IEjbJarMethodMetadata methodAnnotationMetadata : methods) {
                    if (methodPermission.isUnchecked()) {
                        methodAnnotationMetadata.setPermitAll(true);
                        continue;
                    }
                    if (methodPermission.getRoleNameList().size() <= 0) continue;
                    for (String role : methodPermission.getRoleNameList()) {
                        ArrayList<String> existingRolesAllowed = methodAnnotationMetadata.getRolesAllowed();
                        if (existingRolesAllowed == null) {
                            existingRolesAllowed = new ArrayList<String>();
                        }
                        if (existingRolesAllowed.contains(role)) continue;
                        existingRolesAllowed.add(role);
                        methodAnnotationMetadata.setRolesAllowed(existingRolesAllowed);
                    }
                }
            }
        }
        List excludeMethodList = assemblyDescriptor.getExcludeListMethods();
        for (IMethodDD method : excludeMethodList) {
            String ejbName = method.getEjbName();
            IEjbJarClassMetadata beanMetadata = this.getEjbJarDeployableMetadata().getEjbJarClassMetadataForEjbName(ejbName);
            if (beanMetadata == null) {
                throw new IllegalStateException("No metadata found for the the ejb '" + ejbName + "'. Check that this ejb is defined. This ejb-name is referenced from " + "a method of an assembly descriptor / exclude-list");
            }
            List<M> methods = this.getMethodsForGivenMethodDD(method, beanMetadata);
            for (IEjbJarMethodMetadata methodAnnotationMetadata : methods) {
                methodAnnotationMetadata.setDenyAll(true);
            }
        }
    }

    public void mergeContainerTransaction(IAssemblyDescriptor assemblyDescriptor) {
        List containerTransactionList = assemblyDescriptor.getContainerTransactionList();
        if (containerTransactionList == null) {
            return;
        }
        for (IContainerTransaction containerTransaction : containerTransactionList) {
            TransactionAttributeType transactionAttributeType = containerTransaction.getTransactionAttribute();
            if (transactionAttributeType == null) continue;
            for (IMethodDD method : containerTransaction.getMethods()) {
                String ejbName = method.getEjbName();
                IEjbJarClassMetadata beanMetadata = this.getEjbJarDeployableMetadata().getEjbJarClassMetadataForEjbName(ejbName);
                if (beanMetadata == null) {
                    throw new IllegalStateException("No metadata found for the the ejb '" + ejbName + "'. Check that this ejb is defined. This ejb-name is referenced from " + "a method of a container transaction");
                }
                String methodName = method.getName();
                TransactionAttributeLevel txlevel = TransactionAttributeLevel.XML_WILDCARD;
                if (WILDCARD.equals(methodName)) {
                    for (IEjbJarMethodMetadata methodAnnotationMetadata : beanMetadata.getStandardMethodMetadataCollection()) {
                        if (methodAnnotationMetadata.getTransactionAttributeLevel() != TransactionAttributeLevel.ANNOTATION) continue;
                        methodAnnotationMetadata.setTransactionAttributeType(transactionAttributeType);
                        methodAnnotationMetadata.setTransactionAttributeLevel(txlevel);
                        logger.debug((Object)"Setting transaction attribute of method {0} of bean {1} to {2}", new Object[]{methodAnnotationMetadata, ejbName, transactionAttributeType});
                    }
                    continue;
                }
                List params = method.getParams();
                txlevel = params == null || params.size() == 0 ? TransactionAttributeLevel.XML_METHOD_NAME : TransactionAttributeLevel.XML_METHOD_PARAMS;
                List<M> methods = this.getMethodsForGivenMethodDD(method, beanMetadata);
                if (methods.size() == 0) {
                    throw new IllegalStateException("No matching method found with '" + method + "' for bean '" + ejbName + "'.");
                }
                for (IEjbJarMethodMetadata methodAnnotationMetadata : methods) {
                    if (methodAnnotationMetadata.getTransactionAttributeLevel() != TransactionAttributeLevel.ANNOTATION && methodAnnotationMetadata.getTransactionAttributeLevel() != TransactionAttributeLevel.XML_WILDCARD || (txlevel != TransactionAttributeLevel.XML_METHOD_NAME || methodAnnotationMetadata.getTransactionAttributeLevel() == TransactionAttributeLevel.XML_METHOD_PARAMS) && txlevel != TransactionAttributeLevel.XML_METHOD_PARAMS) continue;
                    methodAnnotationMetadata.setTransactionAttributeType(transactionAttributeType);
                    methodAnnotationMetadata.setTransactionAttributeLevel(txlevel);
                    logger.debug((Object)"Setting transaction attribute of method {0} of bean {1} to {2}", new Object[]{methodAnnotationMetadata, ejbName, txlevel});
                }
            }
        }
    }

    public void mergeInterceptorBinding(IAssemblyDescriptor assemblyDescriptor) {
        List interceptorBindingList = assemblyDescriptor.getInterceptorBindingList();
        if (interceptorBindingList != null) {
            for (IInterceptorBinding interceptorBinding : interceptorBindingList) {
                String ejbName = interceptorBinding.getEjbName();
                if (WILDCARD.equals(ejbName)) {
                    IJInterceptors defaultInterceptors = this.getEjbJarDeployableMetadata().getDefaultInterceptorsClasses();
                    if (defaultInterceptors == null) {
                        defaultInterceptors = new JInterceptors();
                        this.getEjbJarDeployableMetadata().setDefaultInterceptorsClasses(defaultInterceptors);
                    }
                    for (String interceptor : interceptorBinding.getInterceptorClassList()) {
                        defaultInterceptors.addClass(EjbJarMetadataMerge.encode((String)interceptor));
                    }
                    continue;
                }
                IEjbJarClassMetadata beanMetadata = this.getEjbJarDeployableMetadata().getEjbJarClassMetadataForEjbName(ejbName);
                if (beanMetadata == null) {
                    throw new IllegalStateException("No metadata found for the the ejb '" + ejbName + "'. Check that this ejb is defined. This ejb-name is referenced from an interceptor-binding");
                }
                IMethodDD methodDD = interceptorBinding.getMethod();
                if (methodDD == null) {
                    List orderList;
                    IJInterceptors interceptors = beanMetadata.getAnnotationInterceptors();
                    if (interceptors == null) {
                        interceptors = new JInterceptors();
                        beanMetadata.setAnnotationsInterceptors(interceptors);
                    }
                    for (String interceptor : interceptorBinding.getInterceptorClassList()) {
                        interceptors.addClass(EjbJarMetadataMerge.encode((String)interceptor));
                    }
                    if (interceptorBinding.isExcludeDefaultInterceptorsCalled()) {
                        beanMetadata.setExcludeDefaultInterceptors(interceptorBinding.isExcludeDefaultInterceptors());
                    }
                    if ((orderList = interceptorBinding.getOrderInterceptorClassList()) == null) continue;
                    if (beanMetadata.isOrderedInterceptors()) {
                        throw new IllegalStateException("The interceptor-order element has already been used on the bean '" + ejbName + "'. It can only be used once.");
                    }
                    beanMetadata.setOrderedInterceptors(true);
                    if (!beanMetadata.isExcludedDefaultInterceptors() && beanMetadata.getEjbJarDeployableMetadata().getDefaultInterceptorsClasses() != null) {
                        for (String cls : beanMetadata.getEjbJarDeployableMetadata().getDefaultInterceptorsClasses().getClasses()) {
                            interceptors.addClass(cls);
                        }
                    }
                    for (String interceptor : interceptorBinding.getOrderInterceptorClassList()) {
                        String encodedName = EjbJarMetadataMerge.encode((String)interceptor);
                        if (interceptors.contains(encodedName)) continue;
                        interceptors.addClass(encodedName);
                    }
                    if (interceptors.size() != orderList.size()) {
                        String err = "The list used for ordering interceptors is not a total list as the size mismatch.";
                        err = err + "The current list is '" + interceptors + "' while the ordering list is '" + orderList + "'.";
                        throw new IllegalStateException(err);
                    }
                    for (String clazz : orderList) {
                        if (interceptors.contains(EjbJarMetadataMerge.encode((String)clazz))) continue;
                        throw new IllegalStateException("The element '" + clazz + "' of the ordered list is not present in the interceptors '" + interceptors + "'.");
                    }
                    JInterceptors orderedInterceptors = new JInterceptors();
                    for (String clazz : orderList) {
                        orderedInterceptors.addClass(EjbJarMetadataMerge.encode((String)clazz));
                    }
                    beanMetadata.setAnnotationsInterceptors((IJInterceptors)orderedInterceptors);
                    continue;
                }
                List<M> methods = this.getMethodsForGivenMethodDD(methodDD, beanMetadata);
                if (methods.size() == 0) {
                    logger.warn((Object)("Method with name '" + methodDD.getName() + "' is specified in interceptorBinding element for class '" + beanMetadata.getClassName() + "' but no methods are matching"), new Object[0]);
                }
                for (IEjbJarMethodMetadata method : methods) {
                    IJInterceptors interceptors = method.getAnnotationInterceptors();
                    if (interceptors == null) {
                        interceptors = new JInterceptors();
                        method.setAnnotationsInterceptors(interceptors);
                    }
                    for (String interceptor : interceptorBinding.getInterceptorClassList()) {
                        interceptors.addClass(EjbJarMetadataMerge.encode((String)interceptor));
                    }
                    List orderList = interceptorBinding.getOrderInterceptorClassList();
                    if (orderList != null) {
                        for (String interceptor : interceptorBinding.getOrderInterceptorClassList()) {
                            String encodedName = EjbJarMetadataMerge.encode((String)interceptor);
                            if (interceptors.contains(encodedName)) continue;
                            interceptors.addClass(encodedName);
                        }
                    }
                    if (interceptorBinding.isExcludeClassInterceptorsCalled()) {
                        method.setExcludeClassInterceptors(interceptorBinding.isExcludeClassInterceptors());
                    }
                    if (!interceptorBinding.isExcludeDefaultInterceptorsCalled()) continue;
                    method.setExcludeDefaultInterceptors(interceptorBinding.isExcludeDefaultInterceptors());
                }
            }
        }
    }

    protected List<M> getMethodsForGivenMethodDD(IMethodDD methodDD, C classAnnotationMetadata) {
        String methodName = methodDD.getName();
        List methodParams = methodDD.getParams();
        HashMap<JMethod, IEjbJarMethodMetadata> beanMethods = new HashMap<JMethod, IEjbJarMethodMetadata>();
        String superClassName = classAnnotationMetadata.getClassName();
        while (!JAVA_LANG_OBJECT.equals(superClassName)) {
            IEjbJarClassMetadata superClassAnnotationMetadata = classAnnotationMetadata.getLinkedClassMetadata(superClassName);
            List findingMethods = superClassAnnotationMetadata.searchStandardMethodMetadata(methodName);
            for (IEjbJarMethodMetadata method : findingMethods) {
                if (beanMethods.containsKey(method.getJMethod())) continue;
                Type[] argumentTypes = Type.getArgumentTypes(method.getJMethod().getDescriptor());
                if (methodParams != null) {
                    if (argumentTypes == null || argumentTypes.length != methodParams.size()) continue;
                    beanMethods.put(method.getJMethod(), method);
                    continue;
                }
                beanMethods.put(method.getJMethod(), method);
            }
            superClassName = superClassAnnotationMetadata.getSuperName();
        }
        ArrayList<Object> methods = new ArrayList(beanMethods.values());
        List params = methodDD.getParams();
        if (params != null && params.size() > 0) {
            ArrayList<IEjbJarMethodMetadata> newMethods = new ArrayList<IEjbJarMethodMetadata>();
            for (IEjbJarMethodMetadata method : methods) {
                Type[] types = Type.getArgumentTypes(method.getJMethod().getDescriptor());
                if (params.size() != types.length) continue;
                int i = 0;
                boolean matching = false;
                for (String param : params) {
                    if (param.equals(types[i].getClassName())) {
                        matching = true;
                    }
                    ++i;
                }
                if (!matching) continue;
                newMethods.add(method);
            }
            methods = newMethods;
        }
        return methods;
    }

    protected void applyHandlerChain(C classAnnotationMetadata) {
        IJwsHandlerChain handlerChain = classAnnotationMetadata.getJwsHandlerChain();
        List references = classAnnotationMetadata.getJaxwsWebServiceRefs();
        if (handlerChain != null && references != null && !references.isEmpty()) {
            for (IJaxwsWebServiceRef reference : references) {
                reference.setHandlerChainFile(handlerChain.getFile());
                String classname = EjbJarMetadataMerge.decode((String)classAnnotationMetadata.getJClass().getName());
                reference.setDeclaringClass(classname);
            }
        }
        Collection allMethodMetadata = classAnnotationMetadata.getStandardMethodMetadataCollection();
        for (ICommonMethodMetadata metadata : allMethodMetadata) {
            IJwsHandlerChain jwsHandlerChain = metadata.getJwsHandlerChain();
            IJaxwsWebServiceRef reference = metadata.getJaxwsWebServiceRef();
            if (jwsHandlerChain == null || reference == null) continue;
            reference.setHandlerChainFile(jwsHandlerChain.getFile());
            String classname = EjbJarMetadataMerge.decode((String)metadata.getClassMetadata().getJClass().getName());
            reference.setDeclaringClass(classname);
        }
        Collection allFieldMetadatas = classAnnotationMetadata.getStandardFieldMetadataCollection();
        for (ICommonFieldMetadata metadata : allFieldMetadatas) {
            IJwsHandlerChain jwsHandlerChain = metadata.getJwsHandlerChain();
            IJaxwsWebServiceRef reference = metadata.getJaxwsWebServiceRef();
            if (jwsHandlerChain == null || reference == null) continue;
            reference.setHandlerChainFile(jwsHandlerChain.getFile());
            String classname = EjbJarMetadataMerge.decode((String)metadata.getClassMetadata().getJClass().getName());
            reference.setDeclaringClass(classname);
        }
    }
}

