/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.ssh.internal.command;

import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(name="stop-daemon", scope="ssh", description="Stop a SSHD daemon")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class StopSshdCommand
implements Action,
Pojo {
    private InstanceManager __IM;
    private static final String FILTER = "(service.factoryPid=org.ow2.shelbie.commands.ssh.server.internal.SshDaemonComponent)";
    private boolean __FserverPID;
    @Option(name="-i", aliases={"--server-pid"}, required=false)
    private String serverPID;
    private boolean __FconfigurationAdmin;
    @Requires
    private ConfigurationAdmin configurationAdmin;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;

    String __getserverPID() {
        if (!this.__FserverPID) {
            return this.serverPID;
        }
        return (String)this.__IM.onGet((Object)this, "serverPID");
    }

    void __setserverPID(String string) {
        if (!this.__FserverPID) {
            this.serverPID = string;
            return;
        }
        this.__IM.onSet((Object)this, "serverPID", (Object)string);
    }

    ConfigurationAdmin __getconfigurationAdmin() {
        if (!this.__FconfigurationAdmin) {
            return this.configurationAdmin;
        }
        return (ConfigurationAdmin)this.__IM.onGet((Object)this, "configurationAdmin");
    }

    void __setconfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (!this.__FconfigurationAdmin) {
            this.configurationAdmin = configurationAdmin;
            return;
        }
        this.__IM.onSet((Object)this, "configurationAdmin", (Object)configurationAdmin);
    }

    public StopSshdCommand() {
        this(null);
    }

    private StopSshdCommand(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession session) throws Exception {
        Configuration config = null;
        Configuration[] configurations = this.__getconfigurationAdmin().listConfigurations(FILTER);
        if (configurations != null && configurations.length != 0) {
            if (this.__getserverPID() == null) {
                if (configurations.length == 1) {
                    config = configurations[0];
                } else {
                    System.err.println("Server PID was not specified.");
                }
            } else {
                for (Configuration c : configurations) {
                    if (!c.getPid().equals(this.__getserverPID())) continue;
                    config = c;
                }
            }
        }
        if (config == null) {
            System.err.println("Cannot find the Configuration object linked to the SSH Daemon.");
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("SSH Daemon stopped");
            System.out.println(sb.toString());
            config.delete();
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("configurationAdmin")) {
                this.__FconfigurationAdmin = true;
            }
            if (set.contains("serverPID")) {
                this.__FserverPID = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null && set.contains("execute$org_apache_felix_service_command_CommandSession")) {
            this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

