/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.spi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.ow2.carol.jndi.registry.JRMPRegistryWrapperContext;
import org.ow2.carol.jndi.spi.JRMPContext;
import org.ow2.carol.jndi.wrapping.JNDIRemoteResource;
import org.ow2.carol.jndi.wrapping.RemoteReference;
import org.ow2.carol.rmi.exception.NamingExceptionHelper;

public class JRMPLocalContext
extends JRMPContext
implements Context {
    public JRMPLocalContext(Context jrmpLocalContext) throws NamingException {
        super(new JRMPRegistryWrapperContext(new Hashtable<Object, Object>(jrmpLocalContext.getEnvironment())));
    }

    protected Object unwrapObject(Object o, Name name) throws NamingException {
        try {
            if (o instanceof RemoteReference) {
                Reference objRef = ((RemoteReference)o).getReference();
                if (objRef instanceof LinkRef) {
                    return this.lookup(((LinkRef)objRef).getLinkName());
                }
                if (objRef.getFactoryClassName() == null) {
                    return objRef;
                }
                ObjectFactory objFact = null;
                try {
                    objFact = (ObjectFactory)Class.forName(objRef.getFactoryClassName()).newInstance();
                }
                catch (Exception e) {
                    objFact = (ObjectFactory)Class.forName(objRef.getFactoryClassName(), true, Thread.currentThread().getContextClassLoader()).newInstance();
                }
                return objFact.getObjectInstance(objRef, name, this, this.getEnvironment());
            }
            if (o instanceof JNDIRemoteResource) {
                return ((JNDIRemoteResource)o).getResource();
            }
            return o;
        }
        catch (Exception e) {
            throw NamingExceptionHelper.create("Cannot unwrap object '" + o + "' with name '" + name + "'.", e);
        }
    }
}

