/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.osgi;

import fr.dyade.aaa.common.Debug;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.NamingException;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.admin.AbstractConnectionFactory;
import org.objectweb.joram.client.jms.local.LocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.joram.client.osgi.JndiHelper;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class ConnectionFactoryMSF
implements ManagedServiceFactory {
    public static final Logger logmon = Debug.getLogger((String)ConnectionFactoryMSF.class.getName());
    public static final String CLASSNAME = "className";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String RELIABLECLASS = "reliableClass";
    public static final String TIMEOUT = "timeout";
    public static final String IDENTITYCLASS = "identityClassName";
    public static final String ININTERCEPTORCLASS = "inInterceptorClassname";
    public static final String OUTINTERCEPTORCLASS = "outInterceptorClassname";
    public static final String JNDINAME = "jndiName";
    public static final String NAME = "name";
    private BundleContext bundleContext;
    private ServiceRegistration registration;
    private HashMap<String, AbstractConnectionFactory> cnxFactories;
    private JndiHelper jndiHelper;
    private HashMap<String, String> jndiNames;

    public ConnectionFactoryMSF(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        Properties props = new Properties();
        props.setProperty("service.pid", ConnectionFactoryMSF.class.getName());
        this.registration = this.bundleContext.registerService(ManagedServiceFactory.class.getName(), (Object)this, (Dictionary)props);
        this.cnxFactories = new HashMap();
        this.jndiHelper = new JndiHelper();
        this.jndiNames = new HashMap();
    }

    private final boolean isSet(String value) {
        return value != null && value.length() > 0;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() {
    }

    public String getName() {
        return "ConnectionFactoryMSF";
    }

    public void updated(final String pid, Dictionary properties) throws ConfigurationException {
        String outInterceptorClassname;
        String inInterceptorClassname;
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("updated(" + pid + ", " + properties + ')'));
        }
        if (properties == null) {
            this.deleted(pid);
            return;
        }
        ConnectionFactory cf = null;
        String name = (String)properties.get(NAME);
        String className = (String)properties.get(CLASSNAME);
        if (!this.isSet(className)) {
            throw new ConfigurationException(CLASSNAME, "this property is required.");
        }
        if (TcpConnectionFactory.class.getName().equals(className)) {
            String host = (String)properties.get(HOST);
            if (!this.isSet(host)) {
                host = AbstractConnectionFactory.getDefaultServerHost();
            }
            int port = -1;
            String portStr = (String)properties.get(PORT);
            port = !this.isSet(portStr) ? AbstractConnectionFactory.getDefaultServerPort() : new Integer(portStr);
            String reliableClass = (String)properties.get(RELIABLECLASS);
            if (!this.isSet(reliableClass)) {
                reliableClass = "org.objectweb.joram.client.jms.tcp.ReliableTcpClient";
            }
            cf = TcpConnectionFactory.create(host, port, reliableClass);
        } else if (LocalConnectionFactory.class.getName().equals(className)) {
            cf = LocalConnectionFactory.create();
        } else {
            throw new ConfigurationException(CLASSNAME, "Unknown class : " + className);
        }
        this.cnxFactories.put(pid, cf);
        String identityClassName = (String)properties.get(IDENTITYCLASS);
        if (!this.isSet(identityClassName)) {
            identityClassName = SimpleIdentity.class.getName();
        }
        if (this.isSet(inInterceptorClassname = (String)properties.get(ININTERCEPTORCLASS))) {
            cf.getParameters().addInInterceptor(inInterceptorClassname);
        }
        if (this.isSet(outInterceptorClassname = (String)properties.get(OUTINTERCEPTORCLASS))) {
            cf.getParameters().addOutInterceptor(outInterceptorClassname);
        }
        Properties prop = new Properties();
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals(CLASSNAME) || key.equals(HOST) || key.equals(PORT) || key.equals(RELIABLECLASS) || key.equals(TIMEOUT) || key.equals(IDENTITYCLASS) || key.equals(ININTERCEPTORCLASS) || key.equals(OUTINTERCEPTORCLASS) || key.equals(JNDINAME) || key.equals(NAME) || key.equals("service.pid") || key.equals("service.factoryPid") || key.startsWith("jonas")) continue;
            prop.put(key, properties.get(key));
        }
        cf.getParameters().setParameters(prop);
        final String jndiName = (String)properties.get(JNDINAME);
        final ConnectionFactory cff = cf;
        if (this.isSet(jndiName)) {
            new Thread(new Runnable(){

                public void run() {
                    for (int i = 0; i < 10; ++i) {
                        try {
                            ConnectionFactoryMSF.this.jndiHelper.rebind(jndiName, cff);
                            ConnectionFactoryMSF.this.jndiNames.put(pid, jndiName);
                        }
                        catch (NamingException e) {
                            try {
                                Thread.sleep(1000L);
                                if (!logmon.isLoggable(BasicLevel.DEBUG)) continue;
                                logmon.log(BasicLevel.DEBUG, (Object)("retry to rebind: " + jndiName));
                                continue;
                            }
                            catch (InterruptedException e1) {}
                        }
                        break;
                    }
                }
            }).start();
        }
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("updated cf created/updated : " + cf));
        }
    }

    public void deleted(String pid) {
        if (logmon.isLoggable(BasicLevel.DEBUG)) {
            logmon.log(BasicLevel.DEBUG, (Object)("deleted(" + pid + ')'));
        }
        if (this.cnxFactories.containsKey(pid)) {
            AbstractConnectionFactory factory = this.cnxFactories.remove(pid);
            String jndiName = this.jndiNames.remove(pid);
            if (jndiName != null) {
                this.jndiHelper.unbind(jndiName);
            }
        }
    }
}

