/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.ssh.server.internal;

import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import jline.console.completer.Completer;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.sshd.common.Factory;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.ow2.shelbie.core.IPromptProvider;
import org.ow2.shelbie.core.console.JLineConsole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellFactoryImpl
implements Factory<Command> {
    private final CommandProcessor commandProcessor;
    private final Completer completer;
    private JLineConsole console;
    private IPromptProvider promptProvider;

    public ShellFactoryImpl(CommandProcessor commandProcessor, Completer completer, IPromptProvider promptProvider) {
        this.commandProcessor = commandProcessor;
        this.completer = completer;
        this.promptProvider = promptProvider;
    }

    @Override
    public Command create() {
        return new SimpleShell();
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public class LfToCrLfFilterOutputStream
    extends FilterOutputStream {
        private boolean lastWasCr;

        public LfToCrLfFilterOutputStream(OutputStream out) {
            super(out);
        }

        public void write(int b) throws IOException {
            if (!this.lastWasCr && b == 10) {
                this.out.write(13);
                this.out.write(10);
            } else {
                this.out.write(b);
            }
            this.lastWasCr = b == 13;
        }
    }

    private class SimpleShell
    implements Command {
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private CommandSession session;
        private ExitCallback callback;

        private SimpleShell() {
        }

        public void destroy() {
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ExitCallback callback) {
            this.callback = callback;
        }

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void start(Environment env) throws IOException {
            try {
                ShellFactoryImpl.this.console = new JLineConsole(ShellFactoryImpl.this.commandProcessor, ShellFactoryImpl.this.completer, this.in, new PrintStream(new LfToCrLfFilterOutputStream(this.out)), new PrintStream(new LfToCrLfFilterOutputStream(this.err)), ShellFactoryImpl.this.promptProvider){

                    public void run() {
                        super.run();
                        SimpleShell.this.onExit();
                    }
                };
                this.session = ShellFactoryImpl.this.console.getSession();
                this.session.put("application.name", (Object)"shelbie");
                for (Map.Entry<String, String> e : env.getEnv().entrySet()) {
                    this.session.put(e.getKey(), (Object)e.getValue());
                }
                new Thread((Runnable)ShellFactoryImpl.this.console, "SSH Console").start();
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to start shell").initCause(e);
            }
        }

        public void onExit() {
            ShellFactoryImpl.this.console.close();
            ShellFactoryImpl.close(new Closeable[]{this.in, this.out, this.err});
            this.callback.onExit(0);
        }
    }
}

