/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.Serializable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkDelegate;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.util.NumericFieldUtils;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeleteWorkDelegate
implements LuceneWorkDelegate {
    private static final Logger log = LoggerFactory.make();
    private final Workspace workspace;

    DeleteWorkDelegate(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public void performWork(LuceneWork work, IndexWriter writer) {
        Class entityType = work.getEntityClass();
        Serializable id = work.getId();
        log.trace("Removing {}#{} by query.", (Object)entityType, (Object)id);
        DocumentBuilderIndexedEntity builder = this.workspace.getDocumentBuilder(entityType);
        BooleanQuery entityDeletionQuery = new BooleanQuery();
        Query idQueryTerm = DeleteWorkDelegate.isIdNumeric(entityType, builder) ? NumericFieldUtils.createExactMatchQuery(builder.getIdKeywordName(), id) : new TermQuery(builder.getTerm(id));
        entityDeletionQuery.add(idQueryTerm, BooleanClause.Occur.MUST);
        Term classNameQueryTerm = new Term("_hibernate_class", entityType.getName());
        TermQuery classNameQuery = new TermQuery(classNameQueryTerm);
        entityDeletionQuery.add(classNameQuery, BooleanClause.Occur.MUST);
        try {
            writer.deleteDocuments((Query)entityDeletionQuery);
        }
        catch (Exception e) {
            String message = "Unable to remove " + entityType + "#" + id + " from index.";
            throw new SearchException(message, e);
        }
    }

    protected static boolean isIdNumeric(Class<?> entityType, DocumentBuilderIndexedEntity<?> documentBuilder) {
        TwoWayFieldBridge idBridge = documentBuilder.getIdBridge();
        return idBridge instanceof NumericFieldBridge;
    }

    @Override
    public void logWorkDone(LuceneWork work, MassIndexerProgressMonitor monitor) {
    }
}

