/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.Serializable;
import org.apache.lucene.document.Document;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.util.ContextualException2WayBridge;
import org.hibernate.search.engine.AbstractDocumentBuilder;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentBuilderHelper {
    private static final Logger log = LoggerFactory.make();

    private DocumentBuilderHelper() {
    }

    public static Class getDocumentClass(String className) {
        try {
            return ReflectHelper.classForName(className);
        }
        catch (ClassNotFoundException e) {
            throw new SearchException("Unable to load indexed class: " + className, e);
        }
    }

    public static Serializable getDocumentId(SearchFactoryImplementor searchFactoryImplementor, Class<?> clazz, Document document) {
        DocumentBuilderIndexedEntity<?> builderIndexedEntity = searchFactoryImplementor.getDocumentBuilderIndexedEntity(clazz);
        if (builderIndexedEntity == null) {
            throw new SearchException("No Lucene configuration set up for: " + clazz);
        }
        TwoWayFieldBridge fieldBridge = builderIndexedEntity.getIdBridge();
        String fieldName = builderIndexedEntity.getIdKeywordName();
        ContextualException2WayBridge contextualBridge = new ContextualException2WayBridge();
        ((ContextualException2WayBridge)contextualBridge.setClass((Class)clazz)).setFieldName(fieldName).setFieldBridge(fieldBridge).pushIdentifierMethod();
        return (Serializable)contextualBridge.get(fieldName, document);
    }

    public static String getDocumentIdName(SearchFactoryImplementor searchFactoryImplementor, Class<?> clazz) {
        DocumentBuilderIndexedEntity<?> builderIndexedEntity = searchFactoryImplementor.getDocumentBuilderIndexedEntity(clazz);
        if (builderIndexedEntity == null) {
            throw new SearchException("No Lucene configuration set up for: " + clazz);
        }
        return builderIndexedEntity.getIdentifierName();
    }

    public static Object[] getDocumentFields(SearchFactoryImplementor searchFactoryImplementor, Class<?> clazz, Document document, String[] fields) {
        DocumentBuilderIndexedEntity<?> builderIndexedEntity = searchFactoryImplementor.getDocumentBuilderIndexedEntity(clazz);
        if (builderIndexedEntity == null) {
            throw new SearchException("No Lucene configuration set up for: " + clazz);
        }
        int fieldNbr = fields.length;
        Object[] result = new Object[fieldNbr];
        ContextualException2WayBridge contextualBridge = new ContextualException2WayBridge();
        contextualBridge.setClass((Class)clazz);
        if (builderIndexedEntity.getIdKeywordName() != null) {
            XMember member = builderIndexedEntity.getIdGetter();
            if (member != null) {
                contextualBridge.pushMethod(member);
            }
            DocumentBuilderHelper.populateResult(builderIndexedEntity.getIdKeywordName(), builderIndexedEntity.getIdBridge(), Store.YES, fields, result, document, contextualBridge);
            if (member != null) {
                contextualBridge.popMethod();
            }
        }
        AbstractDocumentBuilder.PropertiesMetadata metadata = builderIndexedEntity.getMetadata();
        DocumentBuilderHelper.processFieldsForProjection(metadata, fields, result, document, contextualBridge);
        return result;
    }

    public static void populateResult(String fieldName, FieldBridge fieldBridge, Store store, String[] fields, Object[] result, Document document, ContextualException2WayBridge contextualBridge) {
        int matchingPosition = DocumentBuilderHelper.getFieldPosition(fields, fieldName);
        if (matchingPosition != -1) {
            if (store != Store.NO && TwoWayFieldBridge.class.isAssignableFrom(fieldBridge.getClass())) {
                contextualBridge.setFieldName(fieldName).setFieldBridge((TwoWayFieldBridge)fieldBridge);
                result[matchingPosition] = contextualBridge.get(fieldName, document);
                if (log.isTraceEnabled()) {
                    log.trace("Field {} projected as {}", (Object)fieldName, result[matchingPosition]);
                }
            } else {
                if (store == Store.NO) {
                    throw new SearchException("Projecting an unstored field: " + fieldName);
                }
                throw new SearchException("FieldBridge is not a TwoWayFieldBridge: " + fieldBridge.getClass());
            }
        }
    }

    public static void processFieldsForProjection(AbstractDocumentBuilder.PropertiesMetadata metadata, String[] fields, Object[] result, Document document, ContextualException2WayBridge contextualBridge) {
        int nbrFoEntityFields = metadata.fieldNames.size();
        for (int index = 0; index < nbrFoEntityFields; ++index) {
            String fieldName = metadata.fieldNames.get(index);
            contextualBridge.pushMethod(metadata.fieldGetters.get(index));
            DocumentBuilderHelper.populateResult(fieldName, metadata.fieldBridges.get(index), metadata.fieldStore.get(index), fields, result, document, contextualBridge);
            contextualBridge.popMethod();
        }
        int nbrOfEmbeddedObjects = metadata.embeddedPropertiesMetadata.size();
        for (int index = 0; index < nbrOfEmbeddedObjects; ++index) {
            if (metadata.embeddedContainers.get(index) != AbstractDocumentBuilder.PropertiesMetadata.Container.OBJECT) continue;
            contextualBridge.pushMethod(metadata.embeddedGetters.get(index));
            DocumentBuilderHelper.processFieldsForProjection(metadata.embeddedPropertiesMetadata.get(index), fields, result, document, contextualBridge);
            contextualBridge.popMethod();
        }
        int nbrOfClassBridges = metadata.classBridges.size();
        for (int index = 0; index < nbrOfClassBridges; ++index) {
            DocumentBuilderHelper.populateResult(metadata.classNames.get(index), metadata.classBridges.get(index), metadata.classStores.get(index), fields, result, document, contextualBridge);
        }
    }

    public static int getFieldPosition(String[] fields, String fieldName) {
        int fieldNbr = fields.length;
        for (int index = 0; index < fieldNbr; ++index) {
            if (!fieldName.equals(fields[index])) continue;
            return index;
        }
        return -1;
    }
}

