/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader;

import java.util.Map;
import java.util.Properties;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.reader.NotSharedReaderProvider;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.SharingBufferReaderProvider;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.ClassLoaderHelper;

public abstract class ReaderProviderFactory {
    private static Properties getProperties(SearchConfiguration cfg) {
        Properties props = cfg.getProperties();
        Properties workerProperties = new Properties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("hibernate.search.reader.")) continue;
            workerProperties.put(key, entry.getValue());
        }
        return workerProperties;
    }

    public static ReaderProvider createReaderProvider(SearchConfiguration cfg, BuildContext context) {
        Properties props = ReaderProviderFactory.getProperties(cfg);
        String impl = props.getProperty("hibernate.search.reader.strategy");
        ReaderProvider readerProvider = StringHelper.isEmpty(impl) ? new SharingBufferReaderProvider() : ("not-shared".equalsIgnoreCase(impl) ? new NotSharedReaderProvider() : ("shared".equalsIgnoreCase(impl) ? new SharingBufferReaderProvider() : ("shared-segments".equalsIgnoreCase(impl) ? new SharingBufferReaderProvider() : ClassLoaderHelper.instanceFromName(ReaderProvider.class, impl, ReaderProviderFactory.class, "readerProvider"))));
        readerProvider.initialize(props, context);
        return readerProvider;
    }
}

