/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import java.util.Collection;
import org.apache.cxf.tools.corba.common.idltypes.CorbaUtils;
import org.apache.cxf.tools.corba.common.idltypes.IdlDefn;
import org.apache.cxf.tools.corba.common.idltypes.IdlEnumerator;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;

public final class IdlEnum
extends IdlScopeBase
implements IdlType {
    private IdlEnum(IdlScopeBase parent, String name) {
        super(parent, name);
    }

    public static IdlEnum create(IdlScopeBase parent, String name) {
        return new IdlEnum(parent, name);
    }

    public void addEnumerator(IdlEnumerator e) {
        this.addToScope(e);
    }

    public void write(PrintWriter pw) {
        pw.println(IdlEnum.indent() + "enum " + this.localName() + " {");
        IdlEnum.indentMore();
        Collection<IdlDefn> enums = this.definitions();
        int needComma = enums.size() - 1;
        for (IdlEnumerator idlEnumerator : enums) {
            pw.print(IdlEnum.indent() + CorbaUtils.mangleEnumIdentifier(this.localName() + "_" + idlEnumerator.localName()));
            if (needComma-- == 0) continue;
            pw.println(",");
        }
        pw.println();
        IdlEnum.indentLess();
        pw.println(IdlEnum.indent() + "};");
    }
}

