/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.wsdl;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.AddressType;
import org.apache.cxf.binding.corba.wsdl.Alias;
import org.apache.cxf.binding.corba.wsdl.Anonarray;
import org.apache.cxf.binding.corba.wsdl.Anonfixed;
import org.apache.cxf.binding.corba.wsdl.Anonsequence;
import org.apache.cxf.binding.corba.wsdl.Anonstring;
import org.apache.cxf.binding.corba.wsdl.ArgType;
import org.apache.cxf.binding.corba.wsdl.Array;
import org.apache.cxf.binding.corba.wsdl.BindingType;
import org.apache.cxf.binding.corba.wsdl.CaseType;
import org.apache.cxf.binding.corba.wsdl.Const;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.Enum;
import org.apache.cxf.binding.corba.wsdl.Enumerator;
import org.apache.cxf.binding.corba.wsdl.Fixed;
import org.apache.cxf.binding.corba.wsdl.MemberType;
import org.apache.cxf.binding.corba.wsdl.OperationType;
import org.apache.cxf.binding.corba.wsdl.ParamType;
import org.apache.cxf.binding.corba.wsdl.RaisesType;
import org.apache.cxf.binding.corba.wsdl.Sequence;
import org.apache.cxf.binding.corba.wsdl.Struct;
import org.apache.cxf.binding.corba.wsdl.TypeMappingType;
import org.apache.cxf.binding.corba.wsdl.Union;
import org.apache.cxf.binding.corba.wsdl.Unionbranch;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.corba.common.idltypes.CorbaUtils;
import org.apache.cxf.tools.corba.common.idltypes.IdlAnonArray;
import org.apache.cxf.tools.corba.common.idltypes.IdlAnonFixed;
import org.apache.cxf.tools.corba.common.idltypes.IdlAnonSequence;
import org.apache.cxf.tools.corba.common.idltypes.IdlArray;
import org.apache.cxf.tools.corba.common.idltypes.IdlAttribute;
import org.apache.cxf.tools.corba.common.idltypes.IdlConst;
import org.apache.cxf.tools.corba.common.idltypes.IdlDefn;
import org.apache.cxf.tools.corba.common.idltypes.IdlEnum;
import org.apache.cxf.tools.corba.common.idltypes.IdlEnumerator;
import org.apache.cxf.tools.corba.common.idltypes.IdlException;
import org.apache.cxf.tools.corba.common.idltypes.IdlField;
import org.apache.cxf.tools.corba.common.idltypes.IdlFixed;
import org.apache.cxf.tools.corba.common.idltypes.IdlInterface;
import org.apache.cxf.tools.corba.common.idltypes.IdlModule;
import org.apache.cxf.tools.corba.common.idltypes.IdlOperation;
import org.apache.cxf.tools.corba.common.idltypes.IdlParam;
import org.apache.cxf.tools.corba.common.idltypes.IdlRoot;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlSequence;
import org.apache.cxf.tools.corba.common.idltypes.IdlString;
import org.apache.cxf.tools.corba.common.idltypes.IdlStruct;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;
import org.apache.cxf.tools.corba.common.idltypes.IdlTypedef;
import org.apache.cxf.tools.corba.common.idltypes.IdlUnion;
import org.apache.cxf.tools.corba.common.idltypes.IdlUnionBranch;
import org.apache.cxf.tools.corba.processors.wsdl.WSDLToTypeProcessor;
import org.apache.cxf.tools.corba.utils.FileOutputStreamFactory;
import org.apache.cxf.tools.corba.utils.OutputStreamFactory;
import org.apache.cxf.wsdl.JAXBExtensionHelper;

public class WSDLToIDLAction {
    protected static final Logger LOG = LogUtils.getL7dLogger(WSDLToIDLAction.class);
    private static String bindingName;
    private static String wsdlFileName;
    private static String namespace;
    private String outputFile;
    private boolean verboseOn;
    private PrintWriter printWriter;
    private OutputStreamFactory factory = new FileOutputStreamFactory();
    private Definition def;
    private IdlRoot root = IdlRoot.create();
    private IdlInterface intf;
    private ExtensionRegistry extReg;
    private WSDLToTypeProcessor typeProcessor = new WSDLToTypeProcessor();
    private boolean generateAllBindings;

    public void generateIDL(Definition definition) throws Exception {
        if (definition == null) {
            this.typeProcessor.parseWSDL(wsdlFileName);
            this.def = this.typeProcessor.getWSDLDefinition();
        } else {
            this.def = definition;
        }
        this.extReg = this.def.getExtensionRegistry();
        if (this.printWriter == null) {
            this.printWriter = this.createPrintWriter(this.outputFile);
        }
        if (!this.isGenerateAllBindings()) {
            Binding binding = this.findBinding(this.def);
            if (binding == null) {
                String msgStr = "Binding " + bindingName + " doesn't exists in WSDL.";
                Message msg = new Message(msgStr, LOG, new Object[0]);
                throw new Exception(msg.toString());
            }
            this.generateIDL(this.def, binding);
        } else {
            Collection<Binding> bindings = CastUtils.cast(this.def.getAllBindings().values());
            if (bindings.size() == 0) {
                String msgStr = "No bindings exists within this WSDL.";
                Message msg = new Message(msgStr, LOG, new Object[0]);
                throw new Exception(msg.toString());
            }
            ArrayList<QName> portTypes = new ArrayList<QName>();
            for (Binding binding : bindings) {
                List ext = binding.getExtensibilityElements();
                if (!(ext.get(0) instanceof BindingType) || portTypes.contains(binding.getPortType().getQName())) continue;
                portTypes.add(binding.getPortType().getQName());
                this.generateIDL(this.def, binding);
                this.root = IdlRoot.create();
            }
        }
        this.printWriter.close();
    }

    public void addExtensions(ExtensionRegistry extRegistry) throws JAXBException {
        this.extReg = extRegistry;
        try {
            JAXBExtensionHelper.addExtensions(this.extReg, Binding.class, BindingType.class);
            JAXBExtensionHelper.addExtensions(this.extReg, BindingOperation.class, OperationType.class);
            JAXBExtensionHelper.addExtensions(this.extReg, Definition.class, TypeMappingType.class);
            JAXBExtensionHelper.addExtensions(this.extReg, Port.class, AddressType.class);
            this.extReg.mapExtensionTypes(Binding.class, CorbaConstants.NE_CORBA_BINDING, BindingType.class);
            this.extReg.mapExtensionTypes(BindingOperation.class, CorbaConstants.NE_CORBA_OPERATION, OperationType.class);
            this.extReg.mapExtensionTypes(Definition.class, CorbaConstants.NE_CORBA_TYPEMAPPING, TypeMappingType.class);
            this.extReg.mapExtensionTypes(Port.class, CorbaConstants.NE_CORBA_ADDRESS, AddressType.class);
        }
        catch (JAXBException ex) {
            LOG.log(Level.SEVERE, "Failing to serialize/deserialize extensions", ex);
            throw new JAXBException(ex.getMessage());
        }
    }

    private void generateIDL(Definition definition, Binding binding) {
        List ext = binding.getExtensibilityElements();
        if (!(ext.get(0) instanceof BindingType)) {
            throw new RuntimeException(binding.getQName() + " is not a corba binding, " + "please pass a corba binding/porttype to use");
        }
        String[] nm = this.unscopeName(binding.getPortType().getQName().getLocalPart());
        int pos = nm[nm.length - 1].lastIndexOf("Binding");
        if (pos != -1) {
            nm[nm.length - 1] = nm[nm.length - 1].substring(0, pos);
        }
        IdlScopeBase parent = this.root;
        if (nm.length > 1) {
            for (int i = 0; i < nm.length - 1; ++i) {
                IdlModule mod = IdlModule.create(parent, nm[i]);
                parent.addToScope(mod);
                parent = mod;
            }
        }
        this.intf = IdlInterface.create(parent, nm[nm.length - 1]);
        parent.holdForScope(this.intf);
        try {
            this.getAllIdlTypes();
            this.collectIdlDefns(binding);
            this.root.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        parent.promoteHeldToScope();
        this.root.write(this.printWriter);
    }

    private void collectIdlDefns(Binding binding) throws Exception {
        boolean isOneway = false;
        for (BindingOperation bindingOperation : binding.getBindingOperations()) {
            if (bindingOperation.getBindingOutput() == null) {
                isOneway = true;
            }
            this.addOperation(bindingOperation, isOneway);
        }
    }

    private void addOperation(BindingOperation bindingOperation, boolean isOneway) throws Exception {
        String name = null;
        for (OperationType opType : bindingOperation.getExtensibilityElements()) {
            name = opType.getName();
            if (name.startsWith("_get_") || name.startsWith("_set_")) {
                this.createIdlAttribute(opType, name);
            } else {
                this.createIdlOperation(opType, name, isOneway);
            }
            this.root.flush();
        }
    }

    public void createIdlAttribute(OperationType opType, String name) throws Exception {
        String attrNm = name.substring(5, name.length());
        IdlDefn idlDef = this.intf.lookup(attrNm);
        if (idlDef == null) {
            IdlAttribute attr;
            if (name.startsWith("_get_")) {
                ArgType t = opType.getReturn();
                attr = IdlAttribute.create(this.intf, attrNm, this.findType(t.getIdltype()), true);
            } else {
                ParamType arg = opType.getParam().iterator().next();
                attr = IdlAttribute.create(this.intf, attrNm, this.findType(arg.getIdltype()), false);
            }
            this.intf.addAttribute(attr);
        } else {
            IdlAttribute attr = (IdlAttribute)idlDef;
            if (attr.readonly() && name.startsWith("_set_")) {
                attr.setReadonly(false);
            }
        }
    }

    public void createIdlOperation(OperationType opType, String name, boolean isOneway) throws Exception {
        IdlType type;
        IdlOperation idlOp = IdlOperation.create(this.intf, opType.getName(), isOneway);
        this.intf.holdForScope(idlOp);
        ArgType crt = opType.getReturn();
        if (crt != null) {
            IdlType rt = this.findType(crt.getIdltype());
            idlOp.addReturnType(rt);
        }
        for (ParamType arg : opType.getParam()) {
            type = this.findType(arg.getIdltype());
            String mode = arg.getMode().value();
            IdlParam param = IdlParam.create(idlOp, arg.getName(), type, mode);
            idlOp.addParameter(param);
        }
        for (RaisesType rs : opType.getRaises()) {
            type = this.findType(rs.getException());
            if (type instanceof IdlException) {
                idlOp.addException((IdlException)type);
                continue;
            }
            String msgStr = type.fullName() + " is not a type.";
            Message msg = new Message(msgStr, LOG, new Object[0]);
            throw new Exception(msg.toString());
        }
        this.root.flush();
        this.intf.promoteHeldToScope();
    }

    private void getAllIdlTypes() throws Exception {
        try {
            TypeMappingType typeMappingType = this.getTypeMappingType();
            if (typeMappingType != null) {
                for (CorbaTypeImpl corbaTypeImpl : typeMappingType.getStructOrExceptionOrUnion()) {
                    this.findCorbaIdlType(corbaTypeImpl);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private CorbaTypeImpl getCorbaType(QName qname) throws Exception {
        CorbaTypeImpl corbaTypeImpl = null;
        try {
            TypeMappingType typeMappingType = this.getTypeMappingType();
            if (typeMappingType != null) {
                for (CorbaTypeImpl corbaType : typeMappingType.getStructOrExceptionOrUnion()) {
                    if (!corbaType.getName().equals(qname.getLocalPart())) continue;
                    return corbaType;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return corbaTypeImpl;
    }

    private TypeMappingType getTypeMappingType() {
        Iterator types = this.def.getExtensibilityElements().iterator();
        if (types != null && types.hasNext()) {
            return (TypeMappingType)types.next();
        }
        return null;
    }

    private IdlType findType(QName qname) throws Exception {
        String local = qname.getLocalPart();
        return this.findIdlType(local, qname, null);
    }

    private IdlType findCorbaIdlType(CorbaTypeImpl corbaTypeImpl) throws Exception {
        String local = corbaTypeImpl.getName();
        return this.findIdlType(local, corbaTypeImpl.getType(), corbaTypeImpl);
    }

    private IdlType findIdlType(String local, QName ntype, CorbaTypeImpl corbatypeImpl) throws Exception {
        IdlType idlType = null;
        if (ntype.getNamespaceURI().equals("http://cxf.apache.org/bindings/corba")) {
            try {
                idlType = this.createPrimitiveType(ntype, local);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            String[] name;
            IdlDefn defn;
            if (CorbaUtils.isTimeBaseDef(local)) {
                this.root.addInclude("<omg/TimeBase.idl>");
            }
            if ((defn = this.root.lookup(name = this.unscopeName(local))) != null) {
                if (defn instanceof IdlType) {
                    return (IdlType)defn;
                }
                String msgStr = local + " is an incorrect idltype.";
                Message msg = new Message(msgStr, LOG, new Object[0]);
                throw new Exception(msg.toString());
            }
            try {
                idlType = this.createType(ntype, name, corbatypeImpl);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return idlType;
    }

    protected IdlType createPrimitiveType(QName idlType, String name) throws Exception {
        IdlDefn result = this.root.lookup(name);
        if (result != null && !(result instanceof IdlType)) {
            String msgStr = idlType.getLocalPart() + " is an incorrect idltype.";
            Message msg = new Message(msgStr, LOG, new Object[0]);
            throw new Exception(msg.toString());
        }
        if (idlType.equals(CorbaConstants.NT_CORBA_DATETIME)) {
            this.root.addInclude("<omg/TimeBase.idl>");
        }
        return (IdlType)result;
    }

    protected IdlType createType(QName idlType, String[] name, CorbaTypeImpl corbaType) throws Exception {
        if (idlType.getLocalPart().equals("CORBA.Object")) {
            return IdlInterface.create(null, "Object");
        }
        CorbaTypeImpl corbaTypeImpl = corbaType;
        if (corbaTypeImpl == null) {
            corbaTypeImpl = this.getCorbaType(idlType);
        }
        if (corbaTypeImpl == null) {
            String msgStr = "Type " + idlType.getLocalPart() + " not found.";
            Message msg = new Message(msgStr, LOG, new Object[0]);
            throw new Exception(msg.toString());
        }
        IdlScopeBase scope = this.root;
        String dotScopedName = "";
        for (int i = 0; !(i >= name.length - 1 || "CORBA".equals(dotScopedName = dotScopedName + name[i]) && name.length == 2 && i == 0 && name[1].equals("Object")); ++i) {
            IdlDefn idlDef = scope.lookup(name[i]);
            if (idlDef == null) {
                QName qname = new QName(corbaTypeImpl.getType().getNamespaceURI(), dotScopedName);
                CorbaTypeImpl possibleCorbaType = this.getCorbaType(qname);
                if (possibleCorbaType != null) {
                    idlDef = this.findType(qname);
                }
                if (idlDef == null) {
                    idlDef = IdlModule.create(scope, name[i]);
                    scope.addToScope(idlDef);
                }
            }
            dotScopedName = dotScopedName + ".";
            scope = (IdlScopeBase)idlDef;
        }
        IdlType result = null;
        String local = name[name.length - 1];
        result = corbaTypeImpl instanceof Enum ? this.createEnum(corbaTypeImpl, scope, local) : (corbaTypeImpl instanceof Sequence ? this.createSequence(corbaTypeImpl, scope, local) : (corbaTypeImpl instanceof Anonsequence ? this.createAnonSequence(corbaTypeImpl, scope, local) : (corbaTypeImpl instanceof org.apache.cxf.binding.corba.wsdl.Exception ? this.createIdlException(corbaTypeImpl, scope, local) : (corbaTypeImpl instanceof Struct ? this.createStruct(corbaTypeImpl, scope, local) : (corbaTypeImpl instanceof Union ? this.createUnion(corbaTypeImpl, scope, local) : (corbaTypeImpl instanceof Alias ? this.createTypedef(corbaTypeImpl, scope, local) : (corbaTypeImpl instanceof Array ? this.createArray(corbaTypeImpl, scope, local) : (corbaTypeImpl instanceof Anonarray ? this.createAnonArray(corbaTypeImpl, scope, local) : (corbaTypeImpl instanceof Fixed ? this.createFixed(corbaTypeImpl, scope, local) : (corbaTypeImpl instanceof Anonfixed ? this.createAnonFixed(corbaTypeImpl, scope, local) : (corbaTypeImpl instanceof Const ? this.createConst(corbaTypeImpl, scope, local) : this.checkAnon(corbaTypeImpl, scope, local))))))))))));
        if (result == null && corbaTypeImpl instanceof Object) {
            result = this.createInterface(corbaTypeImpl, scope, local);
        }
        return result;
    }

    private IdlType checkAnon(CorbaTypeImpl corbaTypeImpl, IdlScopeBase scope, String local) throws Exception {
        IdlString result = null;
        if (corbaTypeImpl instanceof Anonstring) {
            Anonstring as = (Anonstring)corbaTypeImpl;
            Long lbound = as.getBound();
            int bound = lbound.intValue();
            result = IdlString.create(bound);
        }
        return result;
    }

    private IdlType createInterface(CorbaTypeImpl ctype, IdlScopeBase scope, String local) throws Exception {
        IdlInterface result = null;
        org.apache.cxf.binding.corba.wsdl.Object obj = (org.apache.cxf.binding.corba.wsdl.Object)ctype;
        QName bqname = obj.getBinding();
        Binding binding = this.def.getBinding(bqname);
        if (binding != null) {
            IdlDefn defn = scope.lookup(local);
            if (defn instanceof IdlInterface) {
                return (IdlInterface)defn;
            }
            if (defn == null) {
                try {
                    IdlInterface storedIntf = this.intf;
                    this.intf = IdlInterface.create(scope, local);
                    scope.holdForScope(this.intf);
                    this.collectIdlDefns(binding);
                    scope.promoteHeldToScope();
                    result = this.intf;
                    this.intf = storedIntf;
                }
                catch (Exception ex) {
                    String msgStr = "Interface type " + this.intf.fullName() + " not found.";
                    Message msg = new Message(msgStr, LOG, new Object[0]);
                    throw new Exception(msg.toString());
                }
            }
        }
        return result;
    }

    private IdlType createIdlException(CorbaTypeImpl ctype, IdlScopeBase scope, String local) throws Exception {
        IdlType result = null;
        org.apache.cxf.binding.corba.wsdl.Exception e = (org.apache.cxf.binding.corba.wsdl.Exception)ctype;
        IdlDefn obj = scope.lookup(local);
        if (obj != null && obj instanceof IdlException) {
            result = (IdlType)obj;
        } else {
            IdlException exc = IdlException.create(scope, local);
            scope.holdForScope(exc);
            for (MemberType m : e.getMember()) {
                QName qname = m.getIdltype();
                IdlType type = this.findType(qname);
                exc.addToScope(IdlField.create(exc, m.getName(), type));
            }
            result = exc;
            scope.promoteHeldToScope();
        }
        return result;
    }

    private IdlType createUnion(CorbaTypeImpl ctype, IdlScopeBase scope, String local) throws Exception {
        Union u = (Union)ctype;
        boolean undefinedCircular = false;
        IdlType disc = this.findType(u.getDiscriminator());
        IdlUnion union = IdlUnion.create(scope, local, disc);
        scope.holdForScope(union);
        for (Unionbranch ub : u.getUnionbranch()) {
            QName qname = ub.getIdltype();
            IdlType bt = this.findType(qname);
            boolean isDefault = false;
            if (ub.isSetDefault()) {
                isDefault = ub.isDefault();
            }
            IdlUnionBranch b = IdlUnionBranch.create(union, ub.getName(), bt, isDefault);
            for (CaseType cs : ub.getCase()) {
                b.addCase(cs.getLabel());
            }
            if (!undefinedCircular && !(bt instanceof IdlSequence)) {
                String mlocal = qname.getLocalPart();
                String[] mname = this.unscopeName(mlocal);
                undefinedCircular = null != this.root.lookup(mname, true);
            }
            union.addBranch(b);
        }
        if (undefinedCircular) {
            scope.parkHeld();
        } else {
            scope.promoteHeldToScope();
            if (union.isCircular()) {
                scope.flush();
            }
        }
        return union;
    }

    private IdlType createStruct(CorbaTypeImpl ctype, IdlScopeBase scope, String local) throws Exception {
        Struct s = (Struct)ctype;
        boolean undefinedCircular = false;
        IdlStruct struct = IdlStruct.create(scope, local);
        scope.holdForScope(struct);
        for (MemberType m : s.getMember()) {
            QName qname = m.getIdltype();
            IdlType type = this.findType(qname);
            if (!undefinedCircular && !(type instanceof IdlSequence)) {
                String mlocal = qname.getLocalPart();
                String[] mname = this.unscopeName(mlocal);
                undefinedCircular = null != this.root.lookup(mname, true);
            }
            struct.addToScope(IdlField.create(struct, m.getName(), type));
        }
        if (undefinedCircular) {
            scope.parkHeld();
        } else {
            scope.promoteHeldToScope();
            if (struct.isCircular()) {
                scope.flush();
            }
        }
        return struct;
    }

    private IdlType createTypedef(CorbaTypeImpl ctype, IdlScopeBase scope, String local) throws Exception {
        IdlTypedef idlType = null;
        Alias a = (Alias)ctype;
        IdlType base = this.findType(a.getBasetype());
        idlType = IdlTypedef.create(scope, local, base);
        scope.addToScope(idlType);
        return idlType;
    }

    private IdlType createConst(CorbaTypeImpl ctype, IdlScopeBase scope, String local) throws Exception {
        IdlConst idlType = null;
        Const c = (Const)ctype;
        IdlType base = this.findType(c.getIdltype());
        String value = c.getValue();
        idlType = IdlConst.create(scope, local, base, value);
        scope.addToScope(idlType);
        return idlType;
    }

    private IdlType createSequence(CorbaTypeImpl ctype, IdlScopeBase scope, String local) throws Exception {
        IdlSequence idlType = null;
        Sequence s = (Sequence)ctype;
        IdlType base = this.findType(s.getElemtype());
        int bound = (int)s.getBound();
        idlType = IdlSequence.create(scope, local, base, bound);
        scope.addToScope(idlType);
        return idlType;
    }

    private IdlType createAnonSequence(CorbaTypeImpl ctype, IdlScopeBase scope, String local) throws Exception {
        IdlAnonSequence idlType = null;
        Anonsequence s = (Anonsequence)ctype;
        IdlType base = this.findType(s.getElemtype());
        int bound = (int)s.getBound();
        idlType = IdlAnonSequence.create(scope, base, bound);
        scope.addToScope(idlType);
        return idlType;
    }

    private IdlType createArray(CorbaTypeImpl ctype, IdlScopeBase scope, String local) throws Exception {
        IdlArray idlType = null;
        Array s = (Array)ctype;
        IdlType base = this.findType(s.getElemtype());
        int bound = (int)s.getBound();
        idlType = IdlArray.create(scope, local, base, bound);
        scope.addToScope(idlType);
        return idlType;
    }

    private IdlType createAnonArray(CorbaTypeImpl ctype, IdlScopeBase scope, String local) throws Exception {
        IdlAnonArray idlType = null;
        Anonarray s = (Anonarray)ctype;
        IdlType base = this.findType(s.getElemtype());
        int bound = (int)s.getBound();
        idlType = IdlAnonArray.create(scope, base, bound);
        scope.addToScope(idlType);
        return idlType;
    }

    private IdlType createFixed(CorbaTypeImpl ctype, IdlScopeBase scope, String local) {
        IdlFixed idlType = null;
        Fixed f = (Fixed)ctype;
        Long digits = f.getDigits();
        Long scale = f.getScale();
        idlType = IdlFixed.create(scope, local, digits.intValue(), scale.intValue());
        scope.addToScope(idlType);
        return idlType;
    }

    private IdlType createAnonFixed(CorbaTypeImpl ctype, IdlScopeBase scope, String local) {
        IdlAnonFixed idlType = null;
        Anonfixed f = (Anonfixed)ctype;
        Long digits = f.getDigits();
        Long scale = f.getScale();
        idlType = IdlAnonFixed.create(scope, digits.intValue(), scale.intValue());
        scope.addToScope(idlType);
        return idlType;
    }

    private IdlType createEnum(CorbaTypeImpl ctype, IdlScopeBase scope, String local) {
        Enum e = (Enum)ctype;
        IdlEnum enum1 = IdlEnum.create(scope, local);
        Iterator<Enumerator> it = e.getEnumerator().iterator();
        while (it.hasNext()) {
            String n = it.next().getValue();
            IdlEnumerator enumerator = IdlEnumerator.create(scope, n);
            scope.addToScope(enumerator);
            enum1.addEnumerator(enumerator);
        }
        scope.addToScope(enum1);
        return enum1;
    }

    private PrintWriter createPrintWriter(String filename) throws Exception {
        OutputStream out = this.factory.createOutputStream(filename);
        return new PrintWriter(out);
    }

    public void setOutputDirectory(String dir) {
        File fileOutputDir;
        if (dir != null && !(fileOutputDir = new File(dir)).exists()) {
            fileOutputDir.mkdir();
        }
        this.factory = new FileOutputStreamFactory(dir);
    }

    private Binding findBinding(Definition definition) {
        Binding binding = null;
        Collection<Binding> bindings = CastUtils.cast(definition.getBindings().values());
        if (bindingName != null) {
            for (Binding b : bindings) {
                binding = b;
                if (!binding.getQName().getLocalPart().equals(bindingName)) continue;
                return binding;
            }
        } else if (bindings.size() >= 1) {
            binding = bindings.iterator().next();
        }
        return binding;
    }

    private String[] unscopeName(String nm) {
        StringTokenizer strtok = new StringTokenizer(nm, ".");
        String[] result = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            result[i] = new String(strtok.nextToken());
            ++i;
        }
        return result;
    }

    public void setOutputFile(String file) {
        this.outputFile = file;
    }

    public void setPrintWriter(PrintWriter pw) {
        this.printWriter = pw;
    }

    public void setWsdlFile(String file) {
        wsdlFileName = new String(file);
    }

    public void setVerboseOn(boolean verbose) {
        this.verboseOn = verbose;
    }

    public boolean isVerboseOn() {
        return this.verboseOn;
    }

    public void setBindingName(String bindName) {
        bindingName = new String(bindName);
    }

    public String getBindingName() {
        return bindingName;
    }

    public void setNamespace(String namespaceName) {
        namespace = new String(namespaceName);
    }

    public String getNamespace() {
        return namespace;
    }

    public void setGenerateAllBindings(boolean all) {
        this.generateAllBindings = all;
    }

    public boolean isGenerateAllBindings() {
        return this.generateAllBindings;
    }
}

