/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSS4JOutInterceptor
extends AbstractWSS4JInterceptor {
    public static final String WSS4J_ACTION_MAP = "wss4j.action.map";
    private static final Logger LOG = LogUtils.getL7dLogger(WSS4JOutInterceptor.class);
    private static final Logger TIME_LOG = LogUtils.getL7dLogger(WSS4JOutInterceptor.class, null, WSS4JOutInterceptor.class.getName() + "-Time");
    private WSS4JOutInterceptorInternal ending;
    private SAAJOutInterceptor saajOut = new SAAJOutInterceptor();
    private boolean mtomEnabled;

    public WSS4JOutInterceptor() {
        this.setPhase("pre-protocol");
        this.getAfter().add(SAAJOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
    }

    public WSS4JOutInterceptor(Map<String, Object> props) {
        this();
        this.setProperties(props);
    }

    public boolean isAllowMTOM() {
        return this.mtomEnabled;
    }

    public void setAllowMTOM(boolean allowMTOM) {
        this.mtomEnabled = allowMTOM;
    }

    @Override
    public Object getProperty(Object msgContext, String key) {
        Object result = super.getProperty(msgContext, key);
        if (result == null && "RECV_RESULTS".equals(key) && !this.isRequestor((SoapMessage)msgContext)) {
            result = ((SoapMessage)msgContext).getExchange().getInMessage().get(key);
        }
        return result;
    }

    @Override
    public void handleMessage(SoapMessage mc) throws Fault {
        if (!this.mtomEnabled) {
            mc.put("mtom-enabled", (Object)false);
        }
        if (mc.getContent(SOAPMessage.class) == null) {
            this.saajOut.handleMessage(mc);
        }
        mc.getInterceptorChain().add(this.ending);
    }

    @Override
    public void handleFault(SoapMessage message) {
        this.saajOut.handleFault(message);
    }

    public final WSS4JOutInterceptorInternal createEndingInterceptor() {
        return new WSS4JOutInterceptorInternal();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class WSS4JOutInterceptorInternal
    implements PhaseInterceptor<SoapMessage> {
        @Override
        public void handleMessage(SoapMessage mc) throws Fault {
            boolean doDebug = LOG.isLoggable(Level.FINE);
            boolean doTimeDebug = TIME_LOG.isLoggable(Level.FINE);
            long t0 = 0L;
            long t1 = 0L;
            long t2 = 0L;
            if (doTimeDebug) {
                t0 = System.currentTimeMillis();
            }
            if (doDebug) {
                LOG.fine("WSS4JOutInterceptor: enter handleMessage()");
            }
            if (mc == null) {
                return;
            }
            SoapVersion version = mc.getVersion();
            RequestData reqData = new RequestData();
            WSS4JOutInterceptor.this.translateProperties(mc);
            reqData.setMsgContext((Object)mc);
            try {
                SOAPMessage saaj;
                String username;
                WSSConfig config = WSSConfig.getNewInstance();
                reqData.setWssConfig(config);
                this.configureActions(mc, doDebug, version, config);
                ArrayList actions = new ArrayList();
                String action = WSS4JOutInterceptor.this.getString("action", mc);
                if (action == null) {
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("NO_ACTION", LOG, new Object[0]), version.getReceiver());
                }
                int doAction = WSSecurityUtil.decodeAction((String)action, actions, (WSSConfig)config);
                if (doAction == 0 && actions.isEmpty()) {
                    return;
                }
                reqData.setUsername((String)WSS4JOutInterceptor.this.getOption("user"));
                if ((reqData.getUsername() == null || reqData.getUsername().equals("")) && (username = (String)WSS4JOutInterceptor.this.getProperty(reqData.getMsgContext(), "user")) != null) {
                    reqData.setUsername(username);
                }
                if ((doAction & 0x43) != 0 && (reqData.getUsername() == null || reqData.getUsername().equals(""))) {
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("NO_USERNAME", LOG, new Object[0]), version.getReceiver());
                }
                if (doDebug) {
                    LOG.fine("Action: " + doAction);
                    LOG.fine("Actor: " + reqData.getActor());
                }
                if ((saaj = mc.getContent(SOAPMessage.class)) == null) {
                    LOG.warning("SAAJOutHandler must be enabled for WS-Security!");
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("NO_SAAJ_DOC", LOG, new Object[0]), version.getReceiver());
                }
                SOAPPart doc = saaj.getSOAPPart();
                if (doTimeDebug) {
                    t1 = System.currentTimeMillis();
                }
                WSS4JOutInterceptor.this.doSenderAction(doAction, (Document)doc, reqData, actions, Boolean.TRUE.equals(WSS4JOutInterceptor.this.getProperty(mc, "org.apache.cxf.client")));
                if (doTimeDebug) {
                    t2 = System.currentTimeMillis();
                    TIME_LOG.fine("Send request: total= " + (t2 - t0) + " request preparation= " + (t1 - t0) + " request processing= " + (t2 - t1) + "\n");
                }
                if (doDebug) {
                    LOG.fine("WSS4JOutInterceptor: exit handleMessage()");
                }
            }
            catch (WSSecurityException e) {
                throw new SoapFault(new org.apache.cxf.common.i18n.Message("SECURITY_FAILED", LOG, new Object[0]), (Throwable)e, version.getSender());
            }
            finally {
                reqData.clear();
                reqData = null;
            }
        }

        @Override
        public Set<String> getAfter() {
            return Collections.emptySet();
        }

        @Override
        public Set<String> getBefore() {
            return Collections.emptySet();
        }

        @Override
        public String getId() {
            return WSS4JOutInterceptorInternal.class.getName();
        }

        @Override
        public String getPhase() {
            return "post-protocol";
        }

        @Override
        public void handleFault(SoapMessage message) {
        }

        private void configureActions(SoapMessage mc, boolean doDebug, SoapVersion version, WSSConfig config) {
            Map actionMap = CastUtils.cast((Map)WSS4JOutInterceptor.this.getProperty(mc, WSS4JOutInterceptor.WSS4J_ACTION_MAP));
            if (actionMap != null) {
                for (Map.Entry entry : actionMap.entrySet()) {
                    Class removedAction;
                    block7: {
                        removedAction = null;
                        try {
                            if (entry.getValue() instanceof Class) {
                                removedAction = config.setAction(((Integer)entry.getKey()).intValue(), (Class)entry.getValue());
                                break block7;
                            }
                            if (entry.getValue() instanceof Action) {
                                removedAction = config.setAction(((Integer)entry.getKey()).intValue(), (Action)entry.getValue());
                                break block7;
                            }
                            throw new SoapFault(new org.apache.cxf.common.i18n.Message("BAD_ACTION", LOG, new Object[0]), version.getReceiver());
                        }
                        catch (ClassCastException e) {
                            throw new SoapFault(new org.apache.cxf.common.i18n.Message("BAD_ACTION", LOG, new Object[0]), version.getReceiver());
                        }
                    }
                    if (!doDebug) continue;
                    if (removedAction != null) {
                        LOG.fine("Replaced Action: " + removedAction.getName() + " with Action: " + entry.getValue() + " for ID: " + entry.getKey());
                        continue;
                    }
                    LOG.fine("Added Action: " + entry.getValue() + " with ID: " + entry.getKey());
                }
            }
        }

        @Override
        public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
            return null;
        }
    }
}

