/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cdi.weld.internal.tomcat;

import java.util.EnumSet;
import javax.decorator.Decorator;
import javax.el.ELContextListener;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ViewHandler;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.inject.Inject;
import javax.interceptor.Interceptor;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.InstanceManager;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.el.WeldELContextListener;
import org.jboss.weld.environment.servlet.Listener;
import org.jboss.weld.environment.servlet.deployment.ServletDeployment;
import org.jboss.weld.environment.servlet.deployment.URLScanner;
import org.jboss.weld.environment.tomcat7.WeldForwardingInstanceManager;
import org.jboss.weld.environment.tomcat7.WeldInstanceManager;
import org.jboss.weld.jsf.ConversationAwareViewHandler;
import org.jboss.weld.jsf.WeldPhaseListener;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.resources.ClassLoaderResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.servlet.ConversationPropagationFilter;
import org.ow2.util.execution.ExecutionResult;
import org.ow2.util.execution.IExecution;
import org.ow2.util.execution.helper.RunnableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class WeldLifeCycleListener
implements LifecycleListener {
    private static Log logger = LogFactory.getLog(WeldLifeCycleListener.class);
    private WeldManager manager;
    private Bootstrap bootstrap;
    private ClassLoader webappClassLoader;

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getLifecycle() instanceof StandardContext) {
            StandardContext context = (StandardContext)event.getLifecycle();
            if ("configure_start".equals(event.getType())) {
                this.configureStart(context);
            } else if ("after_start".equals(event.getType())) {
                this.afterStart(context);
            } else if ("after_stop".equals(event.getType())) {
                this.afterStop(context);
            }
        }
    }

    private void afterStart(StandardContext context) {
        IExecution<Void> execution = new IExecution<Void>(){

            public Void execute() throws Exception {
                LifecycleFactory factory;
                ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
                Application application = applicationFactory.getApplication();
                if (application != null) {
                    ViewHandler currentHandler = application.getViewHandler();
                    application.setViewHandler((ViewHandler)new ConversationAwareViewHandler(currentHandler));
                }
                if ((factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory")) != null) {
                    Lifecycle lc = factory.getLifecycle("DEFAULT");
                    lc.addPhaseListener((PhaseListener)new WeldPhaseListener());
                }
                return null;
            }
        };
        ExecutionResult result = new RunnableHelper().execute(this.webappClassLoader, (IExecution)execution);
        if (result.hasException()) {
            logger.debug((Object)"The current Webapp {0} is not JSF-enabled", new Object[]{context.getName(), result.getException()});
        }
    }

    private void afterStop(StandardContext context) {
        if (this.bootstrap != null) {
            logger.debug((Object)"Stop Weld container for ''{0}'' ...", new Object[]{context.getName()});
            this.bootstrap.shutdown();
        }
    }

    private void configureStart(StandardContext context) {
        logger.debug((Object)"Start Weld container for ''{0}'' ...", new Object[]{context.getName()});
        this.bootstrap = new WeldBootstrap();
        ServletContext servletContext = context.getServletContext();
        URLScanner scanner = new URLScanner(context.getLoader().getClassLoader());
        servletContext.setAttribute(URLScanner.class.getName(), (Object)scanner);
        ServletDeployment deployment = new ServletDeployment(servletContext, this.bootstrap);
        this.webappClassLoader = context.getLoader().getClassLoader();
        deployment.getServices().add(ResourceLoader.class, (Service)new ClassLoaderResourceLoader(this.webappClassLoader));
        this.performUglyClassLoaderHack(this.webappClassLoader);
        this.bootstrap.startContainer((Environment)Environments.SERVLET, (Deployment)deployment);
        this.bootstrap.startInitialization();
        this.manager = this.bootstrap.getManager((BeanDeploymentArchive)deployment.getWebAppBeanDeploymentArchive());
        servletContext.setAttribute(Listener.BEAN_MANAGER_ATTRIBUTE_NAME, (Object)this.manager);
        this.registerFilters(servletContext);
        this.configureJsp(servletContext);
        this.bindBeanManager(context);
        this.wrapInstanceManager(context);
        this.bootstrap.deployBeans();
        this.bootstrap.validateBeans();
        this.bootstrap.endInitialization();
    }

    private void configureJsp(ServletContext servletContext) {
        JspFactory jspFactory = JspFactory.getDefaultFactory();
        if (jspFactory != null) {
            JspApplicationContext jspApplicationContext = jspFactory.getJspApplicationContext(servletContext);
            jspApplicationContext.addELResolver(this.manager.getELResolver());
            jspApplicationContext.addELContextListener((ELContextListener)new WeldELContextListener());
        }
    }

    private void registerFilters(ServletContext servletContext) {
        FilterRegistration.Dynamic registration = servletContext.addFilter("ConversationPropagationFilter", (Filter)new ConversationPropagationFilter());
        registration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
    }

    private void wrapInstanceManager(StandardContext context) {
        InstanceManager original = context.getInstanceManager();
        WeldInstanceManager2 weldInstanceManager = new WeldInstanceManager2(this.manager);
        context.setInstanceManager((InstanceManager)new WeldForwardingInstanceManager(original, weldInstanceManager));
    }

    private void bindBeanManager(StandardContext context) {
        try {
            InitialContext initialContext = new InitialContext();
            initialContext.rebind("java:comp/BeanManager", (Object)this.manager);
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to register BeanManager into JNDI.", new Object[]{e});
            context.setConfigured(false);
        }
    }

    private void performUglyClassLoaderHack(ClassLoader loader) {
        try {
            loader.loadClass("org.jboss.interceptor.util.proxy.TargetInstanceProxy");
            loader.loadClass("javassist.util.proxy.ProxyObject");
            loader.loadClass(Decorator.class.getName());
            loader.loadClass(Inject.class.getName());
            loader.loadClass(Interceptor.class.getName());
            loader.loadClass(InjectionPoint.class.getName());
        }
        catch (ClassNotFoundException e) {
            logger.debug((Object)"Cannot load a class from {0}", new Object[]{loader, e});
        }
    }

    private static class WeldInstanceManager2
    extends WeldInstanceManager {
        public WeldInstanceManager2(WeldManager manager) {
            super(manager);
        }
    }
}

