/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.audit.internal.webauditor.filters;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.modelmbean.ModelMBeanNotificationBroadcaster;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ow2.jonas.audit.internal.webauditor.report.WebInvocationAuditReportFactory;
import org.ow2.util.auditreport.api.IAuditID;
import org.ow2.util.auditreport.api.ICurrentInvocationID;
import org.ow2.util.auditreport.impl.AuditIDImpl;
import org.ow2.util.auditreport.impl.CurrentInvocationID;
import org.ow2.util.auditreport.impl.GenericAuditReport;
import org.ow2.util.auditreport.impl.InvocationAuditReport;
import org.ow2.util.auditreport.impl.JNDIAuditReport;
import org.ow2.util.auditreport.impl.JaxwsAuditReport;
import org.ow2.util.auditreport.impl.WebInvocationAuditReport;
import org.ow2.util.auditreport.impl.event.Event;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventService;
import org.ow2.util.event.impl.EventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class HttpAuditFilter
implements Filter {
    private static Log logger = LogFactory.getLog(HttpAuditFilter.class);
    public static final String HEADER_INVOCATION_ID = "Invocation-ID";
    private FilterConfig filterConfig = null;
    private long seqNumber = 0L;
    private List<String> filters = new ArrayList<String>();
    private WebInvocationAuditReportFactory webInvocationAuditReportFactory = null;
    private IEventService eventService = null;
    private ModelMBeanNotificationBroadcaster broadcaster = null;

    public HttpAuditFilter(MBeanServer jmxServer) {
        this(jmxServer, null);
    }

    public HttpAuditFilter(MBeanServer jmxServer, IEventService eventService) {
        this.eventService = eventService;
        this.webInvocationAuditReportFactory = new WebInvocationAuditReportFactory(jmxServer);
        this.filters.add("graniteamf");
        this.filters.add(".png");
        this.filters.add(".jpeg");
        this.filters.add(".jpg");
        this.filters.add(".gif");
        this.filters.add(".css");
        this.filters.add(".bmp");
        this.filters.add(".ico");
    }

    private boolean uriFilter(String uri) {
        boolean ret = false;
        for (String elem : this.filters) {
            if (!uri.contains(elem)) continue;
            ret = true;
        }
        return ret;
    }

    private WebInvocationAuditReport doBeforeProcessing(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)request;
        ICurrentInvocationID current = CurrentInvocationID.getInstance();
        String invocationId = hreq.getHeader(HEADER_INVOCATION_ID);
        if (invocationId != null) {
            AuditIDImpl id = new AuditIDImpl(invocationId);
            current.setAuditID((IAuditID)id);
        } else {
            current.init(null);
        }
        ++this.seqNumber;
        return this.webInvocationAuditReportFactory.prepareAuditReport(this.seqNumber, System.currentTimeMillis(), System.nanoTime(), Thread.currentThread(), "web", hreq);
    }

    private void doAfterProcessing(ServletRequest request, HttpServletResponse response, WebInvocationAuditReport report) throws IOException, ServletException {
        CurrentInvocationID.getInstance().setAuditID(null);
        try {
            Integer i;
            int status = -1;
            Method m = response.getClass().getMethod("getStatus", new Class[0]);
            if (m != null && (i = (Integer)m.invoke((Object)response, new Object[0])) != null) {
                status = i;
            }
            if (this.eventService.getDispatcher("WEB") == null) {
                EventDispatcher d = new EventDispatcher();
                d.setNbWorkers(2);
                d.start();
                this.eventService.registerDispatcher("WEB", (IEventDispatcher)d);
            }
            if (report != null) {
                this.webInvocationAuditReportFactory.completeAuditReport(report, System.nanoTime(), response.getContentType());
                report.setStatus(status);
                Event e = new Event((GenericAuditReport)report);
                this.sendEvent((IEvent)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to make a report", new Object[]{e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.uriFilter(((HttpServletRequest)request).getRequestURI())) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        WebInvocationAuditReport report = this.doBeforeProcessing(request, (ServletResponse)httpServletResponse);
        try {
            chain.doFilter(request, (ServletResponse)httpServletResponse);
        }
        finally {
            this.doAfterProcessing(request, httpServletResponse, report);
        }
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "SimpleFilter()";
        }
        StringBuffer sb = new StringBuffer("SimpleFilter(");
        sb.append(this.filterConfig);
        sb.append(")");
        return sb.toString();
    }

    public static String getStackTrace(Throwable t) {
        String stackTrace = null;
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            sw.close();
            stackTrace = sw.getBuffer().toString();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        return stackTrace;
    }

    public void log(String msg) {
        this.filterConfig.getServletContext().log(msg);
    }

    public void sendEvent(IEvent e) {
        GenericAuditReport report = ((Event)e).getReport();
        if (report instanceof WebInvocationAuditReport) {
            this.eventService.getDispatcher("WEB").dispatch(e);
        } else if (report instanceof InvocationAuditReport) {
            this.eventService.getDispatcher("EJB").dispatch(e);
        } else if (report instanceof JNDIAuditReport) {
            this.eventService.getDispatcher("JNDI").dispatch(e);
        } else if (report instanceof JaxwsAuditReport) {
            this.eventService.getDispatcher("JAXWS").dispatch(e);
        } else {
            logger.error((Object)"Not be able to dispatch event correctly on dispatchers.The event is unknown therefore don't dispatch", new Object[0]);
        }
    }

    public void setBroadcaster(ModelMBeanNotificationBroadcaster broadcaster) {
        this.broadcaster = broadcaster;
    }
}

