/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container;

import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import org.ow2.easybeans.api.EZBContainerConfig;
import org.ow2.easybeans.api.EZBContainerLifeCycleCallback;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.injection.ResourceInjector;
import org.ow2.easybeans.api.naming.EZBNamingStrategy;
import org.ow2.easybeans.naming.strategy.JavaEE6NamingStrategy;
import org.ow2.easybeans.resolver.ContainerJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JContainerConfig
implements EZBContainerConfig {
    private IDeployable<?> deployable;
    private EZBServer embedded;
    private List<EZBContainerLifeCycleCallback> callbacks;
    private List<ResourceInjector> injectors;
    private List<EZBNamingStrategy> namingStrategies = new ArrayList<EZBNamingStrategy>();
    private EZBContainerJNDIResolver containerJNDIResolver = null;
    private String moduleName = null;
    private String applicationName = null;
    private Context moduleContext = null;
    private Context appContext = null;
    private Context compEnvContext = null;

    public JContainerConfig(IDeployable<?> deployable) {
        this.deployable = deployable;
        this.containerJNDIResolver = new ContainerJNDIResolver(deployable.getArchive());
        this.callbacks = new ArrayList<EZBContainerLifeCycleCallback>();
        this.injectors = new ArrayList<ResourceInjector>();
    }

    public List<EZBContainerLifeCycleCallback> getCallbacks() {
        return this.callbacks;
    }

    public void addCallback(EZBContainerLifeCycleCallback callback) {
        this.callbacks.add(callback);
    }

    public IDeployable<?> getDeployable() {
        return this.deployable;
    }

    public IArchive getArchive() {
        return this.deployable.getArchive();
    }

    public List<ResourceInjector> getInjectors() {
        return this.injectors;
    }

    public void addInjectors(ResourceInjector injector) {
        this.injectors.add(injector);
    }

    public EZBServer getEZBServer() {
        return this.embedded;
    }

    public void setEZBServer(EZBServer embedded) {
        this.embedded = embedded;
    }

    public List<EZBNamingStrategy> getNamingStrategies() {
        if (this.namingStrategies.isEmpty()) {
            this.namingStrategies.add(new JavaEE6NamingStrategy());
        }
        return this.namingStrategies;
    }

    public void setNamingStrategies(List<EZBNamingStrategy> namingStrategies) {
        this.namingStrategies = namingStrategies;
    }

    public EZBContainerJNDIResolver getContainerJNDIResolver() {
        return this.containerJNDIResolver;
    }

    public void setContainerJNDIResolver(EZBContainerJNDIResolver containerJNDIResolver) {
        this.containerJNDIResolver = containerJNDIResolver;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Context getModuleContext() {
        return this.moduleContext;
    }

    public void setModuleContext(Context moduleContext) {
        this.moduleContext = moduleContext;
    }

    public Context getAppContext() {
        return this.appContext;
    }

    public void setAppContext(Context appContext) {
        this.appContext = appContext;
    }

    public Context getEnvContext() {
        return this.compEnvContext;
    }

    public void setEnvContext(Context compEnvContext) {
        this.compEnvContext = compEnvContext;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }
}

