/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.deployer.AbsDeployer;
import org.ow2.easybeans.deployment.InjectionHolder;
import org.ow2.easybeans.deployment.api.EZBInjectionHolder;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.easybeans.persistence.PersistenceUnitManager;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.easybeans.resolver.ApplicationJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBApplicationJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.easybeans.util.url.URLUtils;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.LibDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsWebContainerDeployer<T extends IDeployable<T>>
extends AbsDeployer<T> {
    private static Log logger = LogFactory.getLog(AbsWebContainerDeployer.class);

    protected abstract void deployWARs(EARDeployable var1, URL var2, ClassLoader var3, ClassLoader var4, EZBInjectionHolder var5) throws DeployerException;

    protected void deployEAR(EARDeployable earDeployable) throws DeployerException {
        logger.info((Object)"Deploying {0}", new Object[]{earDeployable});
        URL earURL = null;
        try {
            earURL = earDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL for the deployable '" + earDeployable + "'.", (Throwable)e);
        }
        URLClassLoader earClassLoader = new URLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader());
        List ejb3s = earDeployable.getEJB3Deployables();
        ArrayList<URL> urlsEJB = new ArrayList<URL>();
        for (EJB3Deployable ejb : ejb3s) {
            try {
                urlsEJB.add(ejb.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the archive '" + ejb.getArchive() + "'", (Throwable)e);
            }
        }
        ArrayList<URL> urlsWAR = new ArrayList<URL>();
        for (WARDeployable war : earDeployable.getWARDeployables()) {
            try {
                urlsWAR.add(war.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the archive '" + war.getArchive() + "'", (Throwable)e);
            }
        }
        ArrayList<URL> urlsClient = new ArrayList<URL>();
        for (CARDeployable car : earDeployable.getCARDeployables()) {
            try {
                urlsClient.add(car.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the archive '" + car.getArchive() + "'", (Throwable)e);
            }
        }
        List libs = earDeployable.getLibDeployables();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (EJB3Deployable ejb : ejb3s) {
            try {
                urls.add(ejb.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + ejb.getArchive() + "'.", (Throwable)e);
            }
        }
        for (LibDeployable lib : libs) {
            try {
                urls.add(lib.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + lib.getArchive() + "'.", (Throwable)e);
            }
        }
        URL[] arrayURLs = urls.toArray(new URL[urls.size()]);
        EasyBeansClassLoader ejbClassLoader = new EasyBeansClassLoader(arrayURLs, Thread.currentThread().getContextClassLoader());
        PersistenceUnitManager persistenceUnitManager = this.getPersistenceUnitManager(earDeployable, ejbClassLoader);
        List<IArchive> libArchives = this.getLibArchives(earDeployable);
        ArrayList<EZBContainer> containers = new ArrayList<EZBContainer>();
        for (EJB3Deployable ejb : ejb3s) {
            containers.add(this.getEmbedded().createContainer((IDeployable)ejb));
        }
        ApplicationJNDIResolver applicationJNDIResolver = new ApplicationJNDIResolver();
        InjectionHolder ejbInjectionHolder = new InjectionHolder();
        ejbInjectionHolder.setPersistenceUnitManager(persistenceUnitManager);
        ejbInjectionHolder.setJNDIResolver(applicationJNDIResolver);
        for (EZBContainer container : containers) {
            container.setClassLoader((ClassLoader)ejbClassLoader);
            container.getConfiguration().setApplicationName(earDeployable.getModuleName());
            container.setPersistenceUnitManager((EZBPersistenceUnitManager)persistenceUnitManager);
            container.setExtraArchives(libArchives);
            EZBContainerJNDIResolver containerJNDIResolver = container.getConfiguration().getContainerJNDIResolver();
            containerJNDIResolver.setApplicationJNDIResolver((EZBApplicationJNDIResolver)applicationJNDIResolver);
            applicationJNDIResolver.addContainerJNDIResolver(containerJNDIResolver);
            try {
                container.resolve();
            }
            catch (EZBContainerException e) {
                throw new DeployerException("Cannot resolve the container '" + container.getArchive() + "'.", (Throwable)e);
            }
        }
        for (EZBContainer container : containers) {
            try {
                container.start();
            }
            catch (EZBContainerException e) {
                logger.error((Object)"Cannot start container {0}", new Object[]{container.getName(), e});
            }
        }
        this.deployWARs(earDeployable, earURL, earClassLoader, ejbClassLoader, ejbInjectionHolder);
    }

    protected void undeployEAR(EARDeployable tmpEARDeployable) throws DeployerException {
        List wars;
        logger.info((Object)"Undeploying {0}", new Object[]{tmpEARDeployable});
        EARDeployable earDeployable = tmpEARDeployable;
        EARDeployable unpackedDeployable = (EARDeployable)earDeployable.getUnpackedDeployable();
        if (unpackedDeployable != null) {
            earDeployable = unpackedDeployable;
        }
        if ((wars = earDeployable.getWARDeployables()) != null) {
            for (WARDeployable war : wars) {
                try {
                    this.undeployWAR(war);
                }
                catch (DeployerException e) {
                    logger.error((Object)"Cannot undeploy the WAR deployable ''{0}''", new Object[]{war, e});
                }
            }
        }
        this.undeployEJB3FromEAR(earDeployable);
        logger.info((Object)"''{0}'' EAR Deployable is now undeployed", new Object[]{tmpEARDeployable});
    }

    public void undeploy(IDeployable<T> deployable) throws DeployerException {
        if (!EARDeployable.class.isAssignableFrom(deployable.getClass())) {
            throw new UnsupportedOperationException("Undeploy only .ear files");
        }
        this.undeployEAR((EARDeployable)EARDeployable.class.cast(deployable));
    }

    protected abstract void undeployWAR(WARDeployable var1) throws DeployerException;

    protected File unpack(File warFile, WARDeployable war, URL earURL) throws DeployerException {
        JarFile packedJar;
        String earName = URLUtils.urlToFile(earURL).getName();
        String rootUnpackDir = System.getProperty("java.io.tmpdir") + File.separator + System.getProperty("user.name") + "-EasyBeans-unpack" + File.separator;
        File unpackDir = new File(rootUnpackDir, earName + File.separator + warFile.getName());
        try {
            packedJar = new JarFile(warFile);
        }
        catch (IOException e) {
            throw new DeployerException("The war file '" + warFile + "' is not a valid war file", (Throwable)e);
        }
        try {
            FileUtils.unpack((JarFile)packedJar, (File)unpackDir);
        }
        catch (FileUtilsException e) {
            throw new DeployerException("Cannot unpack the file '" + packedJar + "' in the directory '" + unpackDir + "'.", (Throwable)e);
        }
        return unpackDir;
    }

    public void deploy(IDeployable<T> deployable) throws DeployerException {
        this.checkSupportedDeployable(deployable);
        if (deployable instanceof EJBDeployable) {
            this.deployEJB((EJBDeployable)deployable);
        } else if (EARDeployable.class.isAssignableFrom(deployable.getClass())) {
            EARDeployable earDeployable = this.unpackEARDeployable((EARDeployable)EARDeployable.class.cast(deployable));
            this.deployEAR(earDeployable);
        }
    }

    private void checkSupportedDeployable(IDeployable<?> deployable) throws DeployerException {
        if (!EARDeployable.class.isAssignableFrom(deployable.getClass()) && !EJBDeployable.class.isAssignableFrom(deployable.getClass())) {
            throw new DeployerException("The deployable '" + deployable + "' is not supported by this deployer");
        }
    }
}

