/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.ejb.Remove;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.container.session.stateful.interceptors.RemoveAlwaysInterceptor;
import org.ow2.easybeans.container.session.stateful.interceptors.RemoveOnlyWithoutExceptionInterceptor;
import org.ow2.easybeans.deployment.annotations.exceptions.ResolverException;
import org.ow2.easybeans.deployment.annotations.helper.bean.InheritanceMethodResolver;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.naming.interceptors.ENCManager;
import org.ow2.util.ee.metadata.common.api.struct.IJInterceptors;
import org.ow2.util.ee.metadata.ejbjar.api.IJClassInterceptor;
import org.ow2.util.ee.metadata.ejbjar.api.InterceptorType;
import org.ow2.util.ee.metadata.ejbjar.impl.JClassInterceptor;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InterceptorsClassResolver {
    private static final JMethod EASYBEANS_INTERCEPTOR = new JMethod(0, "intercept", "(Lorg/ow2/easybeans/api/EasyBeansInvocationContext;)Ljava/lang/Object;", null, new String[]{"java/lang/Exception"});

    private InterceptorsClassResolver() {
    }

    public static void resolve(EasyBeansEjbJarClassMetadata classAnnotationMetadata, EZBServer ezbServer) throws ResolverException {
        ArrayList<String> easyBeansInterceptorsClasses = new ArrayList<String>();
        easyBeansInterceptorsClasses.add(Type.getInternalName(ENCManager.getInterceptorClass()));
        if (ezbServer != null) {
            for (Class clazz : ezbServer.getGlobalInterceptorsClasses()) {
                easyBeansInterceptorsClasses.add(Type.getInternalName(clazz));
            }
        }
        ArrayList<JClassInterceptor> easyBeansGlobalInterceptors = new ArrayList<JClassInterceptor>();
        for (String easyBeansInterceptor : easyBeansInterceptorsClasses) {
            easyBeansGlobalInterceptors.add(new JClassInterceptor(easyBeansInterceptor, EASYBEANS_INTERCEPTOR));
        }
        classAnnotationMetadata.setGlobalEasyBeansInterceptors(easyBeansGlobalInterceptors);
        EjbJarArchiveMetadata ejbJarDeployableMetadata = (EjbJarArchiveMetadata)classAnnotationMetadata.getEjbJarDeployableMetadata();
        IJInterceptors defaultInterceptorsClasses = ejbJarDeployableMetadata.getDefaultInterceptorsClasses();
        Map<InterceptorType, List<? extends IJClassInterceptor>> mapDefaultInterceptors = ejbJarDeployableMetadata.getDefaultInterceptors();
        if (mapDefaultInterceptors == null && defaultInterceptorsClasses != null && defaultInterceptorsClasses.size() > 0) {
            HashMap<InterceptorType, List<? extends IJClassInterceptor>> defaultInterceptors = new HashMap<InterceptorType, List<? extends IJClassInterceptor>>();
            defaultInterceptors.putAll(InterceptorsClassResolver.getInterceptors(classAnnotationMetadata.getClassName(), classAnnotationMetadata, defaultInterceptorsClasses.getClasses()));
            ejbJarDeployableMetadata.setDefaultInterceptors(defaultInterceptors);
        }
        ArrayList<String> externalInterceptorsClasses = new ArrayList<String>();
        LinkedList<EasyBeansEjbJarClassMetadata> invertedInheritanceClassesList = InterceptorsClassResolver.getInvertedSuperClassesMetadata(classAnnotationMetadata);
        for (EasyBeansEjbJarClassMetadata superMetaData : invertedInheritanceClassesList) {
            IJInterceptors classIinterceptors = superMetaData.getAnnotationInterceptors();
            if (classIinterceptors == null) continue;
            for (String cls : classIinterceptors.getClasses()) {
                externalInterceptorsClasses.add(cls);
            }
        }
        HashMap<InterceptorType, List<IJClassInterceptor>> externalMapClassInterceptors = new HashMap<InterceptorType, List<IJClassInterceptor>>();
        externalMapClassInterceptors.putAll(InterceptorsClassResolver.getInterceptors(classAnnotationMetadata.getClassName(), classAnnotationMetadata, externalInterceptorsClasses));
        classAnnotationMetadata.setExternalUserInterceptors(externalMapClassInterceptors);
        ArrayList<String> internalInterceptorsClasses = new ArrayList<String>();
        if (classAnnotationMetadata.isAroundInvokeMethodMetadata()) {
            internalInterceptorsClasses.add(classAnnotationMetadata.getClassName());
        }
        HashMap<InterceptorType, List<IJClassInterceptor>> internalMapClassInterceptors = new HashMap<InterceptorType, List<IJClassInterceptor>>();
        internalMapClassInterceptors.putAll(InterceptorsClassResolver.getInterceptors(classAnnotationMetadata.getClassName(), classAnnotationMetadata, internalInterceptorsClasses));
        classAnnotationMetadata.setInternalUserInterceptors(internalMapClassInterceptors);
        for (EasyBeansEjbJarMethodMetadata methodAnnotationMetaData : classAnnotationMetadata.getMethodMetadataCollection()) {
            IJInterceptors methodAnnotationInterceptors;
            Remove remove = methodAnnotationMetaData.getJRemove();
            if (remove != null) {
                ArrayList<JClassInterceptor> easyBeansMethodGlobalInterceptors = new ArrayList<JClassInterceptor>();
                String classType = null;
                classType = remove.retainIfException() ? Type.getInternalName(RemoveOnlyWithoutExceptionInterceptor.class) : Type.getInternalName(RemoveAlwaysInterceptor.class);
                easyBeansMethodGlobalInterceptors.add(new JClassInterceptor(classType, EASYBEANS_INTERCEPTOR));
                methodAnnotationMetaData.setGlobalEasyBeansInterceptors(easyBeansMethodGlobalInterceptors);
            }
            if ((methodAnnotationInterceptors = methodAnnotationMetaData.getAnnotationInterceptors()) == null) continue;
            ArrayList<String> methodInterceptorsClasses = new ArrayList<String>();
            for (String cls : methodAnnotationInterceptors.getClasses()) {
                methodInterceptorsClasses.add(cls);
            }
            Map<InterceptorType, List<IJClassInterceptor>> mapMethodInterceptors = InterceptorsClassResolver.getInterceptors(classAnnotationMetadata.getClassName() + "/Method " + methodAnnotationMetaData.getMethodName(), classAnnotationMetadata, methodInterceptorsClasses);
            HashMap<InterceptorType, List<IJClassInterceptor>> userInterceptors = new HashMap<InterceptorType, List<IJClassInterceptor>>();
            userInterceptors.putAll(mapMethodInterceptors);
            methodAnnotationMetaData.setUserInterceptors(userInterceptors);
        }
    }

    private static Map<InterceptorType, List<IJClassInterceptor>> getInterceptors(String referencingName, EasyBeansEjbJarClassMetadata classMetadata, List<String> interceptorsClasses) throws ResolverException {
        HashMap<InterceptorType, List<IJClassInterceptor>> mapInterceptors = new HashMap<InterceptorType, List<IJClassInterceptor>>();
        for (InterceptorType type : InterceptorType.values()) {
            mapInterceptors.put(type, new ArrayList());
        }
        int interceptorClassAnalyzed = 0;
        for (String className : interceptorsClasses) {
            EasyBeansEjbJarClassMetadata interceptorMetadata = (EasyBeansEjbJarClassMetadata)classMetadata.getLinkedClassMetadata(className);
            if (interceptorMetadata == null) {
                throw new ResolverException("No medata for interceptor class " + className + " referenced by " + referencingName);
            }
            ++interceptorClassAnalyzed;
            if (interceptorMetadata.getClassName().contains("$")) {
                throw new IllegalStateException("Interceptor can't be defined in an inner class.");
            }
            InheritanceMethodResolver.resolve(interceptorMetadata);
            LinkedList<EasyBeansEjbJarClassMetadata> invertedInheritanceClassesList = InterceptorsClassResolver.getInvertedSuperClassesMetadata(interceptorMetadata);
            for (EasyBeansEjbJarClassMetadata currentMetaData : invertedInheritanceClassesList) {
                for (EasyBeansEjbJarMethodMetadata method : currentMetaData.getMethodMetadataCollection()) {
                    boolean superMethodIsPrivate;
                    if (method.isInherited()) continue;
                    JClassInterceptor jInterceptor = new JClassInterceptor(className, method.getJMethod(), interceptorClassAnalyzed);
                    EasyBeansEjbJarMethodMetadata analyzedMethod = method;
                    EasyBeansEjbJarMethodMetadata methodSubClass = InterceptorsClassResolver.findLastRedefinedMethod(method, invertedInheritanceClassesList);
                    boolean bl = superMethodIsPrivate = (analyzedMethod.getJMethod().getAccess() & 2) == 2;
                    if (methodSubClass != null && !superMethodIsPrivate && !methodSubClass.isInherited()) {
                        analyzedMethod = methodSubClass;
                    }
                    if (methodSubClass != null && !methodSubClass.isInherited() && ((Object)((Object)((EasyBeansEjbJarClassMetadata)methodSubClass.getClassMetadata()))).equals((Object)interceptorMetadata) && superMethodIsPrivate && !((Object)((Object)currentMetaData)).equals((Object)interceptorMetadata) && !invertedInheritanceClassesList.contains((Object)classMetadata)) continue;
                    if (analyzedMethod.isAroundInvoke()) {
                        InterceptorsClassResolver.addOnlyIfNotPresent((List)mapInterceptors.get(InterceptorType.AROUND_INVOKE), jInterceptor);
                    }
                    if (currentMetaData.isBean() || invertedInheritanceClassesList.contains((Object)classMetadata)) continue;
                    if (analyzedMethod.isPostActivate()) {
                        InterceptorsClassResolver.addOnlyIfNotPresent((List)mapInterceptors.get(InterceptorType.POST_ACTIVATE), jInterceptor);
                    }
                    if (analyzedMethod.isPostConstruct()) {
                        InterceptorsClassResolver.addOnlyIfNotPresent((List)mapInterceptors.get(InterceptorType.POST_CONSTRUCT), jInterceptor);
                    }
                    if (analyzedMethod.isPreDestroy()) {
                        InterceptorsClassResolver.addOnlyIfNotPresent((List)mapInterceptors.get(InterceptorType.PRE_DESTROY), jInterceptor);
                    }
                    if (!analyzedMethod.isPrePassivate()) continue;
                    InterceptorsClassResolver.addOnlyIfNotPresent((List)mapInterceptors.get(InterceptorType.PRE_PASSIVATE), jInterceptor);
                }
            }
        }
        return mapInterceptors;
    }

    protected static EasyBeansEjbJarMethodMetadata findLastRedefinedMethod(EasyBeansEjbJarMethodMetadata method, LinkedList<EasyBeansEjbJarClassMetadata> classMetadatas) {
        ListIterator it = classMetadatas.listIterator();
        EasyBeansEjbJarMethodMetadata foundMethod = null;
        while (it.hasNext()) {
            EasyBeansEjbJarClassMetadata subClass = (EasyBeansEjbJarClassMetadata)((Object)it.next());
            EasyBeansEjbJarMethodMetadata subMethod = (EasyBeansEjbJarMethodMetadata)subClass.getMethodMetadata(method.getJMethod());
            if (subMethod == null || subMethod.isInherited()) continue;
            foundMethod = subMethod;
        }
        if (foundMethod != null) {
            return foundMethod;
        }
        return null;
    }

    private static void addOnlyIfNotPresent(List<IJClassInterceptor> interceptors, JClassInterceptor jInterceptor) {
        if (!interceptors.contains(jInterceptor)) {
            interceptors.add((IJClassInterceptor)jInterceptor);
        }
    }

    private static LinkedList<EasyBeansEjbJarClassMetadata> getInvertedSuperClassesMetadata(EasyBeansEjbJarClassMetadata classAnnotationMetadata) {
        LinkedList<EasyBeansEjbJarClassMetadata> superClassesList = new LinkedList<EasyBeansEjbJarClassMetadata>();
        String superClassName = classAnnotationMetadata.getSuperName();
        while (!"java/lang/Object".equals(superClassName)) {
            EasyBeansEjbJarClassMetadata superMetaData = (EasyBeansEjbJarClassMetadata)classAnnotationMetadata.getLinkedClassMetadata(superClassName);
            if (superMetaData != null) {
                superClassName = superMetaData.getSuperName();
                superClassesList.addFirst(superMetaData);
                continue;
            }
            superClassName = "java/lang/Object";
        }
        superClassesList.addLast(classAnnotationMetadata);
        return superClassesList;
    }
}

