/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.naming;

import org.ow2.easybeans.api.EZBContainerConfig;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.naming.BeanNamingInfo;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJCommonBean;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJLocal;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJRemote;

public final class BeanNamingInfoHelper {
    private BeanNamingInfoHelper() {
    }

    public static BeanNamingInfo buildInfo(EasyBeansEjbJarClassMetadata beanClassMetadata, String interfaceName, String mode, EZBContainerConfig containerConfig) {
        IJCommonBean commonBean = beanClassMetadata.getJCommonBean();
        String moduleName = containerConfig.getModuleName();
        String javaEEApplicationName = containerConfig.getApplicationName();
        int interfaceNumbers = 0;
        IJLocal localItfs = beanClassMetadata.getLocalInterfaces();
        IJRemote remoteItfs = beanClassMetadata.getRemoteInterfaces();
        String remoteHome = beanClassMetadata.getRemoteHome();
        String localHome = beanClassMetadata.getLocalHome();
        if (localItfs != null) {
            interfaceNumbers += localItfs.getInterfaces().size();
        }
        if (remoteItfs != null) {
            interfaceNumbers += remoteItfs.getInterfaces().size();
        }
        if (remoteHome != null) {
            ++interfaceNumbers;
        }
        if (localHome != null) {
            ++interfaceNumbers;
        }
        if (beanClassMetadata.isLocalBean()) {
            ++interfaceNumbers;
        }
        BeanNamingInfo beanNamingInfo = new BeanNamingInfo();
        beanNamingInfo.setName(commonBean.getName());
        beanNamingInfo.setBeanClassName(beanClassMetadata.getClassName());
        beanNamingInfo.setInterfaceName(interfaceName);
        beanNamingInfo.setMode(mode);
        beanNamingInfo.setModuleName(moduleName);
        beanNamingInfo.setMappedName(commonBean.getMappedName());
        beanNamingInfo.setJavaEEApplicationName(javaEEApplicationName);
        beanNamingInfo.setSingleInterface(1 == interfaceNumbers);
        return beanNamingInfo;
    }
}

