/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.naming.context;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.ow2.easybeans.naming.context.BindingsImpl;
import org.ow2.easybeans.naming.context.JavaNameParser;
import org.ow2.easybeans.naming.context.NamingEnumerationImpl;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextImpl
implements Context {
    private static Log logger = LogFactory.getLog(ContextImpl.class);
    private Hashtable<Object, Object> environment = null;
    private Hashtable<String, Object> bindings = new Hashtable();
    private static NameParser myParser = new JavaNameParser();
    private String compId;

    public ContextImpl(String id, Hashtable<Object, Object> env) {
        this.environment = env != null ? (Hashtable)env.clone() : new Hashtable();
        this.compId = id;
    }

    public ContextImpl(String id) {
        this(id, new Hashtable<Object, Object>());
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        logger.debug((Object)"lookup {0}", new Object[]{name});
        CompositeName n = new CompositeName(name);
        if (n.size() < 1) {
            logger.debug((Object)"Empty name", new Object[0]);
            return this;
        }
        if (n.size() > 1) {
            String suffix = n.getSuffix(1).toString();
            Context subctx = this.lookupCtx(n.get(0));
            return subctx.lookup(suffix);
        }
        Object ret = this.bindings.get(name);
        if (ret == null) {
            logger.debug((Object)" {0} not found.", new Object[]{name});
            throw new NameNotFoundException(name);
        }
        if (ret instanceof LinkRef) {
            InitialContext ictx = new InitialContext();
            RefAddr ra = ((Reference)ret).get(0);
            try {
                ret = ictx.lookup((String)ra.getContent());
            }
            catch (Exception e) {
                NamingException ne = new NamingException(e.getMessage());
                ne.setRootCause(e);
                logger.error((Object)"unexpected exception {0}", new Object[]{e.getMessage(), e});
                throw ne;
            }
        }
        if (ret instanceof Reference) {
            try {
                Object o;
                ret = o = NamingManager.getObjectInstance(ret, n, this, this.environment);
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                NamingException ne = new NamingException(e.getMessage());
                ne.setRootCause(e);
                throw ne;
            }
            if (ret == null) {
                logger.error((Object)"Can not build an object with the reference {0}", new Object[]{name});
                throw new NamingException("Can not build an object with the reference '" + name + "'");
            }
        }
        return ret;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        logger.debug((Object)"bind {0}", new Object[]{name});
        CompositeName n = new CompositeName(name);
        if (n.size() < 1) {
            logger.error((Object)"CompNamingContext bind empty name ?", new Object[0]);
            throw new InvalidNameException("CompNamingContext cannot bind empty name");
        }
        if (n.size() == 1) {
            if (this.bindings.get(name) != null) {
                logger.error((Object)"CompNamingContext: trying to overbind", new Object[0]);
                throw new NameAlreadyBoundException("CompNamingContext: Use rebind to bind over a name");
            }
            this.bindings.put(name, obj);
        } else {
            Context subctx;
            String suffix = n.getSuffix(1).toString();
            try {
                subctx = this.lookupCtx(n.get(0));
            }
            catch (NameNotFoundException e) {
                subctx = this.createSubcontext(n.get(0));
            }
            subctx.bind(suffix, obj);
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        logger.debug((Object)"rebind {0}", new Object[]{name});
        CompositeName n = new CompositeName(name);
        if (n.size() < 1) {
            logger.error((Object)"CompNamingContext rebind empty name ?", new Object[0]);
            throw new InvalidNameException("CompNamingContext cannot rebind empty name");
        }
        if (n.size() == 1) {
            this.bindings.put(name, obj);
        } else {
            Context subctx;
            String suffix = n.getSuffix(1).toString();
            try {
                subctx = this.lookupCtx(n.get(0));
            }
            catch (NameNotFoundException e) {
                subctx = this.createSubcontext(n.get(0));
            }
            subctx.rebind(suffix, obj);
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void unbind(String name) throws NamingException {
        logger.debug((Object)"unbind {0}", new Object[]{name});
        CompositeName n = new CompositeName(name);
        if (n.size() < 1) {
            logger.error((Object)"CompNamingContext rebind empty name ?", new Object[0]);
            throw new InvalidNameException("CompNamingContext cannot unbind empty name");
        }
        if (n.size() == 1) {
            if (this.bindings.get(name) == null) {
                logger.error((Object)"CompNamingContext nothing to unbind", new Object[0]);
                throw new NameNotFoundException(name);
            }
            this.bindings.remove(name);
        } else {
            String suffix = n.getSuffix(1).toString();
            Context subctx = this.lookupCtx(n.get(0));
            subctx.unbind(suffix);
        }
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        logger.debug((Object)"CompNamingContext rename {0} in {1}", new Object[]{oldName, newName});
        Object obj = this.lookup(oldName);
        this.rebind(newName, obj);
        this.unbind(oldName);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        logger.debug((Object)"list {0}", new Object[]{name});
        if (name.length() == 0) {
            return new NamingEnumerationImpl(this.bindings);
        }
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            return ((Context)obj).list("");
        }
        throw new NotContextException(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        logger.debug((Object)"listBindings {0}", new Object[]{name});
        if (name.length() == 0) {
            return new BindingsImpl(this.bindings);
        }
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            return ((Context)obj).listBindings("");
        }
        logger.error((Object)"CompNamingContext: can only list a Context", new Object[0]);
        throw new NotContextException(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        logger.error((Object)"CompNamingContext try to destroySubcontext {0}", new Object[]{name});
        throw new OperationNotSupportedException("CompNamingContext: destroySubcontext");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        logger.debug((Object)"createSubcontext {0}", new Object[]{name});
        CompositeName n = new CompositeName(name);
        if (n.size() < 1) {
            logger.error((Object)"CompNamingContext createSubcontext with empty name ?", new Object[0]);
            throw new InvalidNameException("CompNamingContext cannot create empty Subcontext");
        }
        Context ctx = null;
        if (n.size() == 1) {
            ctx = new ContextImpl(this.compId, this.environment);
            this.bindings.put(name, ctx);
        } else {
            Context subctx;
            String suffix = n.getSuffix(1).toString();
            String newName = n.get(0);
            try {
                subctx = this.lookupCtx(newName);
            }
            catch (NameNotFoundException e) {
                subctx = this.createSubcontext(newName);
            }
            ctx = subctx.createSubcontext(suffix);
        }
        return ctx;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        logger.debug((Object)"lookupLink {0}", new Object[]{name});
        logger.error((Object)"CompNamingContext lookupLink not implemented yet!", new Object[0]);
        return this.lookup(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return myParser;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        logger.error((Object)"CompNamingContext composeName not implemented yet!", new Object[0]);
        throw new OperationNotSupportedException("CompNamingContext composeName");
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        logger.error((Object)"CompNamingContext composeName {0} {1}", new Object[]{name, prefix});
        throw new OperationNotSupportedException("CompNamingContext composeName");
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        logger.debug((Object)"removeFromEnvironment {0}", new Object[]{propName});
        if (this.environment == null) {
            return null;
        }
        return this.environment.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
        this.environment = null;
    }

    @Override
    public String getNameInNamespace() {
        return this.compId;
    }

    public void addBinding(String bindingName, Context context) {
        if (this.bindings.get(bindingName) != null) {
            throw new IllegalStateException("Binding named '" + bindingName + "' already exists.");
        }
        this.bindings.put(bindingName, context);
    }

    private Context lookupCtx(String name) throws NamingException {
        Object obj = this.bindings.get(name);
        if (obj == null) {
            throw new NameNotFoundException();
        }
        if (obj instanceof Context) {
            return (Context)obj;
        }
        throw new NameAlreadyBoundException(name);
    }
}

