/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.proxy.helper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.bean.proxy.EasyBeansNoInterfaceProxyBean;
import org.ow2.easybeans.container.session.stateful.StatefulSessionFactory;
import org.ow2.easybeans.enhancer.lib.ProxyClassEncoder;
import org.ow2.easybeans.proxy.client.AbsInvocationHandler;
import org.ow2.easybeans.proxy.client.ClientRPCInvocationHandler;
import org.ow2.easybeans.proxy.client.LocalCallInvocationHandler;
import org.ow2.easybeans.proxy.helper.ProxyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxyHelper {
    private ProxyHelper() {
    }

    public static <T> T getProxy(Factory<?, ?> factory, Class<T> interfaceClass, ProxyType proxyType) {
        EZBContainer container = factory.getContainer();
        EZBServer server = container.getConfiguration().getEZBServer();
        String containerID = container.getId();
        String factoryName = factory.getBeanInfo().getName();
        boolean isStateful = false;
        Long beanId = null;
        if (factory instanceof StatefulSessionFactory) {
            isStateful = true;
            beanId = (Long)((StatefulSessionFactory)factory).getCurrentBeanIDThreadLocal().get();
        }
        Integer serverID = server.getID();
        ClassLoader classLoader = interfaceClass.getClassLoader();
        EasyBeansNoInterfaceProxyBean proxyBean = null;
        AbsInvocationHandler handler = null;
        switch (proxyType) {
            case NO_INTERFACE: {
                String beanProxyClassName = ProxyClassEncoder.getProxyClassName(interfaceClass.getName().replace(".", "/")).replace("/", ".");
                Class<?> clz = null;
                try {
                    clz = classLoader.loadClass(beanProxyClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Cannot find the class '" + beanProxyClassName + "' in Classloader '" + classLoader + "'.", e);
                }
                handler = new LocalCallInvocationHandler(serverID, containerID, factoryName, isStateful);
                try {
                    proxyBean = (EasyBeansNoInterfaceProxyBean)clz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Unable to build an instance of the proxy '" + beanProxyClassName + "' in Classloader '" + classLoader + "'.", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Unable to build an instance of the proxy '" + beanProxyClassName + "' in Classloader '" + classLoader + "'.", e);
                }
                proxyBean.setInvocationHandler((InvocationHandler)handler);
                break;
            }
            case LOCAL: {
                handler = new LocalCallInvocationHandler(serverID, containerID, factoryName, isStateful);
                break;
            }
            case REMOTE: {
                handler = new ClientRPCInvocationHandler(containerID, factoryName, isStateful);
                try {
                    ((ClientRPCInvocationHandler)handler).setRMIEnv(new InitialContext().getEnvironment());
                    break;
                }
                catch (NamingException e) {
                    throw new IllegalArgumentException("Unable to get environment", e);
                }
            }
            default: {
                throw new IllegalStateException("No such type of proxy");
            }
        }
        handler.setBusinessObjectMode(true);
        handler.setInterfaceClass(interfaceClass);
        if (beanId != null) {
            handler.setBeanId(beanId);
        }
        switch (proxyType) {
            case NO_INTERFACE: {
                return (T)proxyBean;
            }
            case LOCAL: 
            case REMOTE: {
                return (T)Proxy.newProxyInstance(classLoader, new Class[]{interfaceClass}, (InvocationHandler)handler);
            }
        }
        throw new IllegalStateException("No such type of proxy");
    }
}

